/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;

public interface IPDFTableLayoutManager {
    public void startRow(IRowContent var1);

    public void updateRow(RowArea var1, int var2);

    public int getXPos(int var1);

    public void startCell(ICellContent var1);

    public int getCellWidth(int var1, int var2);

    public void resolveBorderConflict(CellArea var1);

    public boolean isCellVisible(ICellContent var1);

    public void updateUnresolvedCell(int var1, boolean var2);

    public TableLayoutInfo getLayoutInfo();

    static class 1 {
        static /* synthetic */ Class class$org$eclipse$birt$report$engine$layout$IPDFTableLayoutManager;
    }

    public static class TableLayoutInfo {
        protected int columnNumber;
        protected int tableWidth;
        protected int[] colWidth = null;
        protected int[] xPositions = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        public TableLayoutInfo(int[] colWidth) {
            this.colWidth = colWidth;
            this.columnNumber = colWidth.length;
            this.xPositions = new int[this.columnNumber];
            this.tableWidth = 0;
            for (int i = 0; i < this.columnNumber; ++i) {
                this.xPositions[i] = this.tableWidth;
                this.tableWidth += colWidth[i];
            }
        }

        public int getTableWidth() {
            return this.tableWidth;
        }

        public int getXPosition(int index) {
            return this.xPositions[index];
        }

        public int getCellWidth(int startColumn, int endColumn) {
            if (!$assertionsDisabled && startColumn >= endColumn) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.colWidth == null) {
                throw new AssertionError();
            }
            int sum = 0;
            for (int i = startColumn; i < endColumn; ++i) {
                sum += this.colWidth[i];
            }
            return sum;
        }

        static {
            $assertionsDisabled = !(1.class$org$eclipse$birt$report$engine$layout$IPDFTableLayoutManager == null ? (1.class$org$eclipse$birt$report$engine$layout$IPDFTableLayoutManager = 1.class$("org.eclipse.birt.report.engine.layout.IPDFTableLayoutManager")) : 1.class$org$eclipse$birt$report$engine$layout$IPDFTableLayoutManager).desiredAssertionStatus();
        }
    }
}

