/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.area.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public abstract class ContainerArea
extends AbstractArea
implements IContainerArea {
    protected ArrayList children = new ArrayList();

    public int getContentX() {
        return PropertyUtil.getDimensionValue(this.style.getProperty(17)) + PropertyUtil.getDimensionValue(this.style.getProperty(36));
    }

    public int getContentY() {
        return PropertyUtil.getDimensionValue(this.style.getProperty(15)) + PropertyUtil.getDimensionValue(this.style.getProperty(56));
    }

    ContainerArea(IContent content) {
        super(content);
    }

    public Iterator getChildren() {
        return this.children.iterator();
    }

    public void addChild(IArea area) {
        this.children.add(area);
    }

    public void removeAll() {
        this.children.clear();
    }

    public void removeChild(IArea area) {
        this.children.remove(area);
    }

    public void accept(IAreaVisitor visitor) {
        visitor.startContainer(this);
        Iterator iter = this.getChildren();
        while (iter.hasNext()) {
            IArea child = (IArea)iter.next();
            child.accept(visitor);
        }
        visitor.endContainer(this);
    }

    protected void copyPropertyTo(ContainerArea area) {
        area.setPosition(this.x, this.y);
        area.setHeight(this.height);
        area.setWidth(this.width);
    }

    public int getChildrenCount() {
        return this.children.size();
    }
}

