/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.html.HTMLReportLayoutEngine;

public abstract class HTMLAbstractLM
implements ILayoutManager {
    protected static final int LAYOUT_MANAGER_UNKNOW = -1;
    protected static final int LAYOUT_MANAGER_LEAF = 0;
    protected static final int LAYOUT_MANAGER_BLOCK = 1;
    protected static final int LAYOUT_MANAGER_PAGE = 2;
    protected static final int LAYOUT_MANAGER_TABLE = 3;
    protected static final int LAYOUT_MANAGER_TABLE_BAND = 4;
    protected static final int LAYOUT_MANAGER_ROW = 5;
    protected static final int LAYOUT_MANAGER_LIST = 6;
    protected static final int LAYOUT_MANAGER_LIST_BAND = 7;
    protected static final int LAYOUT_MANAGER_GROUP = 8;
    protected static final int STATUS_INTIALIZE = 0;
    protected static final int STATUS_START = 1;
    protected static final int STATUS_INPROGRESS = 2;
    protected static final int STATUS_END = 3;
    protected static final int STATUS_END_WITH_PAGE_BREAK = 4;
    protected static Logger logger;
    protected HTMLReportLayoutEngine engine;
    protected HTMLLayoutContext context;
    protected HTMLAbstractLM parent;
    protected IContent content;
    protected IReportItemExecutor executor;
    protected IContentEmitter emitter;
    protected int status = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HTMLAbstractLM(HTMLLayoutManagerFactory factory) {
        this.engine = factory.getLayoutEngine();
        this.context = this.engine.getContext();
    }

    public int getType() {
        return -1;
    }

    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) {
        this.parent = parent;
        this.content = content;
        this.executor = executor;
        this.emitter = emitter;
        this.status = 0;
    }

    public HTMLAbstractLM getParent() {
        return this.parent;
    }

    protected void start() {
        if (this.emitter != null) {
            ContentEmitterUtil.startContent(this.content, this.emitter);
        }
    }

    protected void end() {
        if (this.emitter != null) {
            ContentEmitterUtil.endContent(this.content, this.emitter);
        }
    }

    public boolean layout() {
        switch (this.status) {
            case 0: {
                if (this.handleVisibility()) {
                    this.status = 3;
                    return false;
                }
                if (this.isPageBreakBefore()) {
                    this.status = 1;
                    this.context.endContentWithPageBreak(null);
                    return true;
                }
            }
            case 1: {
                this.context.startContent(this.content);
            }
            case 2: {
                if (this.status == 2) {
                    this.context.continueContent(this.content);
                }
                this.start();
                boolean hasNext = this.layoutChildren();
                this.end();
                this.status = this.isChildrenFinished() ? 3 : 2;
                if (hasNext) {
                    this.context.endContentWithPageBreak(this.content);
                    return true;
                }
                this.context.endContent(this.content);
                return this.isPageBreakAfter();
            }
        }
        return false;
    }

    protected abstract boolean layoutChildren();

    protected abstract boolean isChildrenFinished();

    public boolean isFinished() {
        return this.status == 3;
    }

    protected IContentEmitter getEmitter() {
        return this.emitter;
    }

    protected boolean isPageBreakBefore() {
        if (this.canPageBreak()) {
            return this.needPageBreakBefore();
        }
        return false;
    }

    protected boolean isPageBreakAfter() {
        if (this.canPageBreak()) {
            return this.needPageBreakAfter();
        }
        return false;
    }

    protected boolean allowPageBreak() {
        return true;
    }

    protected boolean canPageBreak() {
        if (!this.context.allowPageBreak()) {
            return false;
        }
        for (HTMLAbstractLM p = this.parent; p != null; p = p.getParent()) {
            if (p.allowPageBreak()) continue;
            return false;
        }
        return true;
    }

    protected boolean needPageBreakBefore() {
        if (this.content == null) {
            return false;
        }
        boolean ret = this.hasMasterPageChanged();
        IStyle style = this.content.getStyle();
        String pageBreak = style.getPageBreakBefore();
        if ("always" == pageBreak || "left" == pageBreak || "right" == pageBreak || "soft" == pageBreak) {
            style.setPageBreakBefore("auto");
            return true;
        }
        return ret;
    }

    protected boolean needPageBreakAfter() {
        if (this.content == null) {
            return false;
        }
        IStyle style = this.content.getStyle();
        String pageBreak = style.getPageBreakAfter();
        if ("always" == pageBreak || "left" == pageBreak || "right" == pageBreak) {
            style.setPageBreakAfter("auto");
            return true;
        }
        return false;
    }

    protected boolean hasMasterPageChanged() {
        MasterPageDesign masterPageDesign;
        PageSetupDesign pageSetup;
        if (this.content == null) {
            return false;
        }
        IStyle style = this.content.getStyle();
        if (style == null) {
            return false;
        }
        String newMasterPage = style.getMasterPage();
        if (newMasterPage == null || "".equals(newMasterPage)) {
            return false;
        }
        String masterPage = this.context.getMasterPage();
        if (!newMasterPage.equalsIgnoreCase(masterPage) && (pageSetup = this.content.getReportContent().getDesign().getPageSetup()).getMasterPageCount() > 0 && (masterPageDesign = pageSetup.findMasterPage(newMasterPage)) != null) {
            this.context.setMasterPage(newMasterPage);
            return true;
        }
        return false;
    }

    protected MasterPageDesign getMasterPage(IReportContent report) {
        String masterPage = this.context.getMasterPage();
        MasterPageDesign pageDesign = null;
        if (masterPage != null && !"".equals(masterPage) && (pageDesign = report.getDesign().findMasterPage(masterPage)) != null) {
            return pageDesign;
        }
        return this.getDefaultMasterPage(report);
    }

    private MasterPageDesign getDefaultMasterPage(IReportContent report) {
        PageSetupDesign pageSetup = report.getDesign().getPageSetup();
        int pageCount = pageSetup.getMasterPageCount();
        if (pageCount > 0) {
            return pageSetup.getMasterPage(0);
        }
        return null;
    }

    private boolean isHidden(IContent content) {
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        IStyle style = content.getStyle();
        String formats = style.getVisibleFormat();
        return formats != null && (formats.indexOf("viewer") >= 0 || formats.indexOf("all") >= 0);
    }

    protected boolean handleVisibility() {
        if (!$assertionsDisabled && this.content == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.executor == null) {
            throw new AssertionError();
        }
        if (this.isHidden(this.content)) {
            this.traverse(this.executor);
            return true;
        }
        return false;
    }

    private void traverse(IReportItemExecutor executor) {
        if (!$assertionsDisabled && executor == null) {
            throw new AssertionError();
        }
        while (executor.hasNextChild()) {
            IReportItemExecutor child = executor.getNextChild();
            if (child == null) continue;
            child.execute();
            this.traverse(child);
            child.close();
        }
    }

    protected void execute(IContent content, IReportItemExecutor executor) {
        if (!$assertionsDisabled && executor == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        while (executor.hasNextChild()) {
            IReportItemExecutor childExecutor = executor.getNextChild();
            if (childExecutor == null) continue;
            IContent childContent = childExecutor.execute();
            if (childContent != null && !content.getChildren().contains(childContent)) {
                content.getChildren().add(childContent);
            }
            this.execute(childContent, childExecutor);
            childExecutor.close();
        }
    }

    public void close() {
    }

    public void cancel() {
        this.status = 3;
    }

    static {
        $assertionsDisabled = !HTMLAbstractLM.class.desiredAssertionStatus();
        logger = Logger.getLogger(HTMLAbstractLM.class.getName());
    }
}

