/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.content.BlockStackingExecutor;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public abstract class PDFBlockStackingLM
extends PDFStackingLM
implements IBlockStackingLayoutManager {
    protected IReportItemExecutor blockExecutor = null;

    protected void addChild(PDFAbstractLM child) {
        this.child = child;
    }

    public PDFBlockStackingLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IContentEmitter emitter, IReportItemExecutor executor) {
        super(context, parent, content, emitter, executor);
    }

    protected boolean traverseChildren() {
        boolean childBreak = false;
        if (this.child != null) {
            this.child.setEmitter(this.emitter);
            childBreak = this.child.layout();
            if (childBreak) {
                if (this.child.isFinished()) {
                    this.child = null;
                }
                return true;
            }
        }
        if (this.blockExecutor == null) {
            this.blockExecutor = this.createExecutor();
        }
        while (this.blockExecutor.hasNextChild()) {
            IReportItemExecutor childExecutor = this.blockExecutor.getNextChild();
            if (childExecutor == null || !this.layoutChildNode(childExecutor)) continue;
            return true;
        }
        return false;
    }

    protected IReportItemExecutor createExecutor() {
        return new BlockStackingExecutor(this.content, this.executor);
    }

    private boolean layoutChildNode(IReportItemExecutor childExecutor) {
        boolean childBreak = false;
        IContent childContent = childExecutor.execute();
        PDFAbstractLM childLM = this.getFactory().createLayoutManager(this, childContent, this.emitter, childExecutor);
        childBreak = childLM.layout();
        if (childBreak && !childLM.isFinished()) {
            this.child = childLM;
        }
        return childBreak;
    }

    protected void newContext() {
        this.createRoot();
        if (null != this.parent) {
            int specifiedWidth;
            int max = this.parent.getMaxAvaWidth() - this.parent.getCurrentIP();
            if (this.content != null && (specifiedWidth = this.getDimensionValue(this.content.getWidth())) > 0) {
                max = Math.min(max, specifiedWidth);
            }
            this.root.setAllocatedWidth(max);
            this.setMaxAvaWidth(this.root.getContentWidth());
            this.root.setAllocatedHeight(this.parent.getMaxAvaHeight() - this.parent.getCurrentBP());
            this.setMaxAvaHeight(this.root.getContentHeight());
        }
        IStyle areaStyle = this.root.getStyle();
        this.setOffsetX(this.getDimensionValue(areaStyle.getProperty(17)) + this.getDimensionValue(areaStyle.getProperty(36)));
        this.setOffsetY(this.isFirst ? this.getDimensionValue(areaStyle.getProperty(15)) + this.getDimensionValue(areaStyle.getProperty(56)) : 0);
        this.setCurrentBP(0);
        this.setCurrentIP(0);
    }

    protected void closeLayout() {
        IStyle contentStyle = this.content.getComputedStyle();
        IStyle areaStyle = this.root.getStyle();
        if (this.isLast) {
            areaStyle.setProperty(19, contentStyle.getProperty(19));
            areaStyle.setProperty(13, contentStyle.getProperty(13));
            areaStyle.setProperty(24, contentStyle.getProperty(24));
            areaStyle.setProperty(52, contentStyle.getProperty(52));
        }
        this.root.setHeight(this.getCurrentBP() + this.getOffsetY() + this.getDimensionValue(contentStyle.getProperty(55)) + this.getDimensionValue(contentStyle.getProperty(19)));
    }

    public boolean addArea(IArea area) {
        if (area == null) {
            return true;
        }
        AbstractArea aArea = (AbstractArea)area;
        if (aArea.getAllocatedHeight() + this.getCurrentBP() <= this.getMaxAvaHeight() || this.isPageEmpty()) {
            aArea.setAllocatedPosition(this.getCurrentIP() + this.getOffsetX(), this.getCurrentBP() + this.getOffsetY());
            this.setCurrentBP(this.getCurrentBP() + aArea.getAllocatedHeight());
            this.root.addChild(area);
            return true;
        }
        return false;
    }

    public int getLineHeight() {
        if (this.content != null) {
            IStyle contentStyle = this.content.getComputedStyle();
            return PropertyUtil.getLineHeight(contentStyle.getLineHeight());
        }
        return 0;
    }

    public String getTextAlign() {
        if (this.content != null) {
            IStyle contentStyle = this.content.getComputedStyle();
            return contentStyle.getTextAlign();
        }
        return null;
    }

    public int getTextIndent() {
        if (this.content != null) {
            IStyle contentStyle = this.content.getComputedStyle();
            return this.getDimensionValue(contentStyle.getProperty(0));
        }
        return 0;
    }

    public boolean isInlineFlow() {
        return false;
    }

    protected void cancelChildren() {
        if (this.child != null) {
            this.child.cancel();
        }
    }
}

