/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.ILineStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFInlineStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFLineAreaLM
extends PDFInlineStackingLM
implements ILineStackingLayoutManager {
    private int baseLevel = 0;
    protected int lineCount = 0;
    protected int currentPosition = 0;
    protected boolean breakAfterRelayout = false;
    protected boolean lineFinished = true;
    protected HashMap positionMap = new HashMap();
    protected ContainerArea last = null;
    protected int expectedIP = 0;
    protected IReportItemExecutor unfinishedExecutor = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PDFLineAreaLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContentEmitter emitter, IReportItemExecutor executor) {
        super(context, parent, null, emitter, executor);
    }

    protected boolean submitRoot(boolean childBreak) {
        boolean submit = super.submitRoot(childBreak);
        if (submit || childBreak) {
            // empty if block
        }
        this.last = this.root;
        return submit;
    }

    protected boolean traverseChildren() {
        if (this.last != null) {
            this.parent.addArea(this.last);
            this.last = null;
            if (this.breakAfterRelayout) {
                this.breakAfterRelayout = false;
                return true;
            }
        }
        boolean childBreak = false;
        if (this.children.size() > 0) {
            Iterator iterLM = this.children.iterator();
            while (iterLM.hasNext()) {
                PDFAbstractLM childLM;
                this.child = childLM = (PDFAbstractLM)iterLM.next();
                boolean currentBreak = childLM.layout();
                if (currentBreak) {
                    childBreak = true;
                    continue;
                }
                iterLM.remove();
            }
            if (childBreak) {
                return true;
            }
            this.endLine();
        }
        boolean childHasNext = false;
        while (this.executor.hasNextChild() || this.unfinishedExecutor != null) {
            IReportItemExecutor childExecutor = null;
            if (this.unfinishedExecutor != null) {
                childExecutor = this.unfinishedExecutor;
                this.unfinishedExecutor = null;
            } else {
                childExecutor = this.executor.getNextChild();
            }
            if (!$assertionsDisabled && childExecutor == null) {
                throw new AssertionError();
            }
            childHasNext = this.handleChild(childExecutor) || childHasNext;
            if (!childHasNext || this.unfinishedExecutor == null || !this.lineFinished) continue;
            return true;
        }
        return childHasNext;
    }

    protected boolean handleChild(IReportItemExecutor childExecutor) {
        boolean childBreak = false;
        IContent childContent = childExecutor.execute();
        PDFAbstractLM childLM = this.getFactory().createLayoutManager(this, childContent, this.emitter, childExecutor);
        if (this.needLineBreak(childContent)) {
            this.unfinishedExecutor = childExecutor;
            return !this.endLine();
        }
        childBreak = childLM.layout();
        if (childBreak && !childLM.isFinished()) {
            this.addChild(childLM);
            if (this.currentIP < this.expectedIP) {
                this.currentIP = this.expectedIP;
            }
        }
        return childBreak;
    }

    protected void createRoot() {
        this.root = AreaFactory.createLineArea();
        ++this.lineCount;
    }

    protected void newContext() {
        this.createRoot();
        this.setMaxAvaWidth(this.parent.getMaxAvaWidth());
        this.setMaxAvaHeight(this.parent.getMaxAvaHeight() - this.parent.getCurrentBP());
        this.root.setWidth(this.getMaxAvaWidth());
        this.setCurrentBP(0);
        if (this.lineCount == 1) {
            if (!$assertionsDisabled && !(this.parent instanceof IBlockStackingLayoutManager)) {
                throw new AssertionError();
            }
            this.setCurrentIP(((PDFBlockStackingLM)this.parent).getTextIndent());
        } else {
            this.setCurrentIP(this.currentPosition);
        }
        this.setupMinHeight();
    }

    public boolean endLine() {
        this.updateLine();
        this.align();
        boolean ret = true;
        if (this.root.getChildrenCount() > 0) {
            ret = this.parent.addArea(this.root);
        }
        this.lineFinished = true;
        if (ret) {
            this.newContext();
            this.last = null;
            return true;
        }
        this.last = this.root;
        return false;
    }

    protected void closeLayout() {
        this.updateLine();
        this.align();
    }

    public boolean addArea(IArea area) {
        AbstractArea cArea = (AbstractArea)area;
        this.root.addChild(cArea);
        cArea.setAllocatedPosition(this.getCurrentIP(), this.getCurrentBP());
        this.setCurrentIP(this.getCurrentIP() + cArea.getAllocatedWidth());
        this.lineFinished = false;
        return true;
    }

    protected void setupMinHeight() {
        if (!$assertionsDisabled && !(this.parent instanceof PDFBlockStackingLM)) {
            throw new AssertionError();
        }
        int lineHeight = ((PDFBlockStackingLM)this.parent).getLineHeight();
        if (lineHeight > 0) {
            this.minHeight = lineHeight;
        }
    }

    protected void updateLine() {
        if (this.root == null) {
            return;
        }
        Iterator iter = this.root.getChildren();
        int height = this.root.getHeight();
        int lineHeight = ((PDFBlockStackingLM)this.parent).getLineHeight();
        while (iter.hasNext()) {
            AbstractArea child = (AbstractArea)iter.next();
            int childHeight = child.getAllocatedHeight();
            height = Math.max(height, childHeight);
        }
        height = Math.max(height, lineHeight);
        this.root.setContentHeight(height);
    }

    protected void align() {
        if (this.root == null) {
            return;
        }
        if (!$assertionsDisabled && !(this.parent instanceof PDFBlockStackingLM)) {
            throw new AssertionError();
        }
        String align = ((PDFBlockStackingLM)this.parent).getTextAlign();
        if ("right".equalsIgnoreCase(align) || "center".equalsIgnoreCase(align)) {
            int spacing = this.root.getContentWidth() - this.getCurrentIP();
            Iterator iter = this.root.getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                if ("right".equalsIgnoreCase(align)) {
                    area.setAllocatedPosition(spacing + area.getAllocatedX(), area.getAllocatedY());
                    continue;
                }
                if (!"center".equalsIgnoreCase(align)) continue;
                area.setAllocatedPosition(spacing / 2 + area.getAllocatedX(), area.getAllocatedY());
            }
        }
        Iterator iter = this.root.getChildren();
        int height = this.root.getHeight();
        while (iter.hasNext()) {
            AbstractArea child = (AbstractArea)iter.next();
            IStyle childStyle = child.getStyle();
            String vAlign = childStyle.getVerticalAlign();
            if (childStyle == null) continue;
            int spacing = height - child.getAllocatedHeight();
            if (!$assertionsDisabled && spacing < 0) {
                throw new AssertionError();
            }
            if ("bottom".equalsIgnoreCase(vAlign) || "baseline".equalsIgnoreCase(vAlign)) {
                child.setAllocatedPosition(child.getAllocatedX(), spacing + this.root.getContentY());
                continue;
            }
            if (!"middle".equalsIgnoreCase(vAlign)) continue;
            child.setAllocatedPosition(child.getAllocatedX(), spacing / 2 + this.root.getContentY());
        }
    }

    public void setBaseLevel(int baseLevel) {
        this.baseLevel = baseLevel;
    }

    public boolean isEmptyLine() {
        return this.isRootEmpty();
    }

    private boolean needLineBreak(IContent content) {
        int specWidth = 0;
        int avaWidth = this.getMaxAvaWidth() - this.getCurrentIP();
        int calWidth = this.getDimensionValue(content.getWidth());
        if (calWidth > 0 && calWidth < this.getMaxAvaWidth()) {
            specWidth = calWidth;
        }
        if (specWidth <= avaWidth && specWidth > 0) {
            this.expectedIP = this.currentIP + specWidth;
        }
        return specWidth > avaWidth;
    }

    static {
        $assertionsDisabled = !PDFLineAreaLM.class.desiredAssertionStatus();
    }
}

