/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.ITextArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.LogicContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.PageArea;
import org.eclipse.birt.report.engine.layout.content.BlockStackingExecutor;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockContainerLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFRegionLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.pdf.font.FontSplitter;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;
import org.eclipse.birt.report.engine.layout.pdf.text.ChunkGenerator;

public class PDFPageLM
extends PDFBlockContainerLM
implements IBlockStackingLayoutManager {
    static final int DEFAULT_PAGE_WIDTH = 595275;
    static final int DEFAULT_PAGE_HEIGHT = 841889;
    protected PageArea page;
    protected IReportContent report;
    protected IPageContent pageContent;
    protected IReportExecutor reportExecutor = null;
    protected PDFReportLayoutEngine engine;
    protected int pageNumber = 1;

    public PDFPageLM(PDFReportLayoutEngine engine, PDFLayoutEngineContext context, IReportContent report, IContentEmitter emitter, IReportExecutor executor) {
        super(context, null, null, emitter, null);
        this.reportExecutor = executor;
        this.engine = engine;
        this.report = report;
    }

    protected void newContext() {
        this.createRoot();
        this.context.setMaxHeight(this.page.getRoot().getHeight());
        this.context.setMaxWidth(this.page.getRoot().getWidth());
        this.layoutHeader();
        this.layoutFooter();
        this.updateBodySize(this.page);
        this.context.setMaxHeight(this.page.getBody().getHeight());
        this.context.setMaxWidth(this.page.getBody().getWidth());
        this.setMaxAvaWidth(this.context.getMaxWidth());
        this.setMaxAvaHeight(this.context.getMaxHeight());
        this.setCurrentIP(0);
        this.setCurrentBP(0);
    }

    protected void updateBodySize(PageArea page) {
        IContainerArea header = page.getHeader();
        ContainerArea footer = (ContainerArea)page.getFooter();
        ContainerArea body = (ContainerArea)page.getBody();
        ContainerArea root = (ContainerArea)page.getRoot();
        if (header != null && header.getHeight() >= root.getHeight()) {
            page.removeHeader();
            header = null;
        }
        if (footer != null && footer.getHeight() >= root.getHeight()) {
            page.removeHeader();
            footer = null;
        }
        if (header != null && footer != null && footer.getHeight() + header.getHeight() >= root.getHeight()) {
            page.removeFooter();
            page.removeHeader();
            header = null;
            footer = null;
        }
        body.setHeight(root.getHeight() - (header == null ? 0 : header.getHeight()) - (footer == null ? 0 : footer.getHeight()));
        body.setPosition(body.getX(), header == null ? 0 : header.getHeight());
        if (footer != null) {
            footer.setPosition(footer.getX(), (header == null ? 0 : header.getHeight()) + (body == null ? 0 : body.getHeight()));
        }
    }

    protected void layoutHeader() {
        IContent headerContent = this.pageContent.getPageHeader();
        DOMReportItemExecutor headerExecutor = new DOMReportItemExecutor(headerContent);
        headerExecutor.execute();
        PDFRegionLM regionLM = new PDFRegionLM(this.context, this.page.getHeader(), headerContent, this.emitter, (IReportItemExecutor)headerExecutor);
        boolean allowPB = this.context.allowPageBreak();
        this.context.setAllowPageBreak(false);
        regionLM.layout();
        this.context.setAllowPageBreak(allowPB);
    }

    protected void layoutFooter() {
        IContent footerContent = this.pageContent.getPageFooter();
        DOMReportItemExecutor footerExecutor = new DOMReportItemExecutor(footerContent);
        footerExecutor.execute();
        PDFRegionLM regionLM = new PDFRegionLM(this.context, this.page.getFooter(), footerContent, this.emitter, (IReportItemExecutor)footerExecutor);
        boolean allowPB = this.context.allowPageBreak();
        this.context.setAllowPageBreak(false);
        regionLM.layout();
        this.context.setAllowPageBreak(allowPB);
    }

    public void removeHeader() {
        this.page.removeHeader();
    }

    public void removeFooter() {
        this.page.removeFooter();
    }

    public void floatingFooter() {
        ContainerArea footer = (ContainerArea)this.page.getFooter();
        IContainerArea body = this.page.getBody();
        IContainerArea header = this.page.getHeader();
        if (footer != null) {
            footer.setPosition(footer.getX(), (header == null ? 0 : header.getHeight()) + (body == null ? 0 : body.getHeight()));
        }
    }

    public boolean layout() {
        if (!this.context.isCancel()) {
            boolean childBreak = true;
            this.start();
            childBreak = this.layoutChildren();
            if (!childBreak) {
                this.isLast = true;
            }
            this.end();
            return childBreak;
        }
        this.cancel();
        return false;
    }

    protected void pageBreakEvent() {
        ILayoutPageHandler pageHandler = this.engine.getPageHandler();
        if (pageHandler != null) {
            pageHandler.onPage(this.pageNumber, this.context);
        }
    }

    protected void start() {
        MasterPageDesign pageDesign = this.getMasterPage(this.report);
        this.pageContent = this.reportExecutor.createPage(this.pageNumber, pageDesign);
        this.content = this.pageContent;
    }

    protected void end() {
        MasterPageDesign mp;
        if (this.isPageEmpty()) {
            if (!this.isFirst) {
                if (this.isLast) {
                    --this.pageNumber;
                    this.resolveTotalPage();
                }
                return;
            }
            if (!this.isLast) {
                return;
            }
        }
        if ((mp = this.getMasterPage(this.report)) instanceof SimpleMasterPageDesign) {
            if (this.isFirst && !((SimpleMasterPageDesign)mp).isShowHeaderOnFirst()) {
                this.removeHeader();
                this.isFirst = false;
            }
            if (this.isLast && !((SimpleMasterPageDesign)mp).isShowFooterOnLast()) {
                this.removeFooter();
            }
            if (((SimpleMasterPageDesign)mp).isFloatingFooter()) {
                this.floatingFooter();
            }
        }
        if (this.isFirst) {
            this.isFirst = false;
        }
        this.getEmitter().startPage(this.pageContent);
        this.getEmitter().endPage(this.pageContent);
        this.pageBreakEvent();
        if (this.isLast) {
            this.resolveTotalPage();
        }
        ++this.pageNumber;
    }

    public boolean isPageEmpty() {
        IContainerArea body;
        return this.page == null || (body = this.page.getBody()).getChildrenCount() <= 0;
    }

    protected void resolveTotalPage() {
        IContent con = this.context.getUnresolvedContent();
        if (!(con instanceof IAutoTextContent)) {
            return;
        }
        IAutoTextContent totalPageContent = (IAutoTextContent)con;
        if (null != totalPageContent) {
            FontSplitter fontSplitter;
            NumberFormatter nf = new NumberFormatter();
            String patternStr = totalPageContent.getComputedStyle().getNumberFormat();
            nf.applyPattern(patternStr);
            totalPageContent.setText(nf.format((long)this.pageNumber));
            ITextArea totalPageArea = null;
            ChunkGenerator cg = new ChunkGenerator(totalPageContent);
            if (cg.hasMore() && (fontSplitter = new FontSplitter(cg.getNext(), totalPageContent)).hasMore()) {
                Chunk c = fontSplitter.getNext();
                Dimension d = new Dimension((int)(c.getFontInfo().getWordWidth(c.getText()) * 1000.0f), (int)(c.getFontInfo().getWordHeight() * 1000.0f));
                totalPageArea = (ITextArea)AreaFactory.createBlockTextArea(c.getText(), totalPageContent, 0, c.getText().length(), c.getFontInfo(), d);
            }
            totalPageContent.setExtension(1, totalPageArea);
            this.getEmitter().startAutoText(totalPageContent);
        }
    }

    protected void createRoot() {
        this.root = new PageArea(this.pageContent);
        this.page = (PageArea)this.root;
        int pageWidth = this.getDimensionValue(this.pageContent.getPageWidth());
        int pageHeight = this.getDimensionValue(this.pageContent.getPageHeight());
        if (pageWidth <= 0 || pageHeight <= 0) {
            pageWidth = 595275;
            pageHeight = 841889;
        }
        this.page.setWidth(pageWidth);
        this.page.setHeight(pageHeight);
        LogicContainerArea pageRoot = new LogicContainerArea();
        int rootLeft = this.getDimensionValue(this.pageContent.getMarginLeft(), pageWidth);
        int rootTop = this.getDimensionValue(this.pageContent.getMarginTop(), pageWidth);
        rootLeft = Math.max(0, rootLeft);
        rootLeft = Math.min(pageWidth, rootLeft);
        rootTop = Math.max(0, rootTop);
        rootTop = Math.min(pageHeight, rootTop);
        pageRoot.setPosition(rootLeft, rootTop);
        int rootRight = this.getDimensionValue(this.pageContent.getMarginRight(), pageWidth);
        int rootBottom = this.getDimensionValue(this.pageContent.getMarginBottom(), pageWidth);
        rootRight = Math.max(0, rootRight);
        rootBottom = Math.max(0, rootBottom);
        if (rootLeft + rootRight > pageWidth) {
            rootRight = 0;
        }
        if (rootTop + rootBottom > pageHeight) {
            rootBottom = 0;
        }
        pageRoot.setWidth(pageWidth - rootLeft - rootRight);
        pageRoot.setHeight(pageHeight - rootTop - rootBottom);
        this.page.setRoot(pageRoot);
        int headerHeight = this.getDimensionValue(this.pageContent.getHeaderHeight(), pageRoot.getHeight());
        int headerWidth = pageRoot.getWidth();
        headerHeight = Math.max(0, headerHeight);
        headerHeight = Math.min(pageRoot.getHeight(), headerHeight);
        LogicContainerArea header = new LogicContainerArea();
        header.setHeight(headerHeight);
        header.setWidth(headerWidth);
        header.setPosition(0, 0);
        pageRoot.addChild(header);
        this.page.setHeader(header);
        int footerHeight = this.getDimensionValue(this.pageContent.getFooterHeight(), pageRoot.getHeight());
        int footerWidth = pageRoot.getWidth();
        footerHeight = Math.max(0, footerHeight);
        footerHeight = Math.min(pageRoot.getHeight() - headerHeight, footerHeight);
        LogicContainerArea footer = new LogicContainerArea();
        footer.setHeight(footerHeight);
        footer.setWidth(footerWidth);
        footer.setPosition(0, pageRoot.getHeight() - footerHeight);
        pageRoot.addChild(footer);
        this.page.setFooter(footer);
        LogicContainerArea body = new LogicContainerArea();
        int bodyLeft = this.getDimensionValue(this.pageContent.getLeftWidth(), pageRoot.getWidth());
        bodyLeft = Math.max(0, bodyLeft);
        bodyLeft = Math.min(pageRoot.getWidth(), bodyLeft);
        body.setPosition(bodyLeft, headerHeight);
        int bodyRight = this.getDimensionValue(this.pageContent.getRightWidth(), pageRoot.getWidth());
        bodyRight = Math.max(0, bodyRight);
        bodyRight = Math.min(pageRoot.getWidth() - bodyLeft, bodyRight);
        body.setWidth(pageRoot.getWidth() - bodyLeft - bodyRight);
        body.setHeight(pageRoot.getHeight() - headerHeight - footerHeight);
        this.page.setBody(body);
        pageRoot.addChild(body);
    }

    protected IReportItemExecutor createExecutor() {
        return new BlockStackingExecutor(this.content, new PDFAbstractLM.ReportStackingExecutor(this.reportExecutor));
    }

    protected void closeLayout() {
    }

    protected boolean isRootEmpty() {
        IContainerArea body;
        return this.page == null || (body = this.page.getBody()).getChildrenCount() <= 0 && !this.isFirst;
    }
}

