/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.pdf.PDFPageLM;
import org.eclipse.birt.report.engine.layout.pdf.font.FontHandler;

public class PDFReportLayoutEngine
implements IReportLayoutEngine {
    protected IReportExecutor executor;
    protected PDFLayoutEngineContext context = new PDFLayoutEngineContext(this);
    protected PDFLayoutManagerFactory factory = new PDFLayoutManagerFactory(this.context);
    protected ILayoutPageHandler handle;

    public PDFReportLayoutEngine() {
        this.context.setFactory(this.factory);
    }

    protected PDFLayoutManagerFactory createLayoutManagerFactory(PDFLayoutEngineContext context) {
        return new PDFLayoutManagerFactory(this.context);
    }

    protected void layoutReport(IReportContent report, IReportExecutor executor, IContentEmitter output) {
        if (output == null) {
            return;
        }
        FontHandler.prepareFonts();
        PDFPageLM pageLM = new PDFPageLM(this, this.context, report, output, executor);
        while (pageLM.layout()) {
        }
    }

    public void layout(IReportExecutor executor, IContentEmitter output, boolean pagination) {
        this.context.setAllowPageBreak(pagination);
        this.executor = executor;
        IReportContent report = executor.execute();
        if (output != null) {
            output.start(report);
        }
        this.layoutReport(report, executor, output);
        if (output != null) {
            output.end(report);
        }
        executor.close();
    }

    public void layout(IReportItemExecutor executor, IContentEmitter emitter) {
        IContent content = executor.execute();
        PDFAbstractLM layoutManager = this.factory.createLayoutManager(null, content, emitter, executor);
        layoutManager.layout();
        layoutManager.close();
    }

    public void layout(IContent content, IContentEmitter output) {
        DOMReportItemExecutor executor = new DOMReportItemExecutor(content);
        this.layout(executor, output);
        executor.close();
    }

    public void setPageHandler(ILayoutPageHandler handle) {
        this.handle = handle;
    }

    public ILayoutPageHandler getPageHandler() {
        return this.handle;
    }

    public void cancel() {
        if (this.context != null) {
            this.context.setCancel(true);
        }
    }
}

