/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFTextInlineBlockLM
extends PDFBlockStackingLM
implements IBlockStackingLayoutManager {
    public PDFTextInlineBlockLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IContentEmitter emitter, IReportItemExecutor executor) {
        super(context, parent, content, emitter, executor);
    }

    protected void newContext() {
        this.createRoot();
        IStyle areaStyle = this.root.getStyle();
        this.setOffsetX(this.getDimensionValue(areaStyle.getProperty(17)) + this.getDimensionValue(areaStyle.getProperty(36)));
        this.setOffsetY(this.isFirst ? this.getDimensionValue(areaStyle.getProperty(15)) + this.getDimensionValue(areaStyle.getProperty(56)) : 0);
        if (null != this.parent) {
            int maxWidth = this.parent.getMaxAvaWidth();
            int leftWidth = maxWidth - this.parent.getCurrentIP();
            int specifiedWidth = 0;
            int width = 0;
            if (this.content != null) {
                specifiedWidth = this.getDimensionValue(this.content.getWidth());
            }
            width = specifiedWidth > 0 ? Math.min(specifiedWidth, maxWidth) : (leftWidth > maxWidth / 4 ? leftWidth : maxWidth);
            this.root.setAllocatedWidth(width);
            this.setMaxAvaWidth(this.root.getContentWidth());
            this.root.setAllocatedHeight(this.parent.getMaxAvaHeight() - this.parent.getCurrentBP());
            this.setMaxAvaHeight(this.root.getContentHeight());
        }
        this.setCurrentBP(0);
        this.setCurrentIP(0);
    }

    protected void createRoot() {
        this.root = (ContainerArea)AreaFactory.createBlockContainer(this.content);
    }
}

