/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FontConfigReader {
    private static final String CONFIG_FILE_PATH = "/fontsConfig.xml";
    private static final String TAG_MAPPING = "mapping";
    private static final String TAG_PATH = "path";
    private static final String TAG_ENCODING = "encoding";
    private static final String PROP_NAME = "name";
    private static final String PROP_FONT_FAMILY = "font-family";
    private static final String PROP_ENCODING = "encoding";
    private static final String PROP_PATH = "path";
    private HashMap fontMapping = new HashMap();
    private HashMap fontEncoding = new HashMap();
    private ArrayList fontPaths = new ArrayList();
    protected static Logger logger = Logger.getLogger(FontConfigReader.class.getName());

    public boolean parseConfigFile() {
        try {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.birt.report.engine.fonts");
            Path path = new Path(CONFIG_FILE_PATH);
            URL fileURL = FileLocator.find((Bundle)bundle, (IPath)path, null);
            if (null == fileURL) {
                return false;
            }
            InputStream cfgFile = fileURL.openStream();
            InputStreamReader r = new InputStreamReader((InputStream)new BufferedInputStream(cfgFile), Charset.forName("UTF-8"));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(r));
            this.handleFontMappings(doc);
            this.handleFontPaths(doc);
            this.handleFontEncodings(doc);
            return true;
        }
        catch (SAXException se) {
            logger.log(Level.WARNING, se.getMessage(), se);
            return false;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe.getMessage(), ioe);
            return false;
        }
        catch (ParserConfigurationException pce) {
            logger.log(Level.WARNING, pce.getMessage(), pce);
            return false;
        }
    }

    public String getEmbededFontPath() {
        Path path;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.birt.report.engine.fonts");
        URL fileURL = FileLocator.find((Bundle)bundle, (IPath)(path = new Path("/fonts")), null);
        if (null == fileURL) {
            return null;
        }
        String fontPath = null;
        try {
            fontPath = FileLocator.toFileURL((URL)fileURL).getPath();
            return fontPath.substring(1);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe.getMessage(), ioe);
            return null;
        }
    }

    public List getTrueTypeFontPaths() {
        return this.fontPaths;
    }

    public HashMap getFontMapping() {
        return this.fontMapping;
    }

    public HashMap getFontEncoding() {
        return this.fontEncoding;
    }

    private void handleFontEncodings(Document doc) {
        NodeList encodings = doc.getDocumentElement().getElementsByTagName("encoding");
        for (int i = 0; i < encodings.getLength(); ++i) {
            Node node = encodings.item(i);
            String fontFamily = this.getProperty(node, PROP_FONT_FAMILY);
            String encoding = this.getProperty(node, "encoding");
            if (!this.isValidValue(encoding) || !this.isValidValue(fontFamily)) continue;
            this.fontEncoding.put(fontFamily, encoding);
        }
    }

    private void handleFontPaths(Document doc) {
        NodeList paths = doc.getDocumentElement().getElementsByTagName("path");
        for (int i = 0; i < paths.getLength(); ++i) {
            Node node = paths.item(i);
            String path = this.getProperty(node, "path");
            if (!this.isValidValue(path)) continue;
            this.fontPaths.add(path);
        }
    }

    private void handleFontMappings(Document doc) {
        NodeList mappings = doc.getDocumentElement().getElementsByTagName(TAG_MAPPING);
        for (int i = 0; i < mappings.getLength(); ++i) {
            Node node = mappings.item(i);
            String name = this.getProperty(node, PROP_NAME);
            String fontFamily = this.getProperty(node, PROP_FONT_FAMILY);
            if (!this.isValidValue(name) || !this.isValidValue(fontFamily)) continue;
            this.fontMapping.put(name, fontFamily);
        }
    }

    private boolean isValidValue(String propertyName) {
        return null != propertyName && !"".equalsIgnoreCase(propertyName);
    }

    private String getProperty(Node node, String propertyName) {
        Node property;
        if (null == node) {
            return null;
        }
        NamedNodeMap atts = node.getAttributes();
        if (null != atts && null != (property = atts.getNamedItem(propertyName))) {
            return property.getNodeValue();
        }
        return null;
    }
}

