/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.pdf.font.FontConfigReader;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.w3c.dom.css.CSSValueList;

public class FontHandler {
    private static final String DEFAULT_SERIF_FONT = "Times-Roman";
    private static final String DEFAULT_SANS_SERIF_FONT = "Helvetica";
    private static final String DEFAULT_MONOSPACE_FONT = "Courier";
    private static final String DEFAULT_FANTASY_FONT = "ZapfDingbats";
    private static final String DEFAULT_FONT = "Times-Roman";
    private static final String SERIF = "serif";
    private static final String SANS_SERIF = "sans-serif";
    private static final String MONOSPACE = "monospace";
    private static final String FANTASY = "fantasy";
    private static HashMap fontMapping = null;
    private static HashMap fontEncoding = null;
    private CSSValueList fontFamilies = null;
    private int fontStyle = 0;
    private float fontSize = 0.0f;
    private BaseFont bf = null;
    private boolean isFontChanged = false;
    private BaseFont[] bfs = null;
    private boolean[] tried = null;
    private int lastFontNameIndex = -1;
    private boolean simulation = false;
    private static boolean prepared = false;

    public FontHandler(ITextContent textContent) {
        IStyle style = textContent.getComputedStyle();
        this.fontFamilies = (CSSValueList)style.getProperty(49);
        this.bfs = new BaseFont[this.fontFamilies.getLength() + 2];
        this.tried = new boolean[this.bfs.length];
        if ("oblique".equals(style.getFontStyle()) || "italic".equals(style.getFontStyle())) {
            this.fontStyle |= 2;
        }
        if (PropertyUtil.isBoldFont(style.getProperty(27))) {
            this.fontStyle |= 1;
        }
        this.fontSize = (float)PropertyUtil.getDimensionValue(style.getProperty(38)) / 1000.0f;
    }

    private static int registerDirectories() {
        int count = 0;
        count += FontFactory.registerDirectory((String)"C:/windows/fonts");
        count += FontFactory.registerDirectory((String)"d:/windows/fonts");
        count += FontFactory.registerDirectory((String)"e:/windows/fonts");
        count += FontFactory.registerDirectory((String)"f:/windows/fonts");
        count += FontFactory.registerDirectory((String)"g:/windows/fonts");
        count += FontFactory.registerDirectory((String)"C:/WINNT/fonts");
        count += FontFactory.registerDirectory((String)"d:/WINNT/fonts");
        count += FontFactory.registerDirectory((String)"e:/WINNT/fonts");
        count += FontFactory.registerDirectory((String)"f:/WINNT/fonts");
        count += FontFactory.registerDirectory((String)"g:/WINNT/fonts");
        count += FontFactory.registerDirectory((String)"/usr/X/lib/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/share/fonts/default/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/euro_fonts/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_2/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_5/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_7/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_8/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_9/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_13/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_15/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/ar/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/hi_IN.UTF-8/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/ja/X11/fonts/TT");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/ko/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/ko.UTF-8/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/KOI8-R/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/ru.ansi-1251/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/th_TH/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh_TW/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh_TW.BIG5/X11/fonts/TT");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh_HK.BIG5HK/X11/fonts/TT");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh_CN.GB18030/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh.GBK/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/X11R6/lib/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/X11R6/lib/X11/fonts/truetype");
        count += FontFactory.registerDirectory((String)"/usr/X11R6/lib/X11/fonts/tt");
        count += FontFactory.registerDirectory((String)"/usr/X11R6/lib/X11/fonts/TTF");
        count += FontFactory.registerDirectory((String)"/usr/X11R6/lib/X11/fonts/OTF");
        count += FontFactory.registerDirectory((String)"/usr/share/fonts/ja/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/share/fonts/truetype");
        count += FontFactory.registerDirectory((String)"/usr/share/fonts/ko/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/share/fonts/zh_CN/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/share/fonts/zh_TW/TrueType");
        return count += FontFactory.registerDirectory((String)"/var/lib/defoma/x-ttcidfont-conf.d/dirs/TrueType");
    }

    public static synchronized void prepareFonts() {
        if (prepared) {
            return;
        }
        FontConfigReader fcr = new FontConfigReader();
        String embededFontPath = fcr.getEmbededFontPath();
        if (null != embededFontPath) {
            FontFactory.registerDirectory((String)embededFontPath);
        }
        if (fcr.parseConfigFile()) {
            fontMapping = fcr.getFontMapping();
            fontEncoding = fcr.getFontEncoding();
            List fontPaths = fcr.getTrueTypeFontPaths();
            if (fontPaths.isEmpty()) {
                FontHandler.registerDirectories();
            } else {
                Iterator i = fontPaths.iterator();
                while (i.hasNext()) {
                    String fontPath = (String)i.next();
                    File file = new File(fontPath);
                    if (!file.exists()) continue;
                    if (file.isDirectory()) {
                        FontFactory.registerDirectory((String)fontPath);
                        continue;
                    }
                    FontFactory.register((String)fontPath);
                }
            }
        } else {
            FontHandler.registerDirectories();
        }
        FontHandler.addDefaultFontMapping();
        FontHandler.addDefaultFontEncoding();
        prepared = true;
    }

    private static void addDefaultFontMapping() {
        if (null == fontMapping) {
            fontMapping = new HashMap();
        }
        if (!fontMapping.containsKey(SERIF)) {
            fontMapping.put(SERIF, "Times-Roman");
        }
        if (!fontMapping.containsKey(SANS_SERIF)) {
            fontMapping.put(SANS_SERIF, DEFAULT_SANS_SERIF_FONT);
        }
        if (!fontMapping.containsKey(MONOSPACE)) {
            fontMapping.put(MONOSPACE, DEFAULT_MONOSPACE_FONT);
        }
        if (!fontMapping.containsKey(FANTASY)) {
            fontMapping.put(FANTASY, DEFAULT_FANTASY_FONT);
        }
    }

    private static void addDefaultFontEncoding() {
        if (null == fontEncoding) {
            fontEncoding = new HashMap();
        }
        if (!fontEncoding.containsKey("Times")) {
            fontEncoding.put("Times", "Cp1252");
        }
        if (!fontEncoding.containsKey("Times-Roman")) {
            fontEncoding.put("Times-Roman", "Cp1252");
        }
        if (!fontEncoding.containsKey(DEFAULT_SANS_SERIF_FONT)) {
            fontEncoding.put(DEFAULT_SANS_SERIF_FONT, "Cp1252");
        }
        if (!fontEncoding.containsKey(DEFAULT_MONOSPACE_FONT)) {
            fontEncoding.put(DEFAULT_MONOSPACE_FONT, "Cp1252");
        }
        if (!fontEncoding.containsKey("Symbol")) {
            fontEncoding.put("Symbol", "Cp1252");
        }
        if (!fontEncoding.containsKey(DEFAULT_FANTASY_FONT)) {
            fontEncoding.put(DEFAULT_FANTASY_FONT, "Cp1252");
        }
    }

    public FontInfo getFontInfo() {
        this.checkFontAvailability();
        return new FontInfo(this.bf, this.fontSize, this.fontStyle, this.simulation);
    }

    public boolean selectFont(char character) {
        for (int i = 0; i < this.fontFamilies.getLength(); ++i) {
            if (!this.tried[i]) {
                String fontFamilyName = this.fontFamilies.item(i).getCssText();
                String mappedFontFamily = this.getMappedFontFamily(fontFamilyName);
                this.bfs[i] = this.createFont(mappedFontFamily, this.getEncoding(mappedFontFamily));
                this.tried[i] = true;
            }
            if (null == this.bfs[i] || !this.bfs[i].charExists(character)) continue;
            if (this.lastFontNameIndex == i) {
                this.isFontChanged = false;
            } else {
                this.isFontChanged = true;
                this.bf = this.bfs[i];
                this.lastFontNameIndex = i;
            }
            return true;
        }
        String defaultFont = this.getMappedFontFamily("default");
        if (!this.tried[this.tried.length - 2]) {
            this.bfs[this.tried.length - 2] = this.createFont(defaultFont, this.getEncoding(defaultFont));
            this.tried[this.tried.length - 2] = true;
        }
        if (null != this.bfs[this.tried.length - 2] && this.bfs[this.tried.length - 2].charExists(character)) {
            if (this.lastFontNameIndex == this.tried.length - 2) {
                this.isFontChanged = false;
            } else {
                this.isFontChanged = true;
                this.bf = this.bfs[this.tried.length - 2];
                this.lastFontNameIndex = this.tried.length - 2;
            }
            return true;
        }
        if (!this.tried[this.tried.length - 1]) {
            this.bfs[this.tried.length - 1] = this.createFont("Times-Roman", this.getEncoding("Times-Roman"));
            this.tried[this.tried.length - 1] = true;
        }
        if (this.bfs[this.tried.length - 1].charExists(character)) {
            if (this.lastFontNameIndex == this.tried.length - 1) {
                this.isFontChanged = false;
            } else {
                this.isFontChanged = true;
                this.bf = this.bfs[this.tried.length - 1];
                this.lastFontNameIndex = this.tried.length - 1;
            }
            return true;
        }
        if (null == this.bf) {
            this.isFontChanged = true;
            this.bf = this.bfs[this.tried.length - 1];
            this.lastFontNameIndex = this.tried.length - 1;
        } else {
            this.isFontChanged = false;
        }
        return false;
    }

    public boolean isFontChanged() {
        return this.isFontChanged;
    }

    private String getMappedFontFamily(String fontFamilyName) {
        String mappedFontFamily = (String)fontMapping.get(fontFamilyName);
        return null == mappedFontFamily ? fontFamilyName : mappedFontFamily;
    }

    private String getEncoding(String fontFamilyName) {
        String encoding = (String)fontEncoding.get(fontFamilyName);
        return null == encoding ? "Identity-H" : encoding;
    }

    private String getEnglishName(String[][] names) {
        String tmp = null;
        for (int i = 0; i < names.length; ++i) {
            if ("0".equals(names[i][2])) {
                return names[i][3];
            }
            if ("1033".equals(names[i][2])) {
                tmp = names[i][3];
            }
            if (!"".equals(names[i][2])) continue;
            tmp = names[i][3];
        }
        return tmp;
    }

    private void checkFontAvailability() {
        this.simulation = this.fontStyle == 0 ? false : this.getEnglishName(this.bf.getFamilyFontName()).equals(this.getEnglishName(this.bf.getFullFontName()));
    }

    private BaseFont createFont(String ffn, String encoding) {
        Font f = FontFactory.getFont((String)ffn, (String)encoding, (boolean)true, (float)this.fontSize, (int)this.fontStyle);
        this.fontSize = f.getCalculatedSize();
        BaseFont bf = f.getBaseFont();
        return bf;
    }
}

