/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.tidy.Tidy;

public class HTMLTextParser {
    protected static Logger logger;
    protected static HashSet supportedTags;
    protected Tidy tidy = new Tidy();
    private static Pattern hn;
    private boolean supportAllTags = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HTMLTextParser() {
        try {
            Properties props = new Properties();
            props.load(this.getClass().getResourceAsStream("htmlparser.properties"));
            this.tidy.setConfigurationFromProps(props);
            this.supportAllTags = true;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public Document parseHTML(InputStream in) {
        if (!$assertionsDisabled && in == null) {
            throw new AssertionError();
        }
        Document doc = this.tidy.parseDOM(in, null);
        Document desDoc = null;
        try {
            desDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Node html = this.getNodeByName(doc, "html");
            Node body = null;
            if (html != null) {
                body = this.getNodeByName(html, "body");
            }
            Element desBody = desDoc.createElement("body");
            desDoc.appendChild(desBody);
            if (body != null) {
                this.copyNode(body, desBody);
            }
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        return desDoc;
    }

    private Node getNodeByName(Node parent, String childName) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !childName.equals(child.getNodeName())) continue;
            return child;
        }
        return null;
    }

    private void copyNode(Node srcNode, Node desNode) {
        if (!($assertionsDisabled || srcNode != null && desNode != null)) {
            throw new AssertionError();
        }
        for (Node child = srcNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                Text txtNode = desNode.getOwnerDocument().createTextNode(child.getNodeValue());
                desNode.appendChild(txtNode);
                continue;
            }
            if (child.getNodeType() != 1) continue;
            boolean bSupported = true;
            if (!(this.supportAllTags || supportedTags.contains(child.getNodeName()) || hn.matcher(child.getNodeName()).matches())) {
                bSupported = false;
            }
            if (bSupported) {
                Element ele = null;
                ele = desNode.getOwnerDocument().createElement(child.getNodeName());
                for (int i = 0; i < child.getAttributes().getLength(); ++i) {
                    Node attr = child.getAttributes().item(i);
                    ele.setAttribute(attr.getNodeName(), attr.getNodeValue());
                }
                desNode.appendChild(ele);
                this.copyNode(child, ele);
                continue;
            }
            this.copyNode(child, desNode);
        }
    }

    static {
        $assertionsDisabled = !HTMLTextParser.class.desiredAssertionStatus();
        logger = Logger.getLogger(HTMLTextParser.class.getName());
        supportedTags = new HashSet();
        supportedTags.add("a");
        supportedTags.add("b");
        supportedTags.add("br");
        supportedTags.add("center");
        supportedTags.add("code");
        supportedTags.add("dd");
        supportedTags.add("del");
        supportedTags.add("div");
        supportedTags.add("dl");
        supportedTags.add("dt");
        supportedTags.add("font");
        supportedTags.add("em");
        supportedTags.add("hr");
        supportedTags.add("i");
        supportedTags.add("img");
        supportedTags.add("ins");
        supportedTags.add("li");
        supportedTags.add("ol");
        supportedTags.add("pre");
        supportedTags.add("p");
        supportedTags.add("span");
        supportedTags.add("strong");
        supportedTags.add("sub");
        supportedTags.add("sup");
        supportedTags.add("ul");
        supportedTags.add("tt");
        supportedTags.add("u");
        hn = Pattern.compile("h[\\d]");
    }
}

