/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import com.ibm.icu.text.DecimalFormat;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.birt.report.engine.ir.ActionDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GraphicMasterPageDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.MultiLineItemDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.w3c.dom.css.CSSStyleDeclaration;

class ReportDesignWriter {
    static /* synthetic */ Class class$org$eclipse$birt$report$engine$parser$ReportDesignWriter;

    ReportDesignWriter() {
    }

    public void write(Writer writer, Report report, boolean hasStyle) {
        new ReportDumpVisitor(writer).writeReport(report, hasStyle);
    }

    private class ReportDumpVisitor
    extends DefaultReportItemVisitorImpl {
        protected PrintWriter out;
        protected boolean hasStyle;
        protected boolean endTag = true;
        protected DecimalFormat doubleFmt = new DecimalFormat("##.##");
        protected Stack tagStack = new Stack();
        static final /* synthetic */ boolean $assertionsDisabled;

        ReportDumpVisitor(Writer writer) {
            this.out = new PrintWriter(writer);
        }

        private void writeReportItem(ReportItemDesign item) {
            this.writeStyledElement(item);
            this.attribute("x", item.getX());
            this.attribute("y", item.getY());
            this.attribute("width", item.getWidth());
            this.attribute("height", item.getHeight());
        }

        private void writeStyledElement(StyledElementDesign item) {
            this.writeReportElement(item);
            if (this.hasStyle && item.getStyleName() != null) {
                this.attribute("style", item.getStyleName());
            }
        }

        private void writeReportElement(ReportElementDesign elem) {
            this.attribute("name", elem.getName());
            this.attribute("extends", elem.getExtends());
        }

        public void writeReport(Report report, boolean hasStyle) {
            int i;
            this.hasStyle = hasStyle;
            this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.pushTag("report");
            this.attribute("units", report.getUnit());
            if (hasStyle && report.getStyleCount() > 0) {
                this.pushTag("styles");
                for (i = 0; i < report.getStyleCount(); ++i) {
                    this.writeStyle(report.getStyle(i));
                }
                this.popTag();
            }
            this.writePageSetup(report.getPageSetup());
            if (report.getContentCount() > 0) {
                this.pushTag("body");
                for (i = 0; i < report.getContentCount(); ++i) {
                    report.getContent(i).accept(this, null);
                }
                this.popTag();
            }
            this.popTag();
            this.out.flush();
        }

        private void writePageSetup(PageSetupDesign pageSetup) {
            this.pushTag("page-setup");
            for (int i = 0; i < pageSetup.getMasterPageCount(); ++i) {
                this.writeMasterPage(pageSetup.getMasterPage(i));
            }
            this.popTag();
        }

        public Object visitListBand(ListBandDesign band, Object value) {
            this.pushTag("band");
            for (int i = 0; i < band.getContentCount(); ++i) {
                band.getContent(i).accept(this, value);
            }
            this.popTag();
            return value;
        }

        public Object visitTableBand(TableBandDesign band, Object value) {
            this.pushTag("band");
            for (int i = 0; i < band.getContentCount(); ++i) {
                band.getContent(i).accept(this, value);
            }
            this.popTag();
            return value;
        }

        private void writeMasterPage(MasterPageDesign page) {
            if (page instanceof GraphicMasterPageDesign) {
                this.writeGraphicMasterPage((GraphicMasterPageDesign)page);
            } else if (page instanceof SimpleMasterPageDesign) {
                this.writeSimpleMasterPage((SimpleMasterPageDesign)page);
            }
        }

        private void writeBaseMasterPage(MasterPageDesign page) {
            this.writeStyledElement(page);
            this.attribute("type", page.getPageType());
            this.attribute("width", page.getPageWidth());
            this.attribute("height", page.getPageHeight());
            this.attribute("orientation", page.getOrientation());
            this.attribute("top-margin", page.getTopMargin());
            this.attribute("bottom-margin", page.getBottomMargin());
            this.attribute("left-margin", page.getLeftMargin());
            this.attribute("right-margin", page.getRightMargin());
        }

        private void writeGraphicMasterPage(GraphicMasterPageDesign page) {
            this.pushTag("graphic-master-page");
            this.writeBaseMasterPage(page);
            this.attribute("columns", page.getColumns());
            this.attribute("column-spacing", page.getColumnSpacing());
            this.pushTag("contents");
            Iterator iter = page.getContents().iterator();
            while (iter.hasNext()) {
                ((ReportItemDesign)iter.next()).accept(this, null);
            }
            this.popTag();
            this.popTag();
        }

        private void writeSimpleMasterPage(SimpleMasterPageDesign page) {
            int i;
            this.pushTag("simple-master-page");
            this.writeBaseMasterPage(page);
            this.attribute("show-header-on-first", page.isShowHeaderOnFirst());
            this.attribute("show-footer-on-last", page.isShowFooterOnLast());
            this.attribute("floating-footer", page.isFloatingFooter());
            this.pushTag("header");
            for (i = 0; i < page.getHeaderCount(); ++i) {
                page.getHeader(i).accept(this, null);
            }
            this.popTag();
            this.pushTag("footer");
            for (i = 0; i < page.getFooterCount(); ++i) {
                page.getFooter(i).accept(this, null);
            }
            this.popTag();
            this.popTag();
        }

        private void writeStyle(CSSStyleDeclaration style) {
            if (style != null) {
                this.pushTag("style");
                this.text(style.getCssText());
                this.popTag();
            }
        }

        public Object visitGroup(GroupDesign group, Object value) {
            this.pushTag("group");
            if (group.getHeader() != null) {
                group.getHeader().accept(this, value);
            }
            if (group.getFooter() != null) {
                group.getFooter().accept(this, value);
            }
            this.popTag();
            return value;
        }

        public Object visitTextItem(TextItemDesign text, Object value) {
            this.pushTag("text");
            this.writeReportItem(text);
            this.attribute("content-type", text.getTextType());
            this.attribute("resource-key", text.getTextKey());
            this.text(text.getText());
            this.popTag();
            return value;
        }

        public Object visitMultiLineItem(MultiLineItemDesign multiLine, Object value) {
            this.pushTag("multi-line");
            this.writeReportItem(multiLine);
            this.pushTag("content-type");
            this.text(multiLine.getContentType());
            this.popTag();
            this.pushTag("content");
            this.text(multiLine.getContent());
            this.popTag();
            this.popTag();
            return value;
        }

        public Object visitListItem(ListItemDesign list, Object value) {
            this.pushTag("list");
            this.writeReportItem(list);
            if (list.getHeader() != null) {
                list.getHeader().accept(this, value);
            }
            for (int i = 0; i < list.getGroupCount(); ++i) {
                list.getGroup(i).accept(this, value);
            }
            if (list.getDetail() != null) {
                list.getDetail().accept(this, value);
            }
            if (list.getFooter() != null) {
                list.getFooter().accept(this, value);
            }
            this.popTag();
            return value;
        }

        public Object visitDataItem(DataItemDesign data, Object value) {
            this.pushTag("data");
            this.writeReportItem(data);
            this.text(data.getValue());
            this.popTag();
            return value;
        }

        public Object visitLabelItem(LabelItemDesign label, Object value) {
            this.pushTag("label");
            this.writeReportItem(label);
            this.attribute("resource-key", label.getTextKey());
            this.text(label.getText());
            this.popTag();
            return value;
        }

        public Object visitGridItem(GridItemDesign grid, Object value) {
            int i;
            this.pushTag("grid");
            this.writeReportItem(grid);
            for (i = 0; i < grid.getColumnCount(); ++i) {
                this.writeColumn(grid.getColumn(i));
            }
            for (i = 0; i < grid.getRowCount(); ++i) {
                this.writeRow(grid.getRow(i));
            }
            this.popTag();
            return value;
        }

        protected void writeColumn(ColumnDesign column) {
            this.pushTag("column");
            this.writeStyledElement(column);
            this.attribute("width", column.getWidth());
            this.popTag();
        }

        protected void writeRow(RowDesign row) {
            this.pushTag("row");
            this.writeStyledElement(row);
            this.attribute("height", row.getHeight());
            for (int i = 0; i < row.getCellCount(); ++i) {
                this.writeCell(row.getCell(i));
            }
            this.popTag();
        }

        protected void writeCell(CellDesign cell) {
            this.pushTag("cell");
            this.writeStyledElement(cell);
            this.attribute("column", cell.getColumn());
            this.attribute("col-span", cell.getColSpan(), 1.0);
            this.attribute("row-span", cell.getRowSpan(), 1.0);
            this.attribute("height", cell.getHeight());
            this.attribute("width", cell.getWidth());
            this.attribute("drop", cell.getDrop());
            for (int i = 0; i < cell.getContentCount(); ++i) {
                cell.getContent(i).accept(this, null);
            }
            this.popTag();
        }

        public Object visitTableItem(TableItemDesign table, Object value) {
            int i;
            this.pushTag("table");
            this.writeReportItem(table);
            if (table.getCaption() != null || table.getCaptionKey() != null) {
                this.pushTag("caption");
                this.attribute("resource-key", table.getCaptionKey());
                this.text(table.getCaption());
                this.popTag();
            }
            for (i = 0; i < table.getColumnCount(); ++i) {
                this.writeColumn(table.getColumn(i));
            }
            if (table.getHeader() != null) {
                table.getHeader().accept(this, value);
            }
            for (i = 0; i < table.getGroupCount(); ++i) {
                table.getGroup(i).accept(this, value);
            }
            if (table.getDetail() != null) {
                table.getDetail().accept(this, value);
            }
            if (table.getFooter() != null) {
                table.getFooter().accept(this, value);
            }
            this.popTag();
            return value;
        }

        public Object visitImageItem(ImageItemDesign image, Object value) {
            this.pushTag("image");
            this.writeReportItem(image);
            switch (image.getImageSource()) {
                case 1: {
                    this.pushTag("image-name");
                    this.text(image.getImageName());
                    this.popTag();
                    break;
                }
                case 0: {
                    this.pushTag("uri");
                    this.text(image.getImageUri());
                    this.popTag();
                    break;
                }
                case 3: {
                    this.pushTag("uri");
                    this.text(image.getImageUri());
                    this.popTag();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            if (image.getAction() != null) {
                this.writeAction(image.getAction());
            }
            this.popTag();
            return value;
        }

        protected void writeAction(ActionDesign action) {
            this.pushTag("action");
            switch (action.getActionType()) {
                case 2: {
                    this.pushTag("bookmark-link");
                    this.text(action.getBookmark());
                    this.popTag();
                    break;
                }
                case 1: {
                    this.pushTag("hyperlink");
                    this.text(action.getHyperlink());
                    this.popTag();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            this.popTag();
        }

        public Object visitFreeFormItem(FreeFormItemDesign free, Object value) {
            this.pushTag("free-form");
            this.writeReportItem(free);
            for (int i = 0; i < free.getItemCount(); ++i) {
                free.getItem(i).accept(this, null);
            }
            this.popTag();
            return value;
        }

        protected void attribute(String name, String value) {
            if (!$assertionsDisabled && this.endTag) {
                throw new AssertionError();
            }
            if (value != null && !"".equals(value)) {
                this.out.print(" " + name + "=\"" + value + "\"");
            }
        }

        protected void attribute(String name, double value) {
            this.attribute(name, value, 0.0);
        }

        protected void attribute(String name, double value, double omitValue) {
            if (value != omitValue) {
                this.attribute(name, this.doubleFmt.format(value));
            }
        }

        protected void attribute(String name, boolean value) {
            this.attribute(name, value ? "true" : "false");
        }

        protected void attribute(String name, Object value) {
            if (value != null) {
                this.attribute(name, value.toString());
            }
        }

        protected void pushTag(String tag) {
            if (!this.endTag) {
                this.out.println(">");
            }
            this.indent();
            this.out.print("<" + tag);
            this.endTag = false;
            this.tagStack.push(tag);
        }

        protected void text(String text) {
            if (text == null || "".equals(text.trim())) {
                return;
            }
            if (!this.endTag) {
                this.out.println(">");
            }
            this.endTag = true;
            this.indent();
            this.out.println(text);
        }

        protected void popTag() {
            String tag = (String)this.tagStack.pop();
            if (!this.endTag) {
                this.endTag = true;
                this.out.print(">");
            } else {
                this.indent();
            }
            this.out.println("</" + tag + ">");
        }

        protected void indent() {
            for (int i = 0; i < this.tagStack.size(); ++i) {
                this.out.print("    ");
            }
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$report$engine$parser$ReportDesignWriter == null ? (class$org$eclipse$birt$report$engine$parser$ReportDesignWriter = ReportDesignWriter.class$("org.eclipse.birt.report.engine.parser.ReportDesignWriter")) : class$org$eclipse$birt$report$engine$parser$ReportDesignWriter).desiredAssertionStatus();
        }
    }
}

