/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import java.util.Stack;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.IPaginationBuilder;
import org.eclipse.birt.report.engine.presentation.Page;
import org.eclipse.birt.report.engine.presentation.PageHint;
import org.eclipse.birt.report.engine.presentation.PageRegion;

public class DefaultPaginationEmitter
extends ContentEmitterAdapter {
    protected IContentEmitter emitter;
    protected ILayoutPageHandler pageHandler;
    protected int currentPageNo = 0;
    protected long startOffset = -1L;
    protected long endOffset = -1L;
    protected long offset = -1L;
    protected String masterPage;
    protected Page page;
    protected IContent content;
    protected PageRegion pageRegion;
    protected Stack tableDrops = new Stack();
    protected IPaginationBuilder builder;
    static final /* synthetic */ boolean $assertionsDisabled;

    DefaultPaginationEmitter(IPaginationBuilder builder) {
        this.builder = builder;
    }

    void setOutputEmitter(IContentEmitter emitter) {
        this.emitter = emitter;
    }

    void setPageHandler(ILayoutPageHandler pageHandler) {
        this.pageHandler = pageHandler;
    }

    public IPageHint getPageHint() {
        return new PageHint(this.currentPageNo, -1L, this.startOffset, this.endOffset);
    }

    protected boolean isBlockLevelElement(IContent content) {
        IStyle style;
        String display;
        IContent parent = (IContent)content.getParent();
        if (parent == null) {
            return true;
        }
        return this.isBlockLevelElement(parent) && ("block" == (display = (style = content.getComputedStyle()).getDisplay()) || "table" == display || "table-row" == display || "table-row-group" == display);
    }

    protected boolean inRepeatHeader(IContent content) {
        IBandContent band;
        if (content instanceof IBandContent && ((band = (IBandContent)content).getBandType() == 1 || band.getBandType() == 15)) {
            return true;
        }
        IContent parent = (IContent)content.getParent();
        if (parent != null) {
            return this.inRepeatHeader(parent);
        }
        return false;
    }

    protected boolean allowPageBreakBefore(IContent content) {
        if (!this.tableDrops.isEmpty()) {
            DropStatus status = (DropStatus)this.tableDrops.peek();
            if (status.curRowId != status.dropRowId) {
                return false;
            }
        }
        return !this.inRepeatHeader(content);
    }

    protected boolean allowPageBreakAfter(IContent content) {
        if (!this.tableDrops.isEmpty()) {
            DropStatus status = (DropStatus)this.tableDrops.peek();
            if (status.curRowId + 1 != status.dropRowId) {
                return false;
            }
        }
        return !this.inRepeatHeader(content);
    }

    public String getOutputFormat() {
        if (this.emitter != null) {
            return this.emitter.getOutputFormat();
        }
        return null;
    }

    public void initialize(IEmitterServices service) {
        if (this.emitter != null) {
            this.emitter.initialize(service);
        }
    }

    public void start(IReportContent report) {
        PageSetupDesign pageSetup;
        if (this.emitter != null) {
            this.emitter.start(report);
        }
        if ((pageSetup = report.getDesign().getPageSetup()).getMasterPageCount() > 0) {
            this.masterPage = pageSetup.getMasterPage(0).getName();
        }
    }

    public void end(IReportContent report) {
        this.content = null;
        this.closePage();
        if (this.currentPageNo == 0) {
            this.createDefaultPage();
            this.closePage();
        }
        if (this.emitter != null) {
            this.emitter.end(report);
        }
        if (this.pageHandler != null) {
            LayoutContext context = new LayoutContext(this.currentPageNo, this.startOffset, this.endOffset, true);
            this.pageHandler.onPage(this.currentPageNo, context);
        }
    }

    public void startContainer(IContainerContent container) {
        this.handlePageBreakBefore(container);
        this.offset = this.getIndex(container);
        this.getCurrentPage().startContainer(container);
        if (this.startOffset == -1L) {
            this.startOffset = this.offset;
        }
    }

    public void endContainer(IContainerContent container) {
        this.getCurrentPage().endContainer(container);
        this.handlePageBreakAfter(container);
    }

    public void startTable(ITableContent table) {
        this.handlePageBreakBefore(table);
        DropStatus status = new DropStatus();
        status.curRowId = 0;
        status.dropRowId = 0;
        this.tableDrops.push(status);
        this.offset = this.getIndex(table);
        this.getCurrentPage().startTable(table);
        if (this.startOffset == -1L) {
            this.startOffset = this.offset;
        }
    }

    public void endTable(ITableContent table) {
        this.tableDrops.pop();
        this.getCurrentPage().endTable(table);
        this.handlePageBreakAfter(table);
    }

    public void startTableBand(ITableBandContent band) {
        this.handlePageBreakBefore(band);
        this.offset = this.getIndex(band);
        this.getCurrentPage().startTableBand(band);
        if (this.startOffset == -1L) {
            this.startOffset = this.offset;
        }
    }

    public void endTableBand(ITableBandContent band) {
        this.getCurrentPage().endTableBand(band);
        this.handlePageBreakAfter(band);
    }

    public void startRow(IRowContent row) {
        DropStatus status = (DropStatus)this.tableDrops.peek();
        status.curRowId = row.getRowID();
        this.handlePageBreakBefore(row);
        this.offset = this.getIndex(row);
        this.getCurrentPage().startRow(row);
        if (this.startOffset == -1L) {
            this.startOffset = this.offset;
        }
    }

    public void endRow(IRowContent row) {
        this.getCurrentPage().endRow(row);
        this.handlePageBreakAfter(row);
    }

    public void startCell(ICellContent cell) {
        DropStatus status = (DropStatus)this.tableDrops.peek();
        int dropRowId = status.curRowId + cell.getRowSpan();
        if (dropRowId > status.dropRowId) {
            status.dropRowId = dropRowId;
        }
        this.offset = this.getIndex(cell);
        this.getCurrentPage().startCell(cell);
        if (this.startOffset == -1L) {
            this.startOffset = this.offset;
        }
    }

    public void endCell(ICellContent cell) {
        this.getCurrentPage().endCell(cell);
    }

    public void startText(ITextContent text) {
        this.handlePageBreakBefore(text);
        this.offset = this.getIndex(text);
        this.getCurrentPage().startText(text);
        if (this.startOffset == -1L) {
            this.startOffset = this.offset;
        }
        this.handlePageBreakAfter(text);
    }

    public void startLabel(ILabelContent label) {
        this.handlePageBreakBefore(label);
        this.offset = this.getIndex(label);
        this.getCurrentPage().startLabel(label);
        if (this.startOffset == -1L) {
            this.startOffset = this.offset;
        }
        this.handlePageBreakAfter(label);
    }

    public void startData(IDataContent data) {
        this.handlePageBreakBefore(data);
        this.offset = this.getIndex(data);
        this.getCurrentPage().startData(data);
        if (this.startOffset == -1L) {
            this.startOffset = this.offset;
        }
        this.handlePageBreakAfter(data);
    }

    public void startImage(IImageContent image) {
        this.handlePageBreakBefore(image);
        this.offset = this.getIndex(image);
        this.getCurrentPage().startImage(image);
        if (this.startOffset == -1L) {
            this.startOffset = this.offset;
        }
        this.handlePageBreakAfter(image);
    }

    public void startForeign(IForeignContent foreign) {
        this.handlePageBreakBefore(foreign);
        this.offset = this.getIndex(foreign);
        this.getCurrentPage().startForeign(foreign);
        if (this.startOffset == -1L) {
            this.startOffset = this.offset;
        }
        this.handlePageBreakAfter(foreign);
    }

    private void handlePageBreakBefore(IContent content) {
        this.content = (IContent)content.getParent();
        if (this.allowPageBreakBefore(content) && this.needPageBreakBefore(content)) {
            this.createPage();
        }
    }

    protected boolean needPageBreakBefore(IContent content) {
        return this.hasMasterPageChanged(content);
    }

    protected boolean needPageBreakAfter(IContent content) {
        return false;
    }

    protected void handlePageBreakAfter(IContent content) {
        this.content = (IContent)content.getParent();
        if (this.allowPageBreakAfter(content) && this.needPageBreakAfter(content)) {
            this.closePage();
        }
    }

    protected void createPage() {
        this.closePage();
        this.startOffset = -1L;
        IPageContent pageContent = this.createPageContent();
        this.page = new Page(this.emitter, pageContent);
        this.page.open();
        this.pageRegion = this.page.createRegion();
        this.getCurrentPage().open(this.content);
    }

    protected PageRegion getCurrentPage() {
        if (this.pageRegion == null) {
            this.createPage();
        }
        if (!$assertionsDisabled && this.pageRegion == null) {
            throw new AssertionError();
        }
        return this.pageRegion;
    }

    protected void closePage() {
        this.endOffset = this.offset;
        if (this.pageRegion != null) {
            this.pageRegion.close(this.content);
            this.pageRegion = null;
        }
        if (this.page != null) {
            this.page.close();
            this.page = null;
            if (this.pageHandler != null) {
                LayoutContext context = new LayoutContext(this.currentPageNo, this.startOffset, this.endOffset, false);
                this.pageHandler.onPage(this.currentPageNo, context);
            }
        }
    }

    protected void createDefaultPage() {
        this.createPage();
    }

    protected IPageContent createPageContent() {
        ++this.currentPageNo;
        return this.builder.buildPageContent(this.currentPageNo, this.masterPage);
    }

    protected IContent clearBottomStyle(IContent content) {
        IStyle style = content.getStyle();
        style.setProperty(53, IStyle.NONE_VALUE);
        style.setProperty(10, IStyle.NONE_VALUE);
        style.setProperty(56, IStyle.NONE_VALUE);
        return content;
    }

    protected IContent cleartTopStyle(IContent content) {
        IStyle style = content.getStyle();
        style.setProperty(52, IStyle.NONE_VALUE);
        style.setProperty(13, IStyle.NONE_VALUE);
        style.setProperty(55, IStyle.NONE_VALUE);
        return content;
    }

    protected boolean hasMasterPageChanged(IContent content) {
        MasterPageDesign masterPageDesign;
        PageSetupDesign pageSetup;
        String newMasterPage;
        IStyle style = content.getStyle();
        String string = newMasterPage = style != null ? style.getMasterPage() : null;
        if (newMasterPage == null) {
            return false;
        }
        if (!newMasterPage.equalsIgnoreCase(this.masterPage) && (pageSetup = content.getReportContent().getDesign().getPageSetup()).getMasterPageCount() > 0 && (masterPageDesign = pageSetup.findMasterPage(newMasterPage)) != null) {
            this.masterPage = newMasterPage;
            return true;
        }
        return false;
    }

    long getIndex(IContent content) {
        DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
        if (docExt != null) {
            return docExt.getIndex();
        }
        return -1L;
    }

    static {
        $assertionsDisabled = !DefaultPaginationEmitter.class.desiredAssertionStatus();
    }

    static class LayoutContext {
        long currentPageNo;
        long startOffset;
        long endOffset;
        boolean finished;

        LayoutContext(long pageNumber, long start, long end, boolean f) {
            this.currentPageNo = pageNumber;
            this.startOffset = start;
            this.endOffset = end;
            this.finished = f;
        }
    }

    private static class DropStatus {
        int curRowId;
        int dropRowId;

        private DropStatus() {
        }
    }
}

