/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import com.ibm.icu.util.ULocale;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.core.template.TemplateParser;
import org.eclipse.birt.core.template.TextTemplate;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.content.ContentVisitorAdapter;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.ForeignContent;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.template.TemplateExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemPresentation;
import org.eclipse.birt.report.engine.extension.IRowSet;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.extension.internal.RowSet;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.script.internal.CellScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.DataItemScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.DynamicTextScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.GridScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ImageScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.LabelScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ListScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.RowScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TableScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TextItemScriptExecutor;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.css.CSSValue;

public class LocalizedContentVisitor
extends ContentVisitorAdapter {
    protected static Logger logger;
    private ExecutionContext context;
    private Locale locale;
    private String outputFormat;
    protected HashMap templates = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public LocalizedContentVisitor(ExecutionContext context) {
        this.context = context;
        this.locale = context.getLocale();
        this.outputFormat = context.getOutputFormat();
    }

    IReportContent getReportContent() {
        return this.context.getReportContent();
    }

    ReportDesignHandle getReportDesign() {
        return this.context.getDesign();
    }

    public IContent localize(IContent content) {
        Object value = content.accept(this, content);
        return (IContent)value;
    }

    protected void localizeAllChildren(IContent content) {
        Collection children = content.getChildren();
        if (children != null) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                IContent child = (IContent)iter.next();
                this.localize(child);
                this.localizeAllChildren(child);
            }
        }
    }

    public Object visitPage(IPageContent page, Object value) {
        this.localizeAllChildren(page);
        return value;
    }

    protected TextTemplate parseTemplate(String text) {
        SoftReference<TextTemplate> templateRef = (SoftReference<TextTemplate>)this.templates.get(text);
        TextTemplate template = null;
        if (templateRef != null && (template = (TextTemplate)templateRef.get()) != null) {
            return template;
        }
        try {
            template = new TemplateParser().parse(text);
            templateRef = new SoftReference<TextTemplate>(template);
            this.templates.put(text, templateRef);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return template;
    }

    String executeTemplate(TextTemplate template, HashMap values) {
        return new TemplateExecutor(this.context).execute(template, values);
    }

    public Object visitList(IListContent list, Object value) {
        if (list.getGenerateBy() instanceof ListItemDesign) {
            ListScriptExecutor.handleOnRender(list, this.context);
        }
        return list;
    }

    public Object visitTable(ITableContent table, Object value) {
        if (table.getGenerateBy() instanceof TableItemDesign) {
            TableScriptExecutor.handleOnRender(table, this.context);
        } else if (table.getGenerateBy() instanceof GridItemDesign) {
            GridScriptExecutor.handleOnRender(table, this.context);
        }
        String captionText = table.getCaption();
        String captionKey = table.getCaptionKey();
        captionText = this.localize(table, captionKey, captionText);
        table.setCaption(captionText);
        return table;
    }

    public Object visitRow(IRowContent row, Object value) {
        RowScriptExecutor.handleOnRender(row, this.context);
        return row;
    }

    public Object visitCell(ICellContent cell, Object value) {
        CellScriptExecutor.handleOnRender(cell, this.context);
        return cell;
    }

    public Object visitData(IDataContent data, Object value) {
        DataItemScriptExecutor.handleOnRender(data, this.context);
        this.processData(data);
        return data;
    }

    protected void processData(IDataContent data) {
        String helpText = this.localize(data, data.getHelpKey(), data.getHelpText());
        data.setHelpText(helpText);
        String text = "";
        if (data.getLabelKey() != null || data.getLabelText() != null) {
            text = this.localize(data, data.getLabelKey(), data.getLabelText());
        } else {
            Object value = data.getValue();
            if (value != null) {
                IStyle style = data.getComputedStyle();
                if (value instanceof Number) {
                    String format = style.getNumberFormat();
                    NumberFormatter fmt = this.context.getNumberFormatter(format);
                    text = fmt.format((Number)value);
                    CSSValue align = style.getProperty(50);
                    if (align != null && align != CSSValueConstants.NONE_VALUE) {
                        data.getStyle().setProperty(26, align);
                    }
                } else if (value instanceof String) {
                    StringFormatter fmt = this.context.getStringFormatter(style.getStringFormat());
                    text = fmt.format((String)value);
                } else if (value instanceof Date) {
                    DateFormatter fmt = this.context.getDateFormatter(style.getDateFormat());
                    text = fmt.format((Date)value);
                } else {
                    text = value.toString();
                }
            }
        }
        data.setText(text);
    }

    public Object visitLabel(ILabelContent label, Object value) {
        if (label.getGenerateBy() instanceof LabelItemDesign) {
            LabelScriptExecutor.handleOnRender(label, this.context);
        } else if (label.getGenerateBy() instanceof TextItemDesign) {
            TextItemScriptExecutor.handleOnRender(label, this.context);
        }
        this.processLabel(label);
        return label;
    }

    protected void processLabel(ILabelContent label) {
        String helpText = this.localize(label, label.getHelpKey(), label.getHelpText());
        label.setHelpText(helpText);
        String text = this.localize(label, label.getLabelKey(), label.getLabelText());
        label.setText(text);
    }

    public Object visitText(ITextContent text, Object value) {
        TextItemScriptExecutor.handleOnRender(text, this.context);
        return value;
    }

    public Object visitForeign(IForeignContent foreignContent, Object value) {
        IReportContent reportContent = this.getReportContent();
        String rawFormat = foreignContent.getRawType();
        Object rawValue = foreignContent.getRawValue();
        if ("text/template".equals(rawFormat)) {
            TextItemScriptExecutor.handleOnRender(foreignContent, this.context);
            this.processTemplateContent(foreignContent);
            return foreignContent;
        }
        if ("object/external".equals(rawFormat)) {
            return this.processExtendedContent(foreignContent);
        }
        if ("binary/image".equals(rawFormat)) {
            if (rawValue instanceof IImageContent) {
                IImageContent image = (IImageContent)rawValue;
                this.processImage(image);
                return image;
            }
            if (rawValue instanceof byte[]) {
                IImageContent imageContent = reportContent.createImageContent(foreignContent);
                imageContent.setImageSource(2);
                imageContent.setData((byte[])rawValue);
                this.processImage(imageContent);
                return imageContent;
            }
        }
        if ("text/plaintext".equals(rawFormat)) {
            TextItemScriptExecutor.handleOnRender(foreignContent, this.context);
            IDataContent textContent = reportContent.createDataContent(foreignContent);
            textContent.setText(rawValue == null ? "" : rawValue.toString());
            return textContent;
        }
        if ("binary/value".equals(rawFormat)) {
            DynamicTextScriptExecutor.handleOnRender(foreignContent, this.context);
            IDataContent dataContent = reportContent.createDataContent(foreignContent);
            dataContent.setValue(rawValue);
            this.processData(dataContent);
            return dataContent;
        }
        return foreignContent;
    }

    private String localize(IContent content, String key, String text) {
        String t;
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && content.getGenerateBy() == null) {
            throw new AssertionError();
        }
        DesignElementHandle element = ((ReportItemDesign)content.getGenerateBy()).getHandle();
        if (key != null && element != null && (t = ModuleUtil.getExternalizedValue((DesignElementHandle)element, (String)key, (String)text, (ULocale)ULocale.forLocale((Locale)this.locale))) != null) {
            return t;
        }
        return text;
    }

    public Object visitImage(IImageContent image, Object value) {
        ImageScriptExecutor.handleOnRender(image, this.context);
        this.processImage(image);
        return image;
    }

    protected void processImage(IImageContent image) {
        String altText = this.localize(image, image.getAltTextKey(), image.getAltText());
        image.setAltText(altText);
        String helpText = this.localize(image, image.getHelpKey(), image.getHelpText());
        image.setHelpText(helpText);
    }

    protected void processTemplateContent(IForeignContent foreignContent) {
        if (!$assertionsDisabled && !"text/template".equals(foreignContent.getRawType())) {
            throw new AssertionError();
        }
        if (foreignContent.getGenerateBy() instanceof TextItemDesign) {
            TextItemDesign design = (TextItemDesign)foreignContent.getGenerateBy();
            String text = this.localize(foreignContent, design.getTextKey(), design.getText());
            String textType = design.getTextType();
            TextTemplate template = this.parseTemplate(text);
            HashMap values = new HashMap();
            if (foreignContent.getRawValue() instanceof HashMap) {
                values = (HashMap)foreignContent.getRawValue();
            }
            String result = this.executeTemplate(template, values);
            String rawType = ForeignContent.getTextRawType(textType, result);
            if (!$assertionsDisabled && !"text/html".equals(rawType)) {
                throw new AssertionError();
            }
            foreignContent.setRawType("text/html");
            foreignContent.setRawValue(result);
        }
    }

    protected String getOutputFormat() {
        return this.outputFormat;
    }

    protected boolean isForPrinting() {
        String outputFormat = this.getOutputFormat();
        return "FO".equalsIgnoreCase(outputFormat) || "PDF".equalsIgnoreCase(outputFormat);
    }

    protected IContent processExtendedContent(IForeignContent content) {
        if (!$assertionsDisabled && !"object/external".equals(content.getRawType())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(content.getGenerateBy() instanceof ExtendedItemDesign)) {
            throw new AssertionError();
        }
        IContent generatedContent = content;
        ExtendedItemDesign design = (ExtendedItemDesign)content.getGenerateBy();
        ExtendedItemHandle handle = (ExtendedItemHandle)design.getHandle();
        String tagName = handle.getExtensionName();
        IReportItemPresentation itemPresentation = ExtensionManager.getInstance().createPresentationItem(tagName);
        if (itemPresentation != null) {
            IResultSet parent;
            itemPresentation.setModelObject(handle);
            itemPresentation.setScriptContext(this.context.getReportContext());
            IBaseQueryDefinition[] queries = design.getQueries();
            if (queries == null && design.getQuery() != null) {
                queries = new IBaseQueryDefinition[]{design.getQuery()};
            }
            itemPresentation.setReportQueries(queries);
            itemPresentation.setDynamicStyle(content.getComputedStyle());
            Map appContext = this.context.getAppContext();
            int resolution = 96;
            if (this.isForPrinting()) {
                Object tmp;
                resolution = 192;
                if (appContext != null && (tmp = appContext.get("CHART_PRINT_RESOLUTION")) != null && tmp instanceof Number && (resolution = ((Number)tmp).intValue()) < 96) {
                    resolution = 96;
                }
            }
            itemPresentation.setResolution(resolution);
            itemPresentation.setLocale(this.locale);
            Object renderContext = null;
            if (appContext != null) {
                renderContext = appContext.get("HTML_RENDER_CONTEXT");
            }
            String supportedImageFormats = "PNG;GIF;JPG;BMP;";
            if (renderContext != null && renderContext instanceof HTMLRenderContext) {
                HTMLRenderContext htmlContext = renderContext;
                IRenderOption option = this.context.getRenderOption();
                htmlContext.SetRenderOption(option);
                String formats = htmlContext.getSupportedImageFormats();
                if (formats != null) {
                    supportedImageFormats = formats;
                }
            }
            itemPresentation.setSupportedImageFormats(supportedImageFormats);
            itemPresentation.setActionHandler(this.context.getActionHandler());
            String outputFormat = this.getOutputFormat();
            itemPresentation.setOutputFormat(outputFormat);
            Object rawValue = content.getRawValue();
            if (rawValue instanceof byte[]) {
                byte[] values = (byte[])rawValue;
                itemPresentation.deserialize(new ByteArrayInputStream(values));
            }
            if ((parent = this.context.getResultSet()) != null) {
                parent = parent.getParent();
            }
            IRowSet[] rowSets = this.executeQueries(parent, design);
            try {
                Object output = itemPresentation.onRowSets(rowSets);
                if (output != null) {
                    int type = itemPresentation.getOutputType();
                    String imageMIMEType = itemPresentation.getImageMIMEType();
                    generatedContent = this.processExtendedContent(content, type, output, imageMIMEType);
                }
                itemPresentation.finish();
            }
            catch (BirtException ex) {
                this.context.addException(design.getHandle(), ex);
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            this.closeQueries(rowSets);
        }
        return generatedContent;
    }

    protected IContent processExtendedContent(IForeignContent content, int type, Object output, String imageMIMEType) {
        if (!$assertionsDisabled && !"object/external".equals(content.getRawType())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && output == null) {
            throw new AssertionError();
        }
        IReportContent reportContent = this.getReportContent();
        switch (type) {
            case 0: {
                break;
            }
            case 1: 
            case 6: {
                Object imageMap = null;
                byte[] imageContent = new byte[]{};
                Object image = output;
                if (type == 6) {
                    Object[] imageWithMap = (Object[])output;
                    if (imageWithMap.length > 0) {
                        image = imageWithMap[0];
                    }
                    if (imageWithMap.length > 1) {
                        imageMap = imageWithMap[1];
                    }
                }
                if (image instanceof InputStream) {
                    imageContent = LocalizedContentVisitor.readContent((InputStream)image);
                } else if (output instanceof byte[]) {
                    imageContent = (byte[])image;
                } else {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    logger.log(Level.WARNING, "unsupported image type:{0}", output);
                }
                IImageContent imageObj = reportContent.createImageContent(content);
                imageObj.setImageSource(2);
                imageObj.setData(imageContent);
                imageObj.setImageMap(imageMap);
                imageObj.setMIMEType(imageMIMEType);
                this.processImage(imageObj);
                return imageObj;
            }
            case 5: {
                IDataContent dataObj = reportContent.createDataContent(content);
                dataObj.setValue(output);
                this.processData(dataObj);
                return dataObj;
            }
            case 3: {
                content.setRawType("text/html");
                content.setRawValue(output.toString());
                return content;
            }
            case 2: {
                ITextContent textObj = reportContent.createTextContent();
                textObj.setText(output.toString());
                return textObj;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                logger.log(Level.WARNING, "unsupported output format:{0}", new Integer(type));
            }
        }
        return content;
    }

    protected static byte[] readContent(InputStream in) {
        BufferedInputStream bin = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int readSize = 0;
        try {
            readSize = bin.read(buffer);
            while (readSize != -1) {
                out.write(buffer, 0, readSize);
                readSize = bin.read(buffer);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return out.toByteArray();
    }

    protected IRowSet[] executeQueries(IResultSet parent, ExtendedItemDesign extItem) {
        IBaseQueryDefinition query;
        IResultSet rset;
        IRowSet[] rowSets = null;
        IBaseQueryDefinition[] queries = extItem.getQueries();
        if (queries != null) {
            rowSets = new IRowSet[queries.length];
            for (int i = 0; i < rowSets.length; ++i) {
                try {
                    rset = this.context.executeQuery(parent, queries[i]);
                    if (!$assertionsDisabled && rset == null) {
                        throw new AssertionError();
                    }
                    rowSets[i] = new RowSet(rset);
                    continue;
                }
                catch (BirtException ex) {
                    rowSets[i] = null;
                }
            }
        }
        if (rowSets == null && (query = extItem.getQuery()) != null) {
            try {
                rset = this.context.executeQuery(parent, query);
                rowSets = new IRowSet[]{new RowSet(rset)};
            }
            catch (BirtException ex) {
                // empty catch block
            }
        }
        return rowSets;
    }

    protected void closeQueries(IRowSet[] rowSets) {
        if (rowSets != null) {
            for (int i = 0; i < rowSets.length; ++i) {
                if (rowSets[i] == null) continue;
                rowSets[i].close();
            }
        }
    }

    static {
        $assertionsDisabled = !LocalizedContentVisitor.class.desiredAssertionStatus();
        logger = Logger.getLogger(LocalizedContentVisitor.class.getName());
    }
}

