/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile;

import com.ibm.icu.text.DateFormat;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;

public class ResultSet
implements IResultSet {
    public static final int DEFAULT_MAX_ROWS = 1000;
    private static final int CURSOR_INITIAL_VALUE = -1;
    private String[][] sourceData = null;
    private IResultSetMetaData resultSetMetaData = null;
    private int maxRows = 0;
    private int cursor = -1;
    private boolean wasNull = false;

    ResultSet(String[][] sData, IResultSetMetaData rsmd) {
        this.sourceData = sData;
        this.resultSetMetaData = rsmd;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return this.resultSetMetaData;
    }

    public void close() throws OdaException {
        this.cursor = 0;
        this.sourceData = null;
        this.resultSetMetaData = null;
    }

    public void setMaxRows(int max) throws OdaException {
        this.maxRows = max;
    }

    public boolean next() throws OdaException {
        if (this.maxRows > 0 && this.cursor >= this.maxRows - 1 || this.cursor >= this.sourceData.length - 1) {
            this.cursor = -1;
            return false;
        }
        ++this.cursor;
        return true;
    }

    public int getRow() throws OdaException {
        this.validateCursorState();
        return this.cursor;
    }

    public String getString(int index) throws OdaException {
        this.validateCursorState();
        String result = this.sourceData[this.cursor][index - 1];
        if (result.length() == 0) {
            result = null;
        }
        this.wasNull = result == null;
        return result;
    }

    public String getString(String columnName) throws OdaException {
        this.validateCursorState();
        int columnIndex = this.findColumn(columnName);
        return this.getString(columnIndex);
    }

    public int getInt(int index) throws OdaException {
        return this.stringToInt(this.getString(index));
    }

    public int getInt(String columnName) throws OdaException {
        return this.stringToInt(this.getString(columnName));
    }

    public double getDouble(int index) throws OdaException {
        return this.stringToDouble(this.getString(index));
    }

    public double getDouble(String columnName) throws OdaException {
        return this.stringToDouble(this.getString(columnName));
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        return this.stringToBigDecimal(this.getString(index));
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        return this.stringToBigDecimal(this.getString(columnName));
    }

    public java.sql.Date getDate(int index) throws OdaException {
        return this.stringToDate(this.getString(index));
    }

    public java.sql.Date getDate(String columnName) throws OdaException {
        return this.stringToDate(this.getString(columnName));
    }

    public Time getTime(int index) throws OdaException {
        return this.stringToTime(this.getString(index));
    }

    public Time getTime(String columnName) throws OdaException {
        return this.stringToTime(this.getString(columnName));
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        return this.stringToTimestamp(this.getString(index));
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        return this.stringToTimestamp(this.getString(columnName));
    }

    public IBlob getBlob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(String columnName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(String columnName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public boolean wasNull() throws OdaException {
        return this.wasNull;
    }

    public int findColumn(String columnName) throws OdaException {
        String trimmedColumnName = columnName.trim();
        int columnCount = this.getMetaData().getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            if (!trimmedColumnName.equalsIgnoreCase(this.getMetaData().getColumnName(i))) continue;
            return i;
        }
        throw new OdaException(Messages.getString("resultSet_COLUMN_NOT_FOUND") + columnName);
    }

    private void validateCursorState() throws OdaException {
        if (this.cursor < 0) {
            throw new OdaException(Messages.getString("resultSet_CURSOR_HAS_NOT_BEEN_INITIALIZED"));
        }
    }

    private int stringToInt(String stringValue) {
        if (stringValue != null) {
            try {
                return new Integer(stringValue);
            }
            catch (NumberFormatException e) {
                this.wasNull = true;
            }
        }
        return 0;
    }

    private double stringToDouble(String stringValue) {
        if (stringValue != null) {
            try {
                return new Double(stringValue);
            }
            catch (NumberFormatException e) {
                this.wasNull = true;
            }
        }
        return 0.0;
    }

    private BigDecimal stringToBigDecimal(String stringValue) {
        if (stringValue != null) {
            try {
                return new BigDecimal(stringValue);
            }
            catch (NumberFormatException e) {
                this.wasNull = true;
            }
        }
        return null;
    }

    private java.sql.Date stringToDate(String stringValue) {
        if (stringValue != null) {
            try {
                return java.sql.Date.valueOf(stringValue);
            }
            catch (IllegalArgumentException e) {
                try {
                    return new java.sql.Date(this.stringToLongDate(stringValue));
                }
                catch (ParseException e1) {
                    this.wasNull = true;
                }
            }
        }
        return null;
    }

    private Time stringToTime(String stringValue) {
        if (stringValue != null) {
            try {
                return Time.valueOf(stringValue);
            }
            catch (IllegalArgumentException e) {
                try {
                    return new Time(this.stringToLongDate(stringValue));
                }
                catch (ParseException e1) {
                    this.wasNull = true;
                }
            }
        }
        return null;
    }

    private Timestamp stringToTimestamp(String stringValue) {
        if (stringValue != null) {
            try {
                return Timestamp.valueOf(stringValue);
            }
            catch (IllegalArgumentException e) {
                this.wasNull = true;
            }
        }
        return null;
    }

    private long stringToLongDate(String stringValue) throws ParseException {
        DateFormat dateFormat = null;
        Date resultDate = null;
        try {
            dateFormat = DateFormat.getDateTimeInstance((int)3, (int)2);
            resultDate = dateFormat.parse(stringValue);
        }
        catch (ParseException e) {
            try {
                dateFormat = DateFormat.getDateTimeInstance((int)3, (int)2, (Locale)Locale.US);
                resultDate = dateFormat.parse(stringValue);
            }
            catch (ParseException e1) {
                // empty catch block
            }
        }
        if (resultDate == null) {
            try {
                dateFormat = DateFormat.getDateTimeInstance((int)3, (int)3);
                resultDate = dateFormat.parse(stringValue);
            }
            catch (ParseException e) {
                try {
                    dateFormat = DateFormat.getDateTimeInstance((int)3, (int)3, (Locale)Locale.US);
                    resultDate = dateFormat.parse(stringValue);
                }
                catch (ParseException e1) {
                    // empty catch block
                }
            }
        }
        if (resultDate == null) {
            try {
                dateFormat = DateFormat.getTimeInstance((int)2);
                resultDate = dateFormat.parse(stringValue);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (resultDate == null) {
            try {
                dateFormat = DateFormat.getDateInstance((int)3);
                resultDate = dateFormat.parse(stringValue);
            }
            catch (ParseException e) {
                dateFormat = DateFormat.getDateInstance((int)3, (Locale)Locale.US);
                resultDate = dateFormat.parse(stringValue);
            }
        }
        return resultDate.getTime();
    }
}

