/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.impl;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import org.eclipse.birt.report.data.oda.xml.i18n.Messages;
import org.eclipse.birt.report.data.oda.xml.impl.ResultSetMetaData;
import org.eclipse.birt.report.data.oda.xml.util.RelationInformation;
import org.eclipse.birt.report.data.oda.xml.util.SaxParserConsumer;
import org.eclipse.birt.report.data.oda.xml.util.XMLDataInputStream;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSet
implements IResultSet {
    private ResultSetMetaData rsMetaData;
    private int maxRows;
    private boolean wasNull;
    private boolean isClosed;
    private SaxParserConsumer spConsumer;

    public ResultSet(XMLDataInputStream is, RelationInformation ri, String tableName, int maxRows) throws OdaException {
        this.rsMetaData = new ResultSetMetaData(ri, tableName);
        this.maxRows = maxRows;
        this.isClosed = false;
        this.spConsumer = new SaxParserConsumer(this, ri, is, tableName);
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        this.testClosed();
        return this.rsMetaData;
    }

    private void testClosed() throws OdaException {
        if (this.isClosed) {
            throw new OdaException(Messages.getString("ResultSet.ResultSetClosed"));
        }
    }

    public void close() throws OdaException {
        this.spConsumer.close();
        this.rsMetaData = null;
        this.isClosed = true;
    }

    public void setMaxRows(int max) throws OdaException {
        this.testClosed();
        this.maxRows = max;
    }

    public boolean next() throws OdaException {
        this.testClosed();
        if (this.spConsumer.getCurrentRowNo() >= this.maxRows && this.maxRows != 0) {
            return false;
        }
        return this.spConsumer.next();
    }

    public int getRow() throws OdaException {
        this.testClosed();
        return this.spConsumer.getCurrentRowNo();
    }

    public String getString(int index) throws OdaException {
        this.testClosed();
        String result = this.spConsumer.getResultSet()[this.getRowPosition()][this.getColumnPosition(index)];
        this.wasNull = result == null;
        return result;
    }

    private int getColumnPosition(int index) {
        return index - 1;
    }

    private int getRowPosition() {
        return this.spConsumer.getRowPosition();
    }

    private int getColumnIndex(String columnName) throws OdaException {
        for (int i = 1; i <= this.rsMetaData.getColumnCount(); ++i) {
            if (!this.rsMetaData.getColumnName(i).equals(columnName)) continue;
            return i;
        }
        throw new OdaException();
    }

    public String getString(String name) throws OdaException {
        this.testClosed();
        return this.getString(this.getColumnIndex(name));
    }

    public int getInt(int index) throws OdaException {
        return this.stringToInt(this.getString(index));
    }

    public int getInt(String name) throws OdaException {
        return this.stringToInt(this.getString(name));
    }

    private int stringToInt(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                return new Integer(stringValue);
            }
            catch (NumberFormatException e) {
                this.wasNull = true;
            }
        }
        return 0;
    }

    public double getDouble(int index) throws OdaException {
        return this.stringToDouble(this.getString(index));
    }

    public double getDouble(String name) throws OdaException {
        return this.stringToDouble(this.getString(name));
    }

    private double stringToDouble(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                return new Double(stringValue);
            }
            catch (NumberFormatException e) {
                this.wasNull = true;
            }
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        return this.stringToBigDecimal(this.getString(index));
    }

    public BigDecimal getBigDecimal(String name) throws OdaException {
        return this.stringToBigDecimal(this.getString(name));
    }

    private BigDecimal stringToBigDecimal(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                return new BigDecimal(stringValue);
            }
            catch (NumberFormatException e) {
                this.wasNull = true;
            }
        }
        return null;
    }

    public Date getDate(int index) throws OdaException {
        return this.stringToDate(this.getString(index));
    }

    public Date getDate(String columnName) throws OdaException {
        return this.stringToDate(this.getString(columnName));
    }

    private Date stringToDate(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                return Date.valueOf(stringValue);
            }
            catch (IllegalArgumentException e) {
                try {
                    return new Date(this.stringToLongDate(stringValue));
                }
                catch (ParseException e1) {
                    this.wasNull = true;
                }
            }
        }
        return null;
    }

    private long stringToLongDate(String stringValue) throws ParseException {
        DateFormat dateFormat = null;
        java.util.Date resultDate = null;
        try {
            dateFormat = DateFormat.getDateTimeInstance((int)3, (int)2);
            resultDate = dateFormat.parse(stringValue);
        }
        catch (ParseException e) {
            try {
                dateFormat = DateFormat.getDateTimeInstance((int)3, (int)2, (ULocale)ULocale.US);
                resultDate = dateFormat.parse(stringValue);
            }
            catch (ParseException e1) {
                // empty catch block
            }
        }
        if (resultDate == null) {
            try {
                dateFormat = DateFormat.getDateTimeInstance((int)3, (int)3);
                resultDate = dateFormat.parse(stringValue);
            }
            catch (ParseException e) {
                try {
                    dateFormat = DateFormat.getDateTimeInstance((int)3, (int)3, (ULocale)ULocale.US);
                    resultDate = dateFormat.parse(stringValue);
                }
                catch (ParseException e1) {
                    // empty catch block
                }
            }
        }
        if (resultDate == null) {
            try {
                dateFormat = DateFormat.getTimeInstance((int)2);
                resultDate = dateFormat.parse(stringValue);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (resultDate == null) {
            try {
                dateFormat = DateFormat.getDateInstance((int)3);
                resultDate = dateFormat.parse(stringValue);
            }
            catch (ParseException e) {
                dateFormat = DateFormat.getDateInstance((int)3, (ULocale)ULocale.US);
                resultDate = dateFormat.parse(stringValue);
            }
        }
        return resultDate.getTime();
    }

    public Time getTime(int index) throws OdaException {
        return this.stringToTime(this.getString(index));
    }

    public Time getTime(String columnName) throws OdaException {
        return this.stringToTime(this.getString(columnName));
    }

    private Time stringToTime(String stringValue) throws OdaException {
        block3: {
            this.testClosed();
            if (stringValue != null) {
                try {
                    return Time.valueOf(stringValue);
                }
                catch (IllegalArgumentException e) {
                    Date date = this.stringToDate(stringValue);
                    if (date == null) break block3;
                    return new Time(date.getTime());
                }
            }
        }
        this.wasNull = true;
        return null;
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        return this.stringToTimestamp(this.getString(index));
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        return this.stringToTimestamp(this.getString(columnName));
    }

    private Timestamp stringToTimestamp(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                stringValue = stringValue.replaceAll("\\QT\\E", " ").split("\\QZ\\E")[0];
                return Timestamp.valueOf(stringValue);
            }
            catch (IllegalArgumentException e) {
                try {
                    long timeMills = new Long(stringValue);
                    return new Timestamp(timeMills);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.wasNull = true;
        return null;
    }

    public boolean wasNull() throws OdaException {
        this.testClosed();
        return this.wasNull;
    }

    public int findColumn(String columnName) throws OdaException {
        this.testClosed();
        return this.getColumnIndex(columnName);
    }

    public IBlob getBlob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(String columnName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(String columnName) throws OdaException {
        throw new UnsupportedOperationException();
    }
}

