/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.util;

import java.util.HashMap;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.birt.report.data.oda.xml.util.ISaxParserConsumer;
import org.eclipse.birt.report.data.oda.xml.util.XMLDataInputStream;
import org.eclipse.birt.report.data.oda.xml.util.XPathHolder;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxParser
extends DefaultHandler
implements Runnable {
    private XMLDataInputStream inputStream;
    private XPathHolder pathHolder;
    private ISaxParserConsumer spConsumer;
    private HashMap currentElementRecoder;
    private boolean start;
    private boolean alive;
    private String currentCacheValue;
    private boolean stopCurrentThread;

    public SaxParser(XMLDataInputStream stream, ISaxParserConsumer consumer) {
        this.inputStream = stream;
        this.spConsumer = consumer;
        this.start = true;
        this.alive = true;
        this.currentCacheValue = "";
        this.currentElementRecoder = new HashMap();
        this.stopCurrentThread = false;
    }

    public void run() {
        try {
            SAXParser xr = new SAXParser();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            try {
                xr.parse(new InputSource(this.inputStream));
            }
            catch (ThreadStopException tsE) {
                tsE.printStackTrace();
            }
            this.inputStream.reStart();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            this.alive = false;
            this.spConsumer.wakeup();
        }
    }

    public void startDocument() {
        this.pathHolder = new XPathHolder();
    }

    public void endDocument() {
        this.alive = false;
        this.spConsumer.wakeup();
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (this.stopCurrentThread) {
            throw new ThreadStopException();
        }
        String elementName = this.getElementName(uri, qName, name);
        String parentPath = this.pathHolder.getPath();
        if (this.currentElementRecoder.get(parentPath + "/" + elementName) == null) {
            this.currentElementRecoder.put(parentPath + "/" + elementName, new Integer(1));
        } else {
            this.currentElementRecoder.put(parentPath + "/" + elementName, new Integer((Integer)this.currentElementRecoder.get(parentPath + "/" + elementName) + 1));
        }
        this.pathHolder.push(elementName + "[" + (Integer)this.currentElementRecoder.get(parentPath + "/" + elementName) + "]");
        this.spConsumer.detectNewRow(this.pathHolder.getPath(), true);
        for (int i = 0; i < atts.getLength(); ++i) {
            this.spConsumer.manipulateData(this.getAttributePath(atts, i), atts.getValue(i));
            this.spConsumer.detectNewRow(this.getAttributePath(atts, i), true);
        }
    }

    private String getAttributePath(Attributes atts, int i) {
        return this.pathHolder.getPath() + "[@" + this.getElementName(atts.getURI(i), atts.getQName(i), atts.getLocalName(i)) + "]";
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.spConsumer.manipulateData(this.pathHolder.getPath(), this.currentCacheValue.trim());
        this.currentCacheValue = "";
        this.spConsumer.detectNewRow(this.pathHolder.getPath(), false);
        String path = this.pathHolder.getPath();
        Object[] keys = this.currentElementRecoder.keySet().toArray();
        for (int i = 0; i < keys.length && path != ""; ++i) {
            if (!keys[i].toString().startsWith(path) || keys[i].toString().equals(path)) continue;
            this.currentElementRecoder.remove(keys[i]);
        }
        this.pathHolder.pop();
    }

    private String getElementName(String uri, String qName, String name) {
        return qName;
    }

    public void characters(char[] ch, int start, int length) {
        for (int i = 0; i < length; ++i) {
            this.currentCacheValue = this.currentCacheValue + ch[start + i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStart(boolean start) {
        this.start = start;
        if (start) {
            SaxParser saxParser = this;
            synchronized (saxParser) {
                this.notify();
            }
        }
        SaxParser saxParser = this;
        synchronized (saxParser) {
            try {
                this.spConsumer.wakeup();
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void stopParsing() {
        this.stopCurrentThread = true;
    }

    public boolean isSuspended() {
        return !this.start;
    }

    public boolean isAlive() {
        return this.alive;
    }

    private class ThreadStopException
    extends RuntimeException {
        private static final long serialVersionUID = 7871277314833138093L;

        ThreadStopException() {
        }
    }
}

