/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.util;

import org.eclipse.birt.report.data.oda.xml.util.ISaxParserConsumer;
import org.eclipse.birt.report.data.oda.xml.util.NestedColumnUtil;
import org.eclipse.birt.report.data.oda.xml.util.RelationInformation;
import org.eclipse.birt.report.data.oda.xml.util.SaxParser;
import org.eclipse.birt.report.data.oda.xml.util.XMLDataInputStream;

public class SaxParserComplexNestedQueryHelper
implements ISaxParserConsumer {
    private String tableName;
    private RelationInformation relationInfo;
    private String[] namesOfNestedColumns;
    private SaxParser sp;
    private Thread spThread;
    private NestedColumnUtil nestedColumnUtil;

    SaxParserComplexNestedQueryHelper(RelationInformation rinfo, XMLDataInputStream xdis, String tName) {
        this.tableName = tName;
        this.relationInfo = rinfo;
        this.namesOfNestedColumns = this.relationInfo.getTableComplexNestedXMLColumnNames(this.tableName);
        this.nestedColumnUtil = new NestedColumnUtil(this.relationInfo, this.tableName, false);
        this.sp = new SaxParser(xdis, this);
        this.spThread = new Thread(this.sp);
        this.spThread.start();
    }

    public boolean isPrepared() {
        return !this.spThread.isAlive();
    }

    public void manipulateData(String path, String value) {
        for (int i = 0; i < this.namesOfNestedColumns.length; ++i) {
            this.nestedColumnUtil.update(this.namesOfNestedColumns[i], path, value);
        }
    }

    public void detectNewRow(String path, boolean start) {
    }

    public void wakeup() {
    }

    NestedColumnUtil getNestedColumnUtil() {
        return this.nestedColumnUtil;
    }
}

