/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swt.util;

import java.io.IOException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;

public class SwtUtil {
    private static final ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/util");

    private SwtUtil() {
    }

    public static void openURL(String href) {
        if (href == null) {
            return;
        }
        if (href.startsWith("file:")) {
            href = href.substring(5);
            while (href.startsWith("/")) {
                href = href.substring(1);
            }
            href = "file:///" + href;
        }
        final String localHref = href;
        Process p = null;
        try {
            p = Runtime.getRuntime().exec("/usr/bin/open " + localHref);
        }
        catch (IOException e) {
            p = null;
        }
        if (p == null) {
            Thread launcher = new Thread(){

                public void run() {
                    try {
                        String encodedLocalHref = SwtUtil.urlEncodeForSpaces(localHref.toCharArray());
                        Process p = SwtUtil.openWebBrowser(encodedLocalHref);
                        try {
                            if (p != null) {
                                p.waitFor();
                            }
                        }
                        catch (InterruptedException e) {
                            logger.log((Exception)e);
                        }
                    }
                    catch (IOException e) {
                        logger.log((Exception)e);
                    }
                }
            };
            launcher.start();
        }
    }

    private static String urlEncodeForSpaces(char[] input) {
        StringBuffer retu = new StringBuffer(input.length);
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == ' ') {
                retu.append("%20");
                continue;
            }
            retu.append(input[i]);
        }
        return retu.toString();
    }

    private static Process openWebBrowser(String href) throws IOException {
        Process p = null;
        String webBrowser = null;
        try {
            webBrowser = "netscape";
            p = Runtime.getRuntime().exec(webBrowser + "  " + href);
        }
        catch (IOException e) {
            p = null;
            webBrowser = "mozilla";
        }
        if (p == null) {
            try {
                p = Runtime.getRuntime().exec(webBrowser + " " + href);
            }
            catch (IOException e) {
                p = null;
                webBrowser = "explorer";
            }
        }
        if (p == null) {
            try {
                p = Runtime.getRuntime().exec(webBrowser + " " + href);
            }
            catch (IOException e) {
                p = null;
                throw e;
            }
        }
        return p;
    }
}

