/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.data.ColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.exception.CoreException;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;

class ExpressionParserUtility {
    private final String pluginId = "org.eclipse.birt.core";
    private final String ROW_INDICATOR = "row";
    private final String DATASETROW_INDICATOR = "dataSetRow";
    private static final String TOTAL = "Total";
    private static ExpressionParserUtility instance;
    private static boolean hasAggregation;
    static final /* synthetic */ boolean $assertionsDisabled;

    ExpressionParserUtility() {
    }

    static List compileColumnExpression(String expression) throws BirtException {
        if (expression == null || expression.trim().length() == 0) {
            return new ArrayList();
        }
        ArrayList columnExprList = new ArrayList();
        columnExprList.clear();
        Context context = Context.enter();
        try {
            ScriptOrFnNode tree = instance.parse(expression, context);
            instance.CompiledExprFromTree(expression, context, tree, columnExprList);
        }
        catch (Exception ex) {
            throw new CoreException(ExpressionParserUtility.instance.pluginId, (Object)"INVALID_EXPRSSION", (Throwable)ex);
        }
        finally {
            Context.exit();
        }
        return columnExprList;
    }

    static boolean hasAggregation(String expression) throws BirtException {
        hasAggregation = false;
        ExpressionParserUtility.compileColumnExpression(expression);
        return hasAggregation;
    }

    private void CompiledExprFromTree(String expression, Context context, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        if (tree.getFirstChild() == tree.getLastChild()) {
            if (tree.getFirstChild().getType() == 105) {
                int index = this.getFunctionIndex(tree.getFirstChild().getString(), tree);
                this.compileFunctionNode(tree.getFunctionNode(index), tree, columnExprList);
            } else {
                if (tree.getFirstChild().getType() != 130 && tree.getFirstChild().getType() != 129 && tree.getFirstChild().getType() != 125) {
                    throw new CoreException("org.eclipse.birt.core", "INVALID_EXPRSSION");
                }
                Node exprNode = tree.getFirstChild();
                this.processChild(exprNode, tree, columnExprList);
            }
        } else {
            this.compileComplexExpr((Node)tree, tree, columnExprList);
        }
    }

    private ScriptOrFnNode parse(String expression, Context cx) {
        CompilerEnvirons compilerEnv = new CompilerEnvirons();
        Parser p = new Parser(compilerEnv, cx.getErrorReporter());
        return p.parse(expression, null, 0);
    }

    private void processChild(Node child, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        switch (child.getType()) {
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                this.compileDirectColRefExpr(child, tree, columnExprList);
                break;
            }
            case 37: {
                this.compileAggregateExpr(child, tree, columnExprList);
                break;
            }
            default: {
                this.compileComplexExpr(child, tree, columnExprList);
            }
        }
    }

    private void compileDirectColRefExpr(Node refNode, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        if (!$assertionsDisabled && refNode.getType() != 33 && refNode.getType() != 35 && refNode.getType() != 36 && refNode.getType() != 34) {
            throw new AssertionError();
        }
        Node rowName = refNode.getFirstChild();
        if (!$assertionsDisabled && rowName == null) {
            throw new AssertionError();
        }
        if (rowName.getType() != 38) {
            if (refNode.getType() == 33 || refNode.getType() == 35 || refNode.getType() == 36 || refNode.getType() == 34) {
                int level = this.compileOuterColRefExpr(refNode);
                if (level == -1) {
                    this.compileComplexExpr(refNode, tree, columnExprList);
                } else {
                    Node nextNode = refNode.getLastChild();
                    if (nextNode.getType() == 40) {
                        ColumnBinding info = new ColumnBinding(nextNode.getString(), "", level);
                        columnExprList.add(info);
                    }
                }
                return;
            }
            this.compileComplexExpr(refNode, tree, columnExprList);
            return;
        }
        this.compileSimpleColumnRefExpr(refNode, tree, columnExprList);
    }

    private void compileSimpleColumnRefExpr(Node refNode, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        Node rowName = refNode.getFirstChild();
        String str = rowName.getString();
        if (!$assertionsDisabled && str == null) {
            throw new AssertionError();
        }
        Node rowColumn = rowName.getNext();
        if (!$assertionsDisabled && rowColumn == null) {
            throw new AssertionError();
        }
        if (!str.equals("row")) {
            if (rowColumn != null && rowColumn.getNext() != null) {
                this.processChild(rowColumn.getNext(), tree, columnExprList);
            }
            return;
        }
        if ((refNode.getType() == 33 || refNode.getType() == 34) && rowColumn.getType() == 40) {
            int outer_count = 0;
            if ("__rownum".equals(rowColumn.getString()) || "0".equals(rowColumn.getString())) {
                return;
            }
            if ("_outer".equals(rowColumn.getString())) {
                Node outer_Node;
                ++outer_count;
                Node before_Node = outer_Node = refNode.getNext();
                while (outer_Node != null && outer_Node.getString() != null && "_outer".equals(outer_Node.getString())) {
                    ++outer_count;
                    before_Node = outer_Node;
                    outer_Node = outer_Node.getNext();
                }
                ColumnBinding info = new ColumnBinding(before_Node.getString(), "", outer_count);
                columnExprList.add(info);
                return;
            }
            ColumnBinding binding = new ColumnBinding(rowColumn.getString(), "dataSetRow[\"" + rowColumn.getString() + "\"]");
            columnExprList.add(binding);
        }
        if (refNode.getType() == 35 || refNode.getType() == 36) {
            if (rowColumn.getType() == 39) {
                if (0.0 == rowColumn.getDouble()) {
                    return;
                }
            } else if (rowColumn.getType() == 40) {
                if ("_rownum".equals(rowColumn.getString())) {
                    return;
                }
                ColumnBinding binding = new ColumnBinding(rowColumn.getString(), "dataSetRow[\"" + rowColumn.getString() + "\"]");
                columnExprList.add(binding);
            }
        }
        if (rowColumn != null && rowColumn.getNext() != null) {
            this.processChild(rowColumn.getNext(), tree, columnExprList);
        }
    }

    private int compileOuterColRefExpr(Node refNode) {
        int count = 0;
        Node rowFirstNode = refNode.getFirstChild();
        if (refNode.getType() == 33 || refNode.getType() == 35 || refNode.getType() == 34 || refNode.getType() == 36) {
            if (rowFirstNode.getType() == 38 && rowFirstNode.getString().equals("row")) {
                Node rowColumn = rowFirstNode.getNext();
                if (rowColumn.getType() == 40 && "_outer".equals(rowColumn.getString())) {
                    ++count;
                }
                return count;
            }
            if (rowFirstNode.getType() == 33 || rowFirstNode.getType() == 34) {
                if (this.compileOuterColRefExpr(rowFirstNode) == -1) {
                    return -1;
                }
                count += this.compileOuterColRefExpr(rowFirstNode);
                Node nextChild = rowFirstNode.getNext();
                if (nextChild.getType() == 40 && "_outer".equals(nextChild.getString())) {
                    ++count;
                }
            } else {
                return -1;
            }
            return count;
        }
        return -1;
    }

    private void compileAggregateExpr(Node callNode, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        if (!$assertionsDisabled && callNode.getType() != 37) {
            throw new AssertionError();
        }
        this.compileAggregationFunction(callNode, tree, columnExprList);
        this.extractArguments(callNode, tree, columnExprList);
    }

    private void compileAggregationFunction(Node callNode, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        Node firstChild = callNode.getFirstChild();
        if (firstChild.getType() != 33) {
            return;
        }
        Node getPropLeftChild = firstChild.getFirstChild();
        if (getPropLeftChild.getType() == 38 && getPropLeftChild.getString().equals(TOTAL)) {
            hasAggregation = true;
        }
        this.compileComplexExpr(firstChild, tree, columnExprList);
    }

    private void extractArguments(Node callNode, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        Node arg = callNode.getFirstChild().getNext();
        while (arg != null) {
            Node nextArg = arg.getNext();
            this.processChild(arg, tree, columnExprList);
            arg = nextArg;
        }
    }

    private void compileComplexExpr(Node complexNode, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        Node child = complexNode.getFirstChild();
        while (child != null) {
            if (child.getType() == 105) {
                int index = this.getFunctionIndex(child.getString(), tree);
                this.compileFunctionNode(tree.getFunctionNode(index), tree, columnExprList);
            }
            Node nextChild = child.getNext();
            if (child.getType() == 39 || child.getType() == 40 || child.getType() == 44 || child.getType() == 43 || child.getType() == 41) {
                this.processChild(child, tree, columnExprList);
                child = nextChild;
                continue;
            }
            this.processChild(child, tree, columnExprList);
            child = nextChild;
        }
    }

    private void compileFunctionNode(FunctionNode node, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        this.compileComplexExpr((Node)node, tree, columnExprList);
    }

    private int getFunctionIndex(String functionName, ScriptOrFnNode tree) {
        int index = -1;
        for (int i = 0; i < tree.getFunctionCount(); ++i) {
            if (!tree.getFunctionNode(i).getFunctionName().equals(functionName)) continue;
            index = i;
            break;
        }
        return index;
    }

    static {
        $assertionsDisabled = !ExpressionParserUtility.class.desiredAssertionStatus();
        instance = new ExpressionParserUtility();
        hasAggregation = false;
    }
}

