/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.format;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NumberFormatter {
    protected static Logger logger = Logger.getLogger(NumberFormatter.class.getName());
    protected String formatPattern;
    protected ULocale locale = ULocale.getDefault();
    protected NumberFormat numberFormat;
    private boolean hexFlag;

    public NumberFormatter() {
        this.applyPattern(null);
    }

    public NumberFormatter(String format) {
        this.applyPattern(format);
    }

    public NumberFormatter(ULocale locale) {
        this.locale = locale;
        this.applyPattern(null);
    }

    public NumberFormatter(Locale locale) {
        this(ULocale.forLocale((Locale)locale));
    }

    public NumberFormatter(String pattern, ULocale locale) {
        this.locale = locale;
        this.applyPattern(pattern);
    }

    public NumberFormatter(String pattern, Locale locale) {
        this(pattern, ULocale.forLocale((Locale)locale));
    }

    public String getPattern() {
        return this.formatPattern;
    }

    public void applyPattern(String patternStr) {
        try {
            this.formatPattern = patternStr;
            this.hexFlag = false;
            if (this.formatPattern == null) {
                this.numberFormat = NumberFormat.getInstance((ULocale)this.locale);
                this.numberFormat.setGroupingUsed(false);
                return;
            }
            if (patternStr.length() == 1) {
                this.handleSingleCharFormatString(patternStr.charAt(0));
                return;
            }
            this.handleNamedFormats(patternStr);
        }
        catch (Exception illeagueE) {
            logger.log(Level.WARNING, illeagueE.getMessage(), illeagueE);
        }
    }

    public String format(double num) {
        try {
            if (Double.isNaN(num)) {
                return "NaN";
            }
            if (this.hexFlag) {
                return Long.toHexString(new Double(num).longValue());
            }
            return this.numberFormat.format(num);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public String format(BigDecimal bigDecimal) {
        try {
            if (this.hexFlag) {
                return Long.toHexString(bigDecimal.longValue());
            }
            return this.numberFormat.format((Object)bigDecimal);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public String format(Number number) {
        try {
            if (Double.isNaN(number.doubleValue())) {
                return "NaN";
            }
            if (this.hexFlag) {
                return Long.toHexString(number.longValue());
            }
            return this.numberFormat.format((Object)number);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public String format(long num) {
        if (this.hexFlag) {
            return Long.toHexString(num);
        }
        return this.numberFormat.format(num);
    }

    private void handleSingleCharFormatString(char c) {
        switch (c) {
            case 'D': 
            case 'G': 
            case 'd': 
            case 'g': {
                this.numberFormat = NumberFormat.getInstance((ULocale)this.locale);
                return;
            }
            case 'C': 
            case 'c': {
                this.numberFormat = NumberFormat.getCurrencyInstance((ULocale)this.locale);
                return;
            }
            case 'F': 
            case 'f': {
                this.numberFormat = new DecimalFormat("#0.00", new DecimalFormatSymbols(this.locale));
                return;
            }
            case 'N': 
            case 'n': {
                this.numberFormat = new DecimalFormat("###,##0.00", new DecimalFormatSymbols(this.locale));
                return;
            }
            case 'P': 
            case 'p': {
                this.numberFormat = new DecimalFormat("###,##0.00 %", new DecimalFormatSymbols(this.locale));
                return;
            }
            case 'E': 
            case 'e': {
                this.numberFormat = new DecimalFormat("0.000000E00", new DecimalFormatSymbols(this.locale));
                return;
            }
            case 'X': 
            case 'x': {
                this.hexFlag = true;
                return;
            }
        }
        char[] data = new char[]{c};
        String str = new String(data);
        this.numberFormat = new DecimalFormat(str, new DecimalFormatSymbols(this.locale));
    }

    private void handleNamedFormats(String patternStr) {
        if (patternStr.equals("General Number") || patternStr.equals("Unformatted")) {
            this.numberFormat = NumberFormat.getInstance((ULocale)this.locale);
            this.numberFormat.setGroupingUsed(false);
            return;
        }
        if (patternStr.equals("Fixed")) {
            this.numberFormat = new DecimalFormat("#0.00", new DecimalFormatSymbols(this.locale));
            return;
        }
        if (patternStr.equals("Percent")) {
            this.numberFormat = new DecimalFormat("0.00%", new DecimalFormatSymbols(this.locale));
            return;
        }
        if (patternStr.equals("Scientific")) {
            this.numberFormat = new DecimalFormat("0.00E00", new DecimalFormatSymbols(this.locale));
            return;
        }
        if (patternStr.equals("Standard")) {
            this.numberFormat = new DecimalFormat("###,##0.00", new DecimalFormatSymbols(this.locale));
            return;
        }
        this.numberFormat = new DecimalFormat(patternStr, new DecimalFormatSymbols(this.locale));
    }

    public Number parse(String number) throws ParseException {
        return this.numberFormat.parse(number);
    }
}

