/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.sample.reportitem.rotatedtext;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.extension.IRowSet;
import org.eclipse.birt.report.engine.extension.ReportItemPresentationBase;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ReportItem;
import org.eclipse.birt.sample.reportitem.rotatedtext.util.GraphicsUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class RotatedTextPresentationImpl
extends ReportItemPresentationBase {
    private File fRotatedTextImage = null;
    private FileInputStream fis = null;
    private FileOutputStream fos = null;
    private String sExtension = null;
    private ReportItem rotatedText = null;
    private ExtendedItemHandle modelHandle = null;
    GraphicsUtil graphicsUtil = null;

    public void setModelObject(ExtendedItemHandle modelHandle) {
        Object item = null;
        this.modelHandle = modelHandle;
    }

    public void setOutputFormat(String outputFormat) {
        this.sExtension = outputFormat.equalsIgnoreCase("HTML") ? "PNG" : (outputFormat.equalsIgnoreCase("PDF") ? "JPEG" : outputFormat);
    }

    public int getOutputType() {
        return 1;
    }

    public Object onRowSets(IRowSet[] rowSets) throws BirtException {
        if (this.modelHandle == null) {
            return null;
        }
        Integer angle = new Integer(90);
        if (this.modelHandle.getProperty("rotationAngle") != null) {
            angle = (Integer)this.modelHandle.getProperty("rotationAngle");
        }
        String text = "Rotated Text";
        if (this.modelHandle.getProperty("displayText") != null) {
            text = (String)this.modelHandle.getProperty("displayText");
        }
        this.graphicsUtil = new GraphicsUtil();
        Image rotatedImage = this.graphicsUtil.createRotatedText(text, angle);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{rotatedImage.getImageData()};
        try {
            this.fRotatedTextImage = File.createTempFile("test", "." + this.sExtension);
            this.fos = new FileOutputStream(this.fRotatedTextImage.getPath());
            this.fis = new FileInputStream(this.fRotatedTextImage.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        imageLoader.save((OutputStream)this.fos, 4);
        return this.fis;
    }

    public void finish() {
        super.finish();
        if (this.graphicsUtil != null) {
            this.graphicsUtil.cleanUp();
        }
        try {
            this.fos.close();
            this.fis.close();
            this.fRotatedTextImage.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

