/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.sample.reportitem.rotatedtext.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class GraphicsUtil {
    private Display display = null;
    private GC gc = null;

    private GraphicsUtil(Display display, GC gc) {
        this.display = display;
        this.gc = gc;
    }

    public GraphicsUtil() {
        this.display = new Display();
        this.gc = new GC((Drawable)this.display);
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public GC getGc() {
        return this.gc;
    }

    public void setGc(GC gc) {
        this.gc = gc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image createRotatedText(String text, Integer angle) {
        Image stringImage = null;
        try {
            if (text == null || text.trim().length() == 0) {
                text = new String("Rotated Text Sample");
            }
            if (this.display == null) {
                SWT.error((int)22);
            }
            FontMetrics fm = this.gc.getFontMetrics();
            Point pt = this.gc.textExtent(text);
            this.gc.dispose();
            stringImage = new Image((Device)this.display, pt.x, pt.y);
            this.gc = new GC((Drawable)stringImage);
            this.gc.drawText(text, 0, 0);
            Image image = this.createRotatedImage(stringImage, 1024);
            this.gc.dispose();
            stringImage.dispose();
            Image image2 = image;
            return image2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Image createRotatedImage(Image image, int style) {
        if (this.display == null) {
            SWT.error((int)22);
        }
        ImageData sd = image.getImageData();
        ImageData dd = new ImageData(sd.height, sd.width, sd.depth, sd.palette);
        boolean up = (style & 0x80) == 128;
        for (int sx = 0; sx < sd.width; ++sx) {
            for (int sy = 0; sy < sd.height; ++sy) {
                int dx = up ? sy : sd.height - sy - 1;
                int dy = up ? sd.width - sx - 1 : sx;
                dd.setPixel(dx, dy, sd.getPixel(sx, sy));
            }
        }
        return new Image((Device)this.display, dd);
    }

    public void cleanUp() {
        if (this.gc != null && !this.gc.isDisposed()) {
            this.gc.dispose();
        }
        if (this.display != null && !this.display.isDisposed()) {
            this.display.dispose();
        }
    }
}

