/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.adapter.oda.NativeDataTypeUtil;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ElementNullability;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputParameterAttributes;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.emf.common.util.EList;

class DataSetParameterAdapter {
    DataSetParameterAdapter() {
    }

    public ParameterDefinition newParameterDefinition(DataSetParameterHandle paramDefn) {
        if (paramDefn == null) {
            return null;
        }
        ParameterDefinition odaParamDefn = DesignFactory.eINSTANCE.createParameterDefinition();
        odaParamDefn.setInOutMode(this.newParameterMode(paramDefn.isInput(), paramDefn.isOutput()));
        odaParamDefn.setAttributes(this.newDataElementAttrs(paramDefn));
        InputParameterAttributes inputAttrs = DesignFactory.eINSTANCE.createInputParameterAttributes();
        inputAttrs.setElementAttributes(this.newInputElementAttrs(paramDefn));
        odaParamDefn.setInputAttributes(inputAttrs);
        return odaParamDefn;
    }

    private ParameterMode newParameterMode(boolean isInput, boolean isOutput) {
        int mode = 0;
        if (isOutput && isInput) {
            mode = 2;
        } else if (isOutput) {
            mode = 1;
        } else if (isInput) {
            mode = 0;
        }
        return ParameterMode.get((int)mode);
    }

    private DataElementAttributes newDataElementAttrs(DataSetParameterHandle paramDefn) {
        Integer nativeDataType;
        DataElementAttributes dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setNullability(this.newElementNullability(paramDefn.allowNull()));
        dataAttrs.setName(paramDefn.getName());
        Integer position = paramDefn.getPosition();
        if (position != null) {
            dataAttrs.setPosition(position.intValue());
        }
        if ((nativeDataType = paramDefn.getNativeDataType()) != null) {
            dataAttrs.setNativeDataTypeCode(nativeDataType.intValue());
        }
        dataAttrs.setName(paramDefn.getName());
        return dataAttrs;
    }

    private ElementNullability newElementNullability(boolean isNullable) {
        int nullAbility = 0;
        if (isNullable) {
            nullAbility = 1;
        }
        return ElementNullability.get((int)nullAbility);
    }

    public DataSetParameter newROMDataSetParameter(ParameterDefinition odaParamDefn, String dataSourceId, String dataSetId) {
        InputElementAttributes inputElementAttrs;
        InputParameterAttributes inputAttrs;
        DataElementAttributes dataAttrs = odaParamDefn.getAttributes();
        DataSetParameter setParam = StructureFactory.createDataSetParameter();
        this.updateROMParameterMode(setParam, odaParamDefn.getInOutMode());
        if (dataAttrs != null) {
            this.updateROMNullability(setParam, dataAttrs.getNullability());
            setParam.setName(dataAttrs.getName());
            setParam.setPosition(new Integer(dataAttrs.getPosition()));
            String romDataType = null;
            try {
                romDataType = NativeDataTypeUtil.nativeCodeToROMType(dataSourceId, dataSetId, "columnDataType", dataAttrs.getNativeDataTypeCode());
            }
            catch (OdaException e) {
            }
            catch (BirtException e) {
                // empty catch block
            }
            setParam.setDataType(romDataType);
            setParam.setNativeDataType(new Integer(dataAttrs.getNativeDataTypeCode()));
        }
        if ((inputAttrs = odaParamDefn.getInputAttributes()) != null && (inputElementAttrs = inputAttrs.getElementAttributes()) != null) {
            setParam.setDefaultValue(inputElementAttrs.getDefaultScalarValue());
            setParam.setIsOptional(inputElementAttrs.isOptional());
        }
        return setParam;
    }

    private void updateROMParameterMode(DataSetParameter romParamDefn, ParameterMode odaMode) {
        if (odaMode == null) {
            return;
        }
        switch (odaMode.getValue()) {
            case 2: {
                romParamDefn.setIsInput(true);
                romParamDefn.setIsOutput(true);
                break;
            }
            case 0: {
                romParamDefn.setIsInput(true);
                break;
            }
            case 1: {
                romParamDefn.setIsOutput(true);
            }
        }
    }

    private void updateROMNullability(DataSetParameter romParamDefn, ElementNullability nullability) {
        if (nullability == null) {
            return;
        }
        switch (nullability.getValue()) {
            case 1: {
                romParamDefn.setAllowNull(true);
                break;
            }
            case 2: {
                romParamDefn.setAllowNull(false);
                break;
            }
        }
    }

    private InputElementAttributes newInputElementAttrs(DataSetParameterHandle paramDefn) {
        InputElementAttributes inputAttrs = DesignFactory.eINSTANCE.createInputElementAttributes();
        inputAttrs.setDefaultScalarValue(paramDefn.getDefaultValue());
        inputAttrs.setOptional(paramDefn.isOptional());
        return inputAttrs;
    }

    List newROMSetParams(DataSetParameters odaSetParams, String dataSourceId, String dataSetId) {
        if (odaSetParams == null) {
            return null;
        }
        EList odaParams = odaSetParams.getParameterDefinitions();
        if (odaParams == null || odaParams.isEmpty()) {
            return null;
        }
        ArrayList<DataSetParameter> retList = new ArrayList<DataSetParameter>();
        for (int i = 0; i < odaParams.size(); ++i) {
            ParameterDefinition odaParamDefn = (ParameterDefinition)odaParams.get(i);
            DataSetParameter setParam = this.newROMDataSetParameter(odaParamDefn, dataSourceId, dataSetId);
            retList.add(setParam);
        }
        return retList;
    }

    DataSetParameters newOdaDataSetParams(Iterator romSetParams) {
        if (!romSetParams.hasNext()) {
            return null;
        }
        DataSetParameters odaSetParams = DesignFactory.eINSTANCE.createDataSetParameters();
        DataSetParameterAdapter setParamAdapter = new DataSetParameterAdapter();
        while (romSetParams.hasNext()) {
            DataSetParameterHandle paramDefn = (DataSetParameterHandle)romSetParams.next();
            ParameterDefinition odaParamDefn = setParamAdapter.newParameterDefinition(paramDefn);
            odaSetParams.getParameterDefinitions().add((Object)odaParamDefn);
        }
        return odaSetParams;
    }
}

