/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda;

import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.OdaDesignerStateHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.OdaDesignerState;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.DesignerStateContent;

class DesignerStateAdapter {
    DesignerStateAdapter() {
    }

    static void updateROMDesignerState(DesignerState designerState, ReportElementHandle reportElement) throws SemanticException {
        if (designerState == null || reportElement == null) {
            return;
        }
        CommandStack cmdStack = reportElement.getModuleHandle().getCommandStack();
        cmdStack.startTrans(null);
        OdaDesignerStateHandle romDesignerState = null;
        if (reportElement instanceof OdaDataSourceHandle) {
            romDesignerState = ((OdaDataSourceHandle)reportElement).getDesignerState();
        } else if (reportElement instanceof OdaDataSetHandle) {
            romDesignerState = ((OdaDataSetHandle)reportElement).getDesignerState();
        } else {
            return;
        }
        if (romDesignerState == null) {
            OdaDesignerState tmpDesignerState = StructureFactory.createOdaDesignerState();
            if (reportElement instanceof OdaDataSourceHandle) {
                romDesignerState = ((OdaDataSourceHandle)reportElement).setDesignerState(tmpDesignerState);
            } else if (reportElement instanceof OdaDataSetHandle) {
                romDesignerState = ((OdaDataSetHandle)reportElement).setDesignerState(tmpDesignerState);
            }
        }
        romDesignerState.setVersion(designerState.getVersion());
        DesignerStateContent stateContent = designerState.getStateContent();
        if (stateContent == null) {
            return;
        }
        romDesignerState.setContentAsString(stateContent.getStateContentAsString());
        romDesignerState.setContentAsBlob(stateContent.getStateContentAsBlob());
        cmdStack.commit();
    }

    static DesignerState createOdaDesignState(OdaDesignerStateHandle designerState) {
        if (designerState == null) {
            return null;
        }
        DesignerState odaState = DesignFactory.eINSTANCE.createDesignerState();
        odaState.setVersion(designerState.getVersion());
        byte[] blobContent = designerState.getContentAsBlob();
        String stringContent = designerState.getContentAsString();
        if (blobContent == null && stringContent == null) {
            return odaState;
        }
        DesignerStateContent stateContent = DesignFactory.eINSTANCE.createDesignerStateContent();
        if (blobContent != null) {
            stateContent.setStateContentAsBlob(blobContent);
        }
        if (stringContent != null) {
            stateContent.setStateContentAsString(stringContent);
        }
        odaState.setStateContent(stateContent);
        return odaState;
    }
}

