/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataTypeMapping;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

class NativeDataTypeUtil {
    NativeDataTypeUtil() {
    }

    static String nativeCodeToROMType(String dataSourceId, String dataSetId, String choiceName, int nativeCode) throws OdaException, BirtException {
        ExtensionManifest manifest = ManifestExplorer.getInstance().getExtensionManifest(dataSourceId);
        if (manifest == null) {
            return null;
        }
        DataSetType setType = manifest.getDataSetType(dataSetId);
        if (setType == null) {
            return null;
        }
        DataTypeMapping typeMapping = setType.getDataTypeMapping(nativeCode);
        if (typeMapping == null) {
            return null;
        }
        int odaDataTypeCode = typeMapping.getOdaScalarDataTypeCode();
        int apiDataType = DataTypeUtil.toApiDataType((int)odaDataTypeCode);
        return NativeDataTypeUtil.convertApiTypeToROMType(choiceName, apiDataType);
    }

    private static String convertApiTypeToROMType(String choiceName, int apiDataType) {
        if ("columnDataType".equalsIgnoreCase(choiceName)) {
            return NativeDataTypeUtil.convertApiTypeToROMColumnType(apiDataType);
        }
        return null;
    }

    private static String convertApiTypeToROMColumnType(int apiDataType) {
        switch (apiDataType) {
            case 0: {
                return "any";
            }
            case 2: {
                return "integer";
            }
            case 5: {
                return "string";
            }
            case 6: {
                return "date-time";
            }
            case 4: {
                return "decimal";
            }
            case 3: {
                return "float";
            }
        }
        return null;
    }
}

