/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.adapter.oda.NativeDataTypeUtil;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.emf.common.util.EList;

class ResultSetsAdapter {
    ResultSetsAdapter() {
    }

    private static List newROMResultSetColumns(ResultSetColumns setColumns, String dataSourceId, String dataSetId) {
        if (setColumns == null) {
            return null;
        }
        EList odaSetColumns = setColumns.getResultColumnDefinitions();
        if (odaSetColumns.isEmpty()) {
            return null;
        }
        ArrayList<ResultSetColumn> retList = new ArrayList<ResultSetColumn>();
        for (int i = 0; i < odaSetColumns.size(); ++i) {
            ColumnDefinition columnDefn = (ColumnDefinition)odaSetColumns.get(i);
            DataElementAttributes dataAttrs = columnDefn.getAttributes();
            if (dataAttrs == null) continue;
            ResultSetColumn newColumn = StructureFactory.createResultSetColumn();
            newColumn.setColumnName(dataAttrs.getName());
            newColumn.setPosition(new Integer(dataAttrs.getPosition()));
            retList.add(newColumn);
            String romDataType = null;
            try {
                romDataType = NativeDataTypeUtil.nativeCodeToROMType(dataSourceId, dataSetId, "columnDataType", dataAttrs.getNativeDataTypeCode());
            }
            catch (OdaException e) {
            }
            catch (BirtException e) {
                // empty catch block
            }
            newColumn.setDataType(romDataType);
            newColumn.setNativeDataType(new Integer(dataAttrs.getNativeDataTypeCode()));
        }
        return retList;
    }

    static List newROMResultSets(ResultSetDefinition setDefn, String dataSourceId, String dataSetId) {
        if (setDefn == null) {
            return null;
        }
        ArrayList retList = new ArrayList();
        ResultSetColumns setColumns = setDefn.getResultSetColumns();
        retList.addAll(ResultSetsAdapter.newROMResultSetColumns(setColumns, dataSourceId, dataSetId));
        return retList;
    }

    static ResultSetDefinition newOdaResultSetDefinition(OdaDataSetHandle setHandle) {
        Iterator romSets = setHandle.resultSetIterator();
        String name = setHandle.getResultSetName();
        if (!romSets.hasNext() && StringUtil.isBlank((String)name)) {
            return null;
        }
        ResultSetDefinition odaSetDefn = null;
        ResultSetColumns odaSetColumns = null;
        if (!StringUtil.isBlank((String)name)) {
            odaSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
            odaSetDefn.setName(name);
        }
        while (romSets.hasNext()) {
            Integer nativeDataType;
            if (odaSetDefn == null) {
                odaSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
            }
            if (odaSetColumns == null) {
                odaSetColumns = DesignFactory.eINSTANCE.createResultSetColumns();
            }
            ResultSetColumnHandle setColumn = (ResultSetColumnHandle)romSets.next();
            ColumnDefinition columnDefn = DesignFactory.eINSTANCE.createColumnDefinition();
            DataElementAttributes dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
            dataAttrs.setName(setColumn.getColumnName());
            Integer position = setColumn.getPosition();
            if (position != null) {
                dataAttrs.setPosition(setColumn.getPosition().intValue());
            }
            if ((nativeDataType = setColumn.getNativeDataType()) != null) {
                dataAttrs.setNativeDataTypeCode(nativeDataType.intValue());
            }
            columnDefn.setAttributes(dataAttrs);
            odaSetColumns.getResultColumnDefinitions().add((Object)columnDefn);
        }
        odaSetDefn.setResultSetColumns(odaSetColumns);
        return odaSetDefn;
    }
}

