/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation.dialog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.presentation.aggregation.BirtBaseFragment;
import org.eclipse.birt.report.presentation.aggregation.dialog.BaseDialogFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.CheckboxParameterFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.ComboBoxParameterFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.ParameterGroupFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.RadioButtonParameterFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.TextBoxParameterFragment;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ParameterGroupDefinition;
import org.eclipse.birt.report.service.api.ReportServiceException;

public class ParameterDialogFragment
extends BaseDialogFragment {
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getClientId() {
        return "parameterDialog";
    }

    public String getClientName() {
        return "Parameter";
    }

    public String getTitle() {
        return BirtResources.getString("birt.viewer.dialog.parameter.title");
    }

    protected void doService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ArrayList<ParameterGroupFragment> arrayList = new ArrayList<ParameterGroupFragment>();
        IViewerReportService iViewerReportService = this.getReportService();
        Collection collection = null;
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("request", httpServletRequest);
        BaseAttributeBean baseAttributeBean = (BaseAttributeBean)httpServletRequest.getAttribute("attributeBean");
        if (!$assertionsDisabled && baseAttributeBean == null) {
            throw new AssertionError();
        }
        try {
            collection = iViewerReportService.getParameterDefinitions(baseAttributeBean.getReportDesignHandle(httpServletRequest), inputOptions, true);
        }
        catch (ReportServiceException reportServiceException) {
            reportServiceException.printStackTrace();
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator != null && iterator.hasNext()) {
                ParameterDefinition parameterDefinition;
                Object e = iterator.next();
                if (e == null) continue;
                BirtBaseFragment birtBaseFragment = null;
                if (e instanceof ParameterGroupDefinition) {
                    birtBaseFragment = new ParameterGroupFragment((ParameterGroupDefinition)e);
                } else if (e instanceof ParameterDefinition && !(parameterDefinition = (ParameterDefinition)e).isHidden()) {
                    switch (parameterDefinition.getControlType()) {
                        case 0: {
                            birtBaseFragment = new TextBoxParameterFragment(parameterDefinition);
                            break;
                        }
                        case 1: {
                            birtBaseFragment = new ComboBoxParameterFragment(parameterDefinition);
                            break;
                        }
                        case 2: {
                            birtBaseFragment = new RadioButtonParameterFragment(parameterDefinition);
                            break;
                        }
                        case 3: {
                            birtBaseFragment = new CheckboxParameterFragment(parameterDefinition);
                        }
                    }
                }
                if (birtBaseFragment == null) continue;
                birtBaseFragment.setJSPRootPath(this.JSPRootPath);
                arrayList.add((ParameterGroupFragment)birtBaseFragment);
            }
        }
        httpServletRequest.setAttribute("fragments", arrayList);
    }

    static {
        $assertionsDisabled = !ParameterDialogFragment.class.desiredAssertionStatus();
    }
}

