/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.metadata.ValidationValueException;
import org.eclipse.birt.report.model.api.util.ParameterValidationUtil;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.actionhandler.AbstractGetCascadeParameterActionHandler;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ParameterGroupDefinition;
import org.eclipse.birt.report.service.api.ParameterSelectionChoice;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.soapengine.api.CascadeParameter;
import org.eclipse.birt.report.soapengine.api.Data;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Oprand;
import org.eclipse.birt.report.soapengine.api.SelectItemChoice;
import org.eclipse.birt.report.soapengine.api.SelectionList;
import org.eclipse.birt.report.soapengine.api.Update;
import org.eclipse.birt.report.soapengine.api.UpdateData;

public class BirtGetCascadeParameterActionHandler
extends AbstractGetCascadeParameterActionHandler {
    static final /* synthetic */ boolean $assertionsDisabled;

    public BirtGetCascadeParameterActionHandler(IContext iContext, Operation operation, GetUpdatedObjectsResponse getUpdatedObjectsResponse) {
        super(iContext, operation, getUpdatedObjectsResponse);
    }

    protected void __execute() throws RemoteException {
        Object object;
        Object object2;
        SelectionList[] selectionListArray;
        ViewerAttributeBean viewerAttributeBean = (ViewerAttributeBean)this.context.getBean();
        if (!$assertionsDisabled && viewerAttributeBean == null) {
            throw new AssertionError();
        }
        Oprand[] oprandArray = this.operation.getOprand();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("request", this.context.getRequest());
        IViewerReportDesignHandle iViewerReportDesignHandle = viewerAttributeBean.getReportDesignHandle(this.context.getRequest());
        Map map = null;
        try {
            for (int i = 0; i < oprandArray.length; ++i) {
                selectionListArray = oprandArray[i];
                String string = selectionListArray.getName();
                object2 = (ScalarParameterHandle)viewerAttributeBean.findParameter(string);
                if (object2 == null) continue;
                object = ParameterValidationUtil.validate((String)object2.getDataType(), (String)"MM/dd/yyyy hh:mm:ss a", (String)selectionListArray.getValue());
                linkedHashMap.put(string, object);
            }
            map = this.getParameterSelectionLists(iViewerReportDesignHandle, linkedHashMap, inputOptions, viewerAttributeBean);
        }
        catch (ReportServiceException reportServiceException) {
            AxisFault axisFault = new AxisFault(reportServiceException.getLocalizedMessage());
            axisFault.setFaultCode(new QName("TODO"));
            axisFault.setFaultString(reportServiceException.getMessage());
            throw axisFault;
        }
        catch (ValidationValueException validationValueException) {
            AxisFault axisFault = new AxisFault(validationValueException.getLocalizedMessage());
            axisFault.setFaultCode(new QName("TODO"));
            axisFault.setFaultString(validationValueException.getMessage());
            throw axisFault;
        }
        CascadeParameter cascadeParameter = new CascadeParameter();
        if (map != null && map.size() > 0) {
            selectionListArray = new SelectionList[map.size()];
            int n = 0;
            object2 = map.keySet().iterator();
            while (object2.hasNext()) {
                selectionListArray[n] = new SelectionList();
                object = (String)object2.next();
                selectionListArray[n].setName((String)object);
                List list = (List)map.get(object);
                SelectItemChoice[] selectItemChoiceArray = this.getVectorFromList(list);
                selectionListArray[n].setSelections(selectItemChoiceArray);
                ++n;
            }
            cascadeParameter.setSelectionList(selectionListArray);
        }
        this.handleUpdate(cascadeParameter);
    }

    private SelectItemChoice[] getVectorFromList(List list) {
        SelectItemChoice[] selectItemChoiceArray = new SelectItemChoice[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SelectItemChoice selectItemChoice = (SelectItemChoice)list.get(i);
            selectItemChoiceArray[i] = new SelectItemChoice(selectItemChoice.getValue(), selectItemChoice.getLabel());
        }
        return selectItemChoiceArray;
    }

    private Map getParameterSelectionLists(IViewerReportDesignHandle iViewerReportDesignHandle, Map map, InputOptions inputOptions, ViewerAttributeBean viewerAttributeBean) throws ReportServiceException {
        Object object;
        if (map == null || map.size() == 0) {
            return new HashMap();
        }
        List[] listArray = null;
        HashMap hashMap = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = (String)map.keySet().iterator().next();
        Collection collection = this.getReportService().getParameterDefinitions(iViewerReportDesignHandle, inputOptions, false);
        ParameterDefinition parameterDefinition = null;
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            ParameterDefinition parameterDefinition2 = (ParameterDefinition)object2.next();
            if (!parameterDefinition2.getName().equals(string)) continue;
            parameterDefinition = parameterDefinition2;
            break;
        }
        if (parameterDefinition == null) {
            throw new ReportServiceException(BirtResources.getFormattedString("birt.viewer.reportServiceException.INVALID_PARAMETER", new String[]{string}));
        }
        object2 = parameterDefinition.getGroup();
        if (object2 != null && ((ParameterGroupDefinition)object2).getParameterCount() > map.size()) {
            int n = ((ParameterGroupDefinition)object2).getParameterCount() - map.size();
            for (int i = 0; i < n; ++i) {
                object = (ParameterDefinition)((ParameterGroupDefinition)object2).getParameters().get(map.size() + i);
                arrayList.add(((ParameterDefinition)object).getName());
            }
        }
        try {
            if (arrayList.size() > 0) {
                listArray = new List[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object[] objectArray = new Object[map.size() + i];
                    object = map.keySet();
                    int n = 0;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        objectArray[n] = map.get(iterator.next());
                        ++n;
                    }
                    for (n = 0; n < i; ++n) {
                        objectArray[map.size() + n] = listArray[n].isEmpty() ? null : listArray[n].get(0);
                    }
                    listArray[i] = this.doQueryCascadeParameterSelectionList(arrayList.get(i).toString(), iViewerReportDesignHandle, ((ParameterGroupDefinition)object2).getName(), objectArray, inputOptions, viewerAttributeBean);
                    hashMap.put(arrayList.get(i), listArray[i]);
                }
            }
        }
        catch (RemoteException remoteException) {
            throw new ReportServiceException(remoteException.getLocalizedMessage());
        }
        return hashMap;
    }

    private List doQueryCascadeParameterSelectionList(String string, IViewerReportDesignHandle iViewerReportDesignHandle, String string2, Object[] objectArray, InputOptions inputOptions, ViewerAttributeBean viewerAttributeBean) throws RemoteException, ReportServiceException {
        ArrayList<SelectItemChoice> arrayList = new ArrayList<SelectItemChoice>();
        Collection collection = this.getReportService().getSelectionListForCascadingGroup(iViewerReportDesignHandle, string2, objectArray, inputOptions);
        if (collection != null && collection.size() > 0) {
            ScalarParameterHandle scalarParameterHandle = (ScalarParameterHandle)viewerAttributeBean.findParameter(string);
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator != null && iterator.hasNext()) {
                ParameterSelectionChoice parameterSelectionChoice = (ParameterSelectionChoice)iterator.next();
                if (parameterSelectionChoice == null || parameterSelectionChoice.getValue() == null) continue;
                SelectItemChoice selectItemChoice = new SelectItemChoice();
                Object object = parameterSelectionChoice.getValue();
                String string3 = parameterSelectionChoice.getLabel();
                if (object == null) continue;
                if (string3 == null || string3.length() <= 0) {
                    string3 = ParameterValidationUtil.getDisplayValue(null, (String)scalarParameterHandle.getPattern(), (Object)object, (Locale)viewerAttributeBean.getLocale());
                }
                if (string3 == null) continue;
                selectItemChoice.setLabel(string3);
                selectItemChoice.setValue(ParameterValidationUtil.getDisplayValue((Object)object));
                arrayList.add(n++, selectItemChoice);
            }
        }
        return arrayList;
    }

    protected void handleUpdate(CascadeParameter cascadeParameter) {
        Data data = new Data();
        data.setCascadeParameter(cascadeParameter);
        UpdateData updateData = new UpdateData();
        updateData.setTarget("birtParameterDialog");
        updateData.setData(data);
        Update update = new Update();
        update.setUpdateData(updateData);
        this.response.setUpdate(new Update[]{update});
    }

    protected IViewerReportService getReportService() {
        return BirtReportServiceFactory.getReportService();
    }

    static {
        $assertionsDisabled = !BirtGetCascadeParameterActionHandler.class.desiredAssertionStatus();
    }
}

