/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.lib.views.outline.dnd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.views.outline.ReportElementModel;
import org.eclipse.birt.report.designer.internal.lib.commands.SetCurrentEditModelCommand;
import org.eclipse.birt.report.designer.internal.lib.editparts.LibraryReportDesignEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.extensions.GuiExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.AbstractToolHandleExtends;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ReportCreationTool;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.palette.BasePaletteFactory;
import org.eclipse.birt.report.designer.internal.ui.palette.ReportElementFactory;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.outline.dnd.DesignerDropListener;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class LibraryDropListener
extends DesignerDropListener {
    private static List supportList = new ArrayList();

    public LibraryDropListener(TreeViewer viewer) {
        super(viewer);
    }

    protected boolean validateTarget(Object target, Object transfer) {
        boolean retValue = super.validateTarget(target, transfer);
        if (!retValue) {
            retValue = this.isSupportPalletType(target, transfer) && this.getCurrentLocation() == 3;
        }
        return retValue;
    }

    private boolean validateSameParent(Object targetObj, Object transferData) {
        if (targetObj == null || transferData == null) {
            return false;
        }
        if (transferData instanceof String) {
            return true;
        }
        if (!(targetObj instanceof DesignElementHandle)) {
            return false;
        }
        if (transferData instanceof StructuredSelection) {
            return this.validateSameParent(targetObj, ((StructuredSelection)transferData).toArray());
        }
        if (transferData instanceof Object[]) {
            Object[] array = (Object[])transferData;
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                if (this.validateSameParent(targetObj, array[i])) continue;
                return false;
            }
            return true;
        }
        if (transferData instanceof DesignElementHandle) {
            return ((DesignElementHandle)targetObj).getContainer() == ((DesignElementHandle)transferData).getContainer();
        }
        return false;
    }

    private boolean isSupportPalletType(Object target, Object transfer) {
        boolean bool = false;
        if (target instanceof ReportElementModel) {
            bool = ((ReportElementModel)target).getSlotId() == 5;
        } else if (target instanceof LibraryHandle) {
            bool = true;
        }
        return bool & supportList.indexOf(transfer) >= 0;
    }

    protected boolean moveData(Object transfer, Object target) {
        if (this.isSupportPalletType(target, transfer)) {
            AbstractToolHandleExtends pre = BasePaletteFactory.getAbstractToolHandleExtendsFromPaletteName((Object)transfer);
            ReportCreationTool tool = new ReportCreationTool((CreationFactory)new ReportElementFactory(transfer), pre);
            EditDomain domain = UIUtil.getLayoutEditPartViewer().getEditDomain();
            tool.setEditDomain(domain);
            tool.setViewer(UIUtil.getLayoutEditPartViewer());
            tool.getTargetRequest().getExtendedData().put("direct create item", new Boolean(true));
            tool.performCreation(this.getLibrartReportEditPart());
            SetCurrentEditModelCommand command = new SetCurrentEditModelCommand(tool.getNewObjectFromRequest(), "create element");
            command.execute();
            return true;
        }
        return super.moveData(transfer, target);
    }

    private EditPart getLibrartReportEditPart() {
        EditPart retValue;
        for (retValue = UIUtil.getCurrentEditPart(); retValue != null && !(retValue instanceof LibraryReportDesignEditPart); retValue = retValue.getParent()) {
        }
        return retValue;
    }

    static {
        supportList.add("Label");
        supportList.add("Text");
        supportList.add("Data");
        supportList.add("Grid");
        supportList.add("Table");
        supportList.add("List");
        supportList.add("Image");
        supportList.add("TextData");
        List exts = ExtensionPointManager.getInstance().getExtendedElementPoints();
        if (exts != null) {
            Iterator itor = exts.iterator();
            while (itor.hasNext()) {
                ExtendedElementUIPoint point = (ExtendedElementUIPoint)itor.next();
                if (point == null) continue;
                supportList.add(GuiExtensionManager.getExtendedPalletTemplateName((ExtendedElementUIPoint)point));
            }
        }
    }
}

