/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.ui.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.data.oda.xml.impl.DataTypes;
import org.eclipse.birt.report.data.oda.xml.ui.Messages;
import org.eclipse.birt.report.data.oda.xml.ui.wizards.ColumnMappingElement;
import org.eclipse.birt.report.data.oda.xml.util.RelationInformation;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;

public final class ColumnMappingTableViewer {
    private TableViewer viewer;
    private Composite mainControl;
    private Button btnRemove;
    private Button btnUp;
    private Button btnDown;
    private MenuItem itmRemove;
    private MenuItem itmRemoveAll;
    private static HashMap typeIdDisplayNameMapping = new HashMap();

    public ColumnMappingTableViewer(Composite parent, boolean showMenus, boolean showButtons, boolean enableKeyStrokes) {
        this.mainControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.mainControl.setLayout((Layout)layout);
        GridData data = null;
        this.viewer = new TableViewer(this.mainControl, 65536);
        data = new GridData(1808);
        this.viewer.getControl().setLayoutData((Object)data);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        if (showButtons) {
            Composite btnComposite = new Composite(this.mainControl, 0);
            data = new GridData();
            data.verticalAlignment = 0x1000000;
            btnComposite.setLayoutData((Object)data);
            GridLayout btnLayout = new GridLayout();
            layout.verticalSpacing = 20;
            btnComposite.setLayout((Layout)btnLayout);
            GridData btnData = new GridData(2);
            btnData.widthHint = 20;
            btnData.heightHint = 20;
            this.btnUp = new Button(btnComposite, 132);
            this.btnUp.setLayoutData((Object)btnData);
            btnData = new GridData(2);
            btnData.widthHint = 20;
            btnData.heightHint = 20;
            this.btnRemove = new Button(btnComposite, 8);
            this.btnRemove.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
            this.btnRemove.setLayoutData((Object)btnData);
            this.btnRemove.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            btnData = new GridData(2);
            btnData.widthHint = 20;
            btnData.heightHint = 20;
            this.btnDown = new Button(btnComposite, 1028);
            this.btnDown.setLayoutData((Object)btnData);
            this.btnDown.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (showMenus) {
            Menu menu = new Menu((Control)this.viewer.getTable());
            menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    ColumnMappingTableViewer.this.viewer.cancelEditing();
                }
            });
            this.itmRemove = new MenuItem(menu, 0);
            this.itmRemove.setText(Messages.getString("menu.menuItem.remove"));
            this.itmRemoveAll = new MenuItem(menu, 0);
            this.itmRemoveAll.setText(Messages.getString("menu.menuItem.removeAll"));
            this.viewer.getTable().setMenu(menu);
        }
        if (enableKeyStrokes) {
            this.viewer.getTable().addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 127) {
                        // empty if block
                    }
                }
            });
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public Composite getControl() {
        return this.mainControl;
    }

    public Button getUpButton() {
        return this.btnUp;
    }

    public Button getDownButton() {
        return this.btnDown;
    }

    public Button getRemoveButton() {
        return this.btnRemove;
    }

    public MenuItem getRemoveMenuItem() {
        return this.itmRemove;
    }

    public MenuItem getRemoveAllMenuItem() {
        return this.itmRemoveAll;
    }

    public List refresh(RelationInformation info, String tableName, Map columnMapping) {
        ArrayList<ColumnMappingElement> columnsList = new ArrayList<ColumnMappingElement>();
        if (info == null) {
            return columnsList;
        }
        String[] columnName = info.getTableColumnNames(tableName);
        String[] columnType = new String[columnName.length];
        String[] columnPath = new String[columnName.length];
        ColumnMappingElement element = null;
        for (int i = 0; i < columnName.length; ++i) {
            columnType[i] = info.getTableColumnType(tableName, columnName[i]);
            columnPath[i] = info.getTableOriginalColumnPath(tableName, columnName[i]);
            element = new ColumnMappingElement();
            element.setColumnName(columnName[i]);
            element.setXPath(columnPath[i]);
            try {
                element.setType(typeIdDisplayNameMapping.get(new Integer(DataTypes.getType((String)columnType[i]))).toString());
            }
            catch (OdaException e) {
                // empty catch block
            }
            columnMapping.put(columnName[i], element);
            columnsList.add(element);
        }
        return columnsList;
    }

    static {
        typeIdDisplayNameMapping.put(new Integer(93), Messages.getString("datatypes.dateTime"));
        typeIdDisplayNameMapping.put(new Integer(2), Messages.getString("datatypes.decimal"));
        typeIdDisplayNameMapping.put(new Integer(8), Messages.getString("datatypes.float"));
        typeIdDisplayNameMapping.put(new Integer(4), Messages.getString("datatypes.integer"));
        typeIdDisplayNameMapping.put(new Integer(91), Messages.getString("datatypes.date"));
        typeIdDisplayNameMapping.put(new Integer(92), Messages.getString("datatypes.time"));
        typeIdDisplayNameMapping.put(new Integer(12), Messages.getString("datatypes.string"));
    }
}

