/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.PropertyHandleTableViewer;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ComboBoxExpressionCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ExpressionValueCellEditor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ExtendedItemFilterDialog
extends BaseDialog
implements ITableLabelProvider,
ISelectionChangedListener {
    private transient PropertyHandleTableViewer viewer = null;
    private transient String[] columnExpressions = null;
    private transient PropertyHandle filters = null;
    private transient FilterCondition newFilter = null;
    private transient boolean isOperatorSet = false;
    private static String[] operators;
    private static String[] operatorDisplayNames;
    private transient ComboBoxExpressionCellEditor columnNameEditor = null;
    private transient ExtendedItemHandle reportItemHandle = null;
    private transient IDataServiceProvider dataServiceProvider = null;

    public ExtendedItemFilterDialog(ExtendedItemHandle reportItemHandle, IDataServiceProvider dataServiceProvider) {
        super(Messages.getString((String)"dataset.editor.filters"));
        this.reportItemHandle = reportItemHandle;
        this.dataServiceProvider = dataServiceProvider;
    }

    protected Control createDialogArea(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.DataSetFilter_ID");
        ((GridData)parent.getLayoutData()).heightHint = 200;
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initColumnNames();
        this.viewer = new PropertyHandleTableViewer(composite, true, true, true);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(" ");
        column.setResizable(false);
        column.setWidth(19);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.expression"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.operator"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.value1"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.value2"));
        column.setWidth(100);
        this.initializeFilters();
        this.viewer.getViewer().setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList filterList = new ArrayList(10);
                Iterator iter = ExtendedItemFilterDialog.this.filters.iterator();
                if (iter != null) {
                    while (iter.hasNext()) {
                        filterList.add(iter.next());
                    }
                }
                if (ExtendedItemFilterDialog.this.newFilter == null) {
                    ExtendedItemFilterDialog.this.newFilter = new FilterCondition();
                }
                filterList.add(ExtendedItemFilterDialog.this.newFilter);
                return filterList.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)this);
        this.viewer.getViewer().setInput((Object)this.filters);
        this.setupEditors();
        this.addListeners();
        this.pageActivated();
        SessionHandleAdapter.getInstance().getCommandStack().startTrans("Modify Filters");
        return composite;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x860 | 0x10 | 0x10000);
    }

    private void setupEditors() {
        CellEditor[] editors = new CellEditor[5];
        if (this.columnExpressions == null) {
            this.columnExpressions = new String[0];
        }
        this.columnNameEditor = new ComboBoxExpressionCellEditor((Composite)this.viewer.getViewer().getTable(), this.columnExpressions, 0);
        ExpressionProvider expressionProvider = new ExpressionProvider((DesignElementHandle)this.reportItemHandle);
        this.columnNameEditor.setExpressionProvider((IExpressionProvider)expressionProvider);
        editors[1] = this.columnNameEditor;
        editors[2] = new ComboBoxCellEditor((Composite)this.viewer.getViewer().getTable(), operatorDisplayNames, 8);
        ExpressionValueCellEditor editor = new ExpressionValueCellEditor((Composite)this.viewer.getViewer().getTable());
        editor.setExpressionProvider((IExpressionProvider)expressionProvider);
        editor.setReportElement((ReportElementHandle)this.reportItemHandle);
        editors[3] = editor;
        editor = new ExpressionValueCellEditor((Composite)this.viewer.getViewer().getTable());
        editor.setExpressionProvider((IExpressionProvider)expressionProvider);
        editor.setReportElement((ReportElementHandle)this.reportItemHandle);
        editors[4] = editor;
        this.viewer.getViewer().setCellEditors(editors);
        this.viewer.getViewer().setColumnProperties(new String[]{"", "expr", "operator", "value1", "value2"});
        this.viewer.getViewer().setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                String operator = "";
                String expr = null;
                try {
                    operator = (String)Utility.getProperty((Object)element, (String)"operator");
                    expr = (String)Utility.getProperty((Object)element, (String)"expr");
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
                if (operator == null) {
                    operator = "";
                }
                if (element == ExtendedItemFilterDialog.this.newFilter && !property.equals("expr")) {
                    return false;
                }
                if (property.equals("value2") && !operator.equals("between") && !operator.equals("not-between")) {
                    return false;
                }
                if (property.equals("value1") && (operator.equals("is-null") || operator.equals("is-not-null") || operator.equals("is-true") || operator.equals("is-false"))) {
                    return false;
                }
                String bindingName = null;
                for (int i = 0; i < ExtendedItemFilterDialog.this.columnExpressions.length; ++i) {
                    if (!DEUtil.getColumnExpression((String)ExtendedItemFilterDialog.this.columnExpressions[i]).equals(expr)) continue;
                    bindingName = ExtendedItemFilterDialog.this.columnExpressions[i];
                    break;
                }
                ((ExpressionValueCellEditor)ExtendedItemFilterDialog.this.viewer.getViewer().getCellEditors()[3]).setBindingName(bindingName);
                ((ExpressionValueCellEditor)ExtendedItemFilterDialog.this.viewer.getViewer().getCellEditors()[4]).setBindingName(bindingName);
                return true;
            }

            public Object getValue(Object element, String property) {
                Object value = null;
                try {
                    value = Utility.getProperty((Object)element, (String)property);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                if ("operator".equals(property)) {
                    value = new Integer(ExtendedItemFilterDialog.this.getOperatorIndex((String)value));
                }
                if (value == null) {
                    value = "";
                }
                return value;
            }

            public void modify(Object element, String property, Object value) {
                Object actualElement = ((TableItem)element).getData();
                if (value != null) {
                    try {
                        if ("operator".equals(property)) {
                            Integer index = (Integer)value;
                            if (index > -1 && index < operators.length) {
                                value = operators[index];
                                if (value.equals("is-null") || value.equals("is-not-null") || value.equals("is-true") || value.equals("is-false")) {
                                    Utility.setProperty((Object)actualElement, (String)"value1", (Object)"");
                                    Utility.setProperty((Object)actualElement, (String)"value2", (Object)"");
                                    ExtendedItemFilterDialog.this.viewer.getViewer().refresh();
                                } else if (!value.equals("between") && !value.equals("not-between")) {
                                    Utility.setProperty((Object)actualElement, (String)"value2", (Object)"");
                                    ExtendedItemFilterDialog.this.viewer.getViewer().refresh();
                                }
                            } else {
                                value = "";
                            }
                        } else if ("expr".equals(property)) {
                            if (ExtendedItemFilterDialog.this.isColumnName((String)value)) {
                                value = "row[\"" + DEUtil.escape((String)((String)value)) + "\"]";
                            }
                            if (actualElement != ExtendedItemFilterDialog.this.newFilter && (value == null || ((String)value).trim().length() == 0)) {
                                ExceptionHandler.openMessageBox((String)Messages.getString((String)"filters.error.title"), (String)Messages.getString((String)"filters.empty.columnName"), (int)2);
                                ExtendedItemFilterDialog.this.viewer.getViewer().update(actualElement, null);
                                return;
                            }
                        }
                        Utility.setProperty((Object)actualElement, (String)property, (Object)value);
                    }
                    catch (InvocationTargetException ite) {
                        Exception e = new Exception(Messages.getString((String)"DataSetFiltersPage.exception.msg.operator.notSupport") + value);
                        ExceptionHandler.handle((Throwable)e);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        ExceptionHandler.handle((Throwable)ex);
                    }
                    ExtendedItemFilterDialog.this.viewer.getViewer().update(((TableItem)element).getData(), null);
                    if (actualElement instanceof FilterCondition) {
                        ExtendedItemFilterDialog.this.isOperatorSet = true;
                        if (ExtendedItemFilterDialog.this.newFilter.getExpr() != null && ExtendedItemFilterDialog.this.newFilter.getExpr().trim().length() > 0) {
                            try {
                                ExtendedItemFilterDialog.this.filters.addItem((IStructure)ExtendedItemFilterDialog.this.newFilter);
                                ExtendedItemFilterDialog.this.clearNewFilter();
                                ExtendedItemFilterDialog.this.viewer.getViewer().refresh();
                            }
                            catch (SemanticException e) {
                                ExceptionHandler.handle((Throwable)e);
                            }
                        }
                    }
                }
            }
        });
    }

    private void addListeners() {
        this.viewer.getViewer().getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    ExtendedItemFilterDialog.this.removeSelectedItem();
                }
                ExtendedItemFilterDialog.this.setPageProperties();
            }
        });
        this.viewer.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedItemFilterDialog.this.removeSelectedItem();
                ExtendedItemFilterDialog.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedItemFilterDialog.this.removeSelectedItem();
                ExtendedItemFilterDialog.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveAllMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedItemFilterDialog.this.removeAllItem();
                ExtendedItemFilterDialog.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void initColumnNames() {
        try {
            this.columnExpressions = this.dataServiceProvider.getPreviewHeader();
        }
        catch (ChartException e) {
            WizardBase.displayException((Throwable)e);
        }
    }

    private boolean isColumnName(String name) {
        for (int n = 0; n < this.columnExpressions.length; ++n) {
            if (!this.columnExpressions[n].equals(name)) continue;
            return true;
        }
        return false;
    }

    private void initializeFilters() {
        this.filters = this.reportItemHandle.getPropertyHandle("filter");
    }

    private int getOperatorIndex(String filter) {
        for (int n = 0; n < operators.length; ++n) {
            if (!operators[n].equals(filter)) continue;
            return n;
        }
        return -1;
    }

    private void pageActivated() {
        this.initColumnNames();
        if (this.columnExpressions != null) {
            this.columnNameEditor.setItems(this.columnExpressions);
        }
        this.setPageProperties();
    }

    private void setPageProperties() {
        boolean filterConditionExists = false;
        filterConditionExists = this.filters != null && this.filters.getListValue() != null && this.filters.getListValue().size() > 0;
        this.viewer.getDownButton().setEnabled(filterConditionExists);
        this.viewer.getUpButton().setEnabled(filterConditionExists);
        this.viewer.getRemoveButton().setEnabled(filterConditionExists);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String value = null;
        try {
            if (element != this.newFilter) {
                switch (columnIndex) {
                    case 1: {
                        value = (String)Utility.getProperty((Object)element, (String)"expr");
                        break;
                    }
                    case 2: {
                        if (element == this.newFilter && !this.isOperatorSet) break;
                        int index = this.getOperatorIndex((String)Utility.getProperty((Object)element, (String)"operator"));
                        if (index > -1) {
                            value = operatorDisplayNames[index];
                            break;
                        }
                        value = (String)Utility.getProperty((Object)element, (String)"operator");
                        break;
                    }
                    case 3: {
                        value = (String)Utility.getProperty((Object)element, (String)"value1");
                        break;
                    }
                    case 4: {
                        value = (String)Utility.getProperty((Object)element, (String)"value2");
                    }
                }
            } else if (columnIndex == 1) {
                value = Messages.getString((String)"filters.prompt.new");
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    private void clearNewFilter() {
        this.newFilter = null;
        this.isOperatorSet = false;
    }

    private void removeSelectedItem() {
        int count;
        int index = this.viewer.getViewer().getTable().getSelectionIndex();
        int n = count = this.filters.getListValue() == null ? 0 : this.filters.getListValue().size();
        if (index == count) {
            this.clearNewFilter();
            this.viewer.getViewer().refresh();
        }
    }

    private void removeAllItem() {
        this.clearNewFilter();
        this.viewer.getViewer().refresh();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    protected void okPressed() {
        SessionHandleAdapter.getInstance().getCommandStack().commit();
        super.okPressed();
    }

    protected void cancelPressed() {
        SessionHandleAdapter.getInstance().getCommandStack().rollback();
        super.cancelPressed();
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setPageProperties();
    }

    static {
        IChoiceSet chset = ChoiceSetFactory.getStructChoiceSet((String)"FilterCondition", (String)"operator");
        IChoice[] chs = chset.getChoices();
        operators = new String[chs.length];
        operatorDisplayNames = new String[chs.length];
        for (int i = 0; i < chs.length; ++i) {
            ExtendedItemFilterDialog.operators[i] = chs[i].getName();
            ExtendedItemFilterDialog.operatorDisplayNames[i] = chs[i].getDisplayName();
        }
    }
}

