/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import com.ibm.icu.util.ULocale;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.reportitem.BIRTExternalContext;
import org.eclipse.birt.chart.reportitem.BIRTScriptClassLoader;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.script.IExternalContext;
import org.eclipse.birt.chart.script.IScriptClassLoader;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.report.engine.extension.IRowSet;
import org.eclipse.birt.report.engine.extension.ReportItemGenerationBase;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;

public class ChartReportItemGenerationImpl
extends ReportItemGenerationBase {
    private Chart cm = null;
    private DesignElementHandle handle = null;
    private RunTimeContext rtc = null;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");

    public void setModelObject(ExtendedItemHandle eih) {
        super.setModelObject(this.modelHandle);
        IReportItem item = null;
        try {
            item = eih.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log((Exception)((Object)e));
        }
        if (item == null) {
            try {
                eih.loadExtendedElement();
                item = eih.getReportItem();
            }
            catch (ExtendedElementException eeex) {
                logger.log((Exception)((Object)eeex));
            }
            if (item == null) {
                logger.log(4, Messages.getString("ChartReportItemPresentationImpl.log.UnableToLocateWrapper"));
                return;
            }
        }
        this.handle = eih;
        this.cm = (Chart)((ChartReportItemImpl)item).getProperty("chart.instance");
    }

    public void serialize(OutputStream ostream) throws BirtException {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(ostream);
            oos.writeObject(this.rtc);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            logger.log(e);
        }
    }

    public boolean needSerialization() {
        return true;
    }

    public void onRowSets(IRowSet[] rowSets) throws BirtException {
        String javaHandlerClass = this.handle.getEventHandlerClass();
        if (javaHandlerClass != null && javaHandlerClass.length() > 0) {
            this.cm.setScript(javaHandlerClass);
        }
        this.rtc = Generator.instance().prepare(this.cm, (IExternalContext)new BIRTExternalContext(this.context), (IScriptClassLoader)new BIRTScriptClassLoader(), ULocale.getDefault());
        if (rowSets == null || rowSets.length != 1 || rowSets[0] == null || this.queries == null || this.queries[0] == null) {
            return;
        }
        IRowSet rowSet = rowSets[0];
        Map expressions = this.queries[0].getResultSetExpressions();
        while (rowSet.next()) {
            Iterator iter = expressions.keySet().iterator();
            while (iter.hasNext()) {
                String colName = (String)iter.next();
                String expr = ExpressionUtil.createRowExpression((String)JavascriptEvalUtil.transformToJsConstants((String)colName));
                rowSet.evaluate(expr);
            }
        }
    }
}

