/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.impl.SerializerImpl;
import org.eclipse.birt.chart.reportitem.BIRTActionEvaluator;
import org.eclipse.birt.chart.reportitem.ChartChoiceDefinitionImpl;
import org.eclipse.birt.chart.reportitem.ChartElementCommandImpl;
import org.eclipse.birt.chart.reportitem.ChartPropertyDefinitionImpl;
import org.eclipse.birt.chart.reportitem.ChartSimplePropertyCommandImpl;
import org.eclipse.birt.chart.reportitem.CompatibleExpressionUpdater;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.ICompatibleReportItem;
import org.eclipse.birt.report.model.api.extension.IElementCommand;
import org.eclipse.birt.report.model.api.extension.IPropertyDefinition;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.extension.ReportItem;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;

public final class ChartReportItemImpl
extends ReportItem
implements ICompatibleReportItem {
    private Chart cm = null;
    private Object oDesignerRepresentation = null;
    private static final List liLegendPositions;
    private static final List liLegendAnchors;
    private static final List liChartDimensions;
    private transient DesignElementHandle handle = null;
    private static ILogger logger;

    public ChartReportItemImpl(DesignElementHandle handle) {
        this.handle = handle;
    }

    public void setModel(Chart chart) {
        this.cm = chart;
    }

    public DesignElementHandle getHandle() {
        return this.handle;
    }

    public void setHandle(DesignElementHandle handle) {
        this.handle = handle;
    }

    public void executeSetSimplePropertyCommand(DesignElementHandle eih, String propName, Object oldValue, Object newValue) {
        if (this.handle == null) {
            return;
        }
        ChartSimplePropertyCommandImpl command = new ChartSimplePropertyCommandImpl(eih, this, propName, newValue, oldValue);
        this.handle.getModuleHandle().getCommandStack().execute((IElementCommand)command);
    }

    public void executeSetModelCommand(ExtendedItemHandle eih, Chart oldChart, Chart newChart) {
        if (this.handle == null) {
            return;
        }
        ChartElementCommandImpl command = new ChartElementCommandImpl(eih, this, oldChart, newChart);
        this.handle.getModuleHandle().getCommandStack().execute((IElementCommand)command);
    }

    public final void setDesignerRepresentation(Object oDesignerRepresentation) {
        this.oDesignerRepresentation = oDesignerRepresentation;
    }

    public final Object getDesignerRepresentation() {
        return this.oDesignerRepresentation;
    }

    public ByteArrayOutputStream serialize(String propName) {
        if (propName != null && propName.equalsIgnoreCase("xmlRepresentation")) {
            try {
                return SerializerImpl.instance().asXml(this.cm, true);
            }
            catch (Exception e) {
                logger.log(e);
                return new ByteArrayOutputStream();
            }
        }
        return null;
    }

    public void deserialize(String propName, ByteArrayInputStream data) throws ExtendedElementException {
        if (propName != null && propName.equalsIgnoreCase("xmlRepresentation")) {
            try {
                this.cm = SerializerImpl.instance().fromXml(data, true);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.cm = null;
            }
        }
    }

    public IPropertyDefinition getScriptPropertyDefinition() {
        if (this.cm == null) {
            logger.log(2, Messages.getString("ChartReportItemImpl.log.RequestForScriptPropertyDefn"));
            return null;
        }
        return new ChartPropertyDefinitionImpl(null, "script", "property.script", false, 0, null, null, null);
    }

    public IPropertyDefinition[] getPropertyDefinitions() {
        if (this.cm == null) {
            logger.log(2, Messages.getString("ChartReportItemImpl.log.RequestForPropertyDefn"));
            return null;
        }
        return new IPropertyDefinition[]{new ChartPropertyDefinitionImpl(null, "title.value", "property.label.title.value", false, 0, null, null, null), new ChartPropertyDefinitionImpl(null, "title.font.rotation", "property.label.title.font.rotation", false, 14, null, null, null), new ChartPropertyDefinitionImpl(null, "legend.position", "property.label.legend.position", false, 5, liLegendPositions, null, null), new ChartPropertyDefinitionImpl(null, "legend.anchor", "property.label.legend.anchor", false, 5, liLegendAnchors, null, null), new ChartPropertyDefinitionImpl(null, "chart.dimension", "property.label.chart.dimension", false, 5, liChartDimensions, null, null), new ChartPropertyDefinitionImpl(null, "plot.transposed", "property.label.chart.plot.transposed", false, 6, null, null, null), new ChartPropertyDefinitionImpl(null, "script", "property.script", false, 0, null, null, null)};
    }

    public final Object getProperty(String propName) {
        logger.log(1, Messages.getString("ChartReportItemImpl.log.getProperty", propName));
        if (propName.equals("title.value")) {
            return this.cm.getTitle().getLabel().getCaption().getValue();
        }
        if (propName.equals("title.font.rotation")) {
            return new Double(this.cm.getTitle().getLabel().getCaption().getFont().getRotation());
        }
        if (propName.equals("legend.position")) {
            return this.cm.getLegend().getPosition().getName();
        }
        if (propName.equals("legend.anchor")) {
            return this.cm.getLegend().getAnchor().getName();
        }
        if (propName.equals("chart.dimension")) {
            return this.cm.getDimension().getName();
        }
        if (propName.equals("plot.transposed")) {
            return new Boolean(this.cm instanceof ChartWithAxes ? ((ChartWithAxes)this.cm).isTransposed() : false);
        }
        if (propName.equals("script")) {
            String script = this.cm.getScript();
            if (script == null || script.length() == 0) {
                script = "/**\n * The chart script methods provide control on the chart databinding, generation and rendering.\n *\n * The methods have been commented in the following code, please uncomment and implement the\n * ones you need. Note that for simplicity the \"after\" methods have not be included here.\n *\n * This script syntax follows JavaScript specifications, the Java classes that are referred to\n * in the comments can be accessed as JavaScript classes. \n *\n * Script examples are available in the org.eclipse.birt.chart.examples plugin\n */\n\n\n/**\n * Called before populating the series dataset using the DataSetProcessor.\n * \n * @param series\n *            Series\n * @param dataSetProcessor\n *            DataSetProcessor\n * @param context\n *            IChartScriptContext\n */\n//function beforeDataSetFilled( series, dataSetProcessor, context ){}\n\n/**\n * Called before generation of chart model to GeneratedChartState.\n * \n * @param chart\n *            Chart Model\n * @param context\n *            IChartScriptContext\n */\n//function beforeGeneration( chart, context ){}\n\n/**\n * Called before the chart is rendered.\n * \n * @param gcs\n *            GeneratedChartState\n * @param context\n *            IChartScriptContext\n */\n//function beforeRendering( gcs, context ){}\n\n/**\n * Called before drawing each block.\n * \n * @param block\n *            Block\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawBlock( block, context ){}\n\n/**\n * Called before drawing each entry the legend.\n * \n * @param label\n *            Label\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawLegendEntry( label, context ){}\n\n/**\n * Called before rendering Series.\n * \n * @param series\n *            Series\n * @param seriesRenderer\n *            ISeriesRenderer\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawSeries( series, seriesRenderer, context ){}\n\n/**\n * Called before rendering the title of a Series.\n * \n * @param series\n *            Series\n * @param label\n *            Label\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawSeriesTitle( series, label, context ){}\n\n/**\n * Called before drawing each marker line in an Axis.\n * \n * @param axis\n *            Axis\n * @param markerLine\n *            MarkerLine\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawMarkerLine( axis, markerLine, context ){}\n\n/**\n * Called before drawing each marker range in an Axis.\n * \n * @param axis\n *            Axis\n * @param markerRange\n *            MarkerRange\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawMarkerRange( axis, markerRange, context ){}\n\n/**\n * Called before drawing each datapoint graphical representation or marker.\n * \n * @param dph\n *            DataPointHints\n * @param fill\n *            Fill\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawDataPoint( dph, fill, context ){}\n\n/**\n * Called before rendering the label for each datapoint.\n * \n * @param dph\n *            DataPointHints\n * @param label\n *            Label\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawDataPointLabel( dph, label, context ){}\n\n/**\n * Called before rendering curve fitting.\n * \n * @param cf\n *            CurveFitting\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawFittingCurve( cf, context ){}\n\n/**\n * Called before rendering each label on a given Axis.\n * \n * @param axis\n *            Axis\n * @param label\n *            Label\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawAxisLabel( axis, label, context ){}\n\n/**\n * Called before rendering the Title of an Axis.\n * \n * @param axis\n *            Axis\n * @param label\n *            Title Label\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawAxisTitle( axis, label, context ){}\n";
            }
            return script;
        }
        if (propName.equals("chart.instance")) {
            return this.cm;
        }
        return null;
    }

    public void checkProperty(String propName, Object value) throws ExtendedElementException {
        logger.log(1, Messages.getString("ChartReportItemImpl.log.checkProperty", new Object[]{propName, value}));
    }

    public void setProperty(String propName, Object value) {
        logger.log(1, Messages.getString("ChartReportItemImpl.log.setProperty", new Object[]{propName, value}));
        this.executeSetSimplePropertyCommand(this.handle, propName, this.getProperty(propName), value);
    }

    void basicSetProperty(String propName, Object value) {
        if (propName.equals("title.value")) {
            this.cm.getTitle().getLabel().getCaption().setValue((String)value);
        } else if (propName.equals("title.font.rotation")) {
            this.cm.getTitle().getLabel().getCaption().getFont().setRotation(((Double)value).doubleValue());
        } else if (propName.equals("legend.position")) {
            this.cm.getLegend().setPosition(Position.get((String)((String)value)));
        } else if (propName.equals("legend.anchor")) {
            this.cm.getLegend().setAnchor(Anchor.get((String)((String)value)));
        } else if (propName.equals("chart.dimension")) {
            this.cm.setDimension(ChartDimension.get((String)((String)value)));
        } else if (propName.equals("plot.transposed")) {
            if (this.cm instanceof ChartWithAxes) {
                ((ChartWithAxes)this.cm).setTransposed(((Boolean)value).booleanValue());
            } else {
                logger.log(4, Messages.getString("ChartReportItemImpl.log.CannotSetState"));
            }
        } else if (propName.equals("script")) {
            if ("/**\n * The chart script methods provide control on the chart databinding, generation and rendering.\n *\n * The methods have been commented in the following code, please uncomment and implement the\n * ones you need. Note that for simplicity the \"after\" methods have not be included here.\n *\n * This script syntax follows JavaScript specifications, the Java classes that are referred to\n * in the comments can be accessed as JavaScript classes. \n *\n * Script examples are available in the org.eclipse.birt.chart.examples plugin\n */\n\n\n/**\n * Called before populating the series dataset using the DataSetProcessor.\n * \n * @param series\n *            Series\n * @param dataSetProcessor\n *            DataSetProcessor\n * @param context\n *            IChartScriptContext\n */\n//function beforeDataSetFilled( series, dataSetProcessor, context ){}\n\n/**\n * Called before generation of chart model to GeneratedChartState.\n * \n * @param chart\n *            Chart Model\n * @param context\n *            IChartScriptContext\n */\n//function beforeGeneration( chart, context ){}\n\n/**\n * Called before the chart is rendered.\n * \n * @param gcs\n *            GeneratedChartState\n * @param context\n *            IChartScriptContext\n */\n//function beforeRendering( gcs, context ){}\n\n/**\n * Called before drawing each block.\n * \n * @param block\n *            Block\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawBlock( block, context ){}\n\n/**\n * Called before drawing each entry the legend.\n * \n * @param label\n *            Label\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawLegendEntry( label, context ){}\n\n/**\n * Called before rendering Series.\n * \n * @param series\n *            Series\n * @param seriesRenderer\n *            ISeriesRenderer\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawSeries( series, seriesRenderer, context ){}\n\n/**\n * Called before rendering the title of a Series.\n * \n * @param series\n *            Series\n * @param label\n *            Label\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawSeriesTitle( series, label, context ){}\n\n/**\n * Called before drawing each marker line in an Axis.\n * \n * @param axis\n *            Axis\n * @param markerLine\n *            MarkerLine\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawMarkerLine( axis, markerLine, context ){}\n\n/**\n * Called before drawing each marker range in an Axis.\n * \n * @param axis\n *            Axis\n * @param markerRange\n *            MarkerRange\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawMarkerRange( axis, markerRange, context ){}\n\n/**\n * Called before drawing each datapoint graphical representation or marker.\n * \n * @param dph\n *            DataPointHints\n * @param fill\n *            Fill\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawDataPoint( dph, fill, context ){}\n\n/**\n * Called before rendering the label for each datapoint.\n * \n * @param dph\n *            DataPointHints\n * @param label\n *            Label\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawDataPointLabel( dph, label, context ){}\n\n/**\n * Called before rendering curve fitting.\n * \n * @param cf\n *            CurveFitting\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawFittingCurve( cf, context ){}\n\n/**\n * Called before rendering each label on a given Axis.\n * \n * @param axis\n *            Axis\n * @param label\n *            Label\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawAxisLabel( axis, label, context ){}\n\n/**\n * Called before rendering the Title of an Axis.\n * \n * @param axis\n *            Axis\n * @param label\n *            Title Label\n * @param context\n *            IChartScriptContext\n */\n//function beforeDrawAxisTitle( axis, label, context ){}\n".equals(value)) {
                this.cm.setScript(null);
            } else {
                this.cm.setScript((String)value);
            }
        } else if (propName.equals("chart.instance")) {
            this.cm = (Chart)value;
        }
    }

    protected void checkScriptSyntax(String string) throws RhinoException {
        if (string == null) {
            return;
        }
        if (!this.isJavaClassName(string)) {
            Context cx = Context.enter();
            cx.compileString(string, "chartScript", 1, null);
        }
    }

    protected boolean isJavaClassName(String string) {
        return string.matches("\\w+(\\.\\w*)*");
    }

    public List validate() {
        logger.log(1, Messages.getString("ChartReportItemImpl.log.validate"));
        ArrayList<ExtendedElementException> list = new ArrayList<ExtendedElementException>();
        if (this.cm != null) {
            try {
                this.checkScriptSyntax(this.cm.getScript());
            }
            catch (RhinoException e) {
                logger.log((Exception)((Object)e));
                ExtendedElementException extendedException = new ExtendedElementException(this.getHandle().getElement(), "org.eclipse.birt.chart.reportitem", "exception.script.syntaxError", new Object[]{e.getLocalizedMessage()}, Messages.getResourceBundle());
                extendedException.setProperty("lineNo", (Object)String.valueOf(e.lineNumber()));
                extendedException.setProperty("sub_editor", (Object)"script");
                list.add(extendedException);
            }
        }
        return list;
    }

    public final IReportItem copy() {
        ChartReportItemImpl crii = new ChartReportItemImpl(this.handle);
        crii.cm = this.cm == null ? null : (Chart)EcoreUtil.copy((EObject)this.cm);
        return crii;
    }

    public boolean refreshPropertyDefinition() {
        return false;
    }

    public List getRowExpressions() {
        try {
            return Generator.instance().getRowExpressions(this.cm, (IActionEvaluator)new BIRTActionEvaluator());
        }
        catch (ChartException e) {
            logger.log((Exception)((Object)e));
            return null;
        }
    }

    public void updateRowExpressions(Map newExpressions) {
        CompatibleExpressionUpdater.update(this.cm, newExpressions);
    }

    static {
        ChartChoiceDefinitionImpl icd;
        String sLowercaseName;
        String sName;
        liLegendPositions = new LinkedList();
        liLegendAnchors = new LinkedList();
        liChartDimensions = new LinkedList();
        logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
        List li = Position.VALUES;
        Iterator it = li.iterator();
        while (it.hasNext()) {
            sName = ((Position)it.next()).getName();
            sLowercaseName = sName.toLowerCase(Locale.US);
            if (sLowercaseName.equals("outside")) continue;
            icd = new ChartChoiceDefinitionImpl("choice.legend.position." + sLowercaseName, sName, null);
            liLegendPositions.add(icd);
        }
        li = Anchor.VALUES;
        it = li.iterator();
        while (it.hasNext()) {
            sName = ((Anchor)it.next()).getName();
            sLowercaseName = sName.toLowerCase(Locale.US);
            icd = new ChartChoiceDefinitionImpl("choice.legend.anchor." + sLowercaseName, sName, null);
            liLegendAnchors.add(icd);
        }
        li = ChartDimension.VALUES;
        it = li.iterator();
        while (it.hasNext()) {
            sName = ((ChartDimension)it.next()).getName();
            sLowercaseName = sName.toLowerCase(Locale.US);
            icd = new ChartChoiceDefinitionImpl("choice.chart.dimension." + sLowercaseName, sName, null);
            liChartDimensions.add(icd);
        }
    }
}

