/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.chart.device.DeviceAdapter;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.device.swing.ShapedAction;
import org.eclipse.birt.chart.device.swing.SwingDisplayServer;
import org.eclipse.birt.chart.device.swing.SwingEventHandler;
import org.eclipse.birt.chart.device.swing.SwingTextRenderer;
import org.eclipse.birt.chart.event.ArcRenderEvent;
import org.eclipse.birt.chart.event.AreaRenderEvent;
import org.eclipse.birt.chart.event.ClipRenderEvent;
import org.eclipse.birt.chart.event.ImageRenderEvent;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.TransformationEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.EmbeddedImage;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.util.PluginSettings;

public class SwingRendererImpl
extends DeviceAdapter {
    private final Map _lhmAllTriggers = new HashMap();
    private final List _allShapes = new LinkedList();
    private final Map _htLineStyles = new HashMap();
    protected Graphics2D _g2d;
    protected IDisplayServer _ids;
    private IUpdateNotifier _iun = null;
    private SwingEventHandler _eh = null;
    private static ILogger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SwingRendererImpl() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this._ids = ps.getDisplayServer("ds.SWING");
        }
        catch (ChartException pex) {
            logger.log((Exception)((Object)pex));
        }
    }

    public void dispose() {
        Object obj;
        this._lhmAllTriggers.clear();
        if (this._iun != null && (obj = this._iun.peerInstance()) instanceof JComponent) {
            JComponent jc = (JComponent)obj;
            if (this._eh != null) {
                jc.removeMouseListener(this._eh);
                jc.removeMouseMotionListener(this._eh);
                jc.removeKeyListener(this._eh);
                this._eh = null;
            }
        }
    }

    public void setProperty(String sProperty, Object oValue) {
        if (sProperty.equals("device.component")) {
            this._iun = (IUpdateNotifier)oValue;
            this._lhmAllTriggers.clear();
            Object obj = this._iun.peerInstance();
            if (obj instanceof JComponent) {
                JComponent jc = (JComponent)obj;
                MouseListener[] mla = jc.getMouseListeners();
                for (int i = 0; i < mla.length; ++i) {
                    if (!(mla[i] instanceof SwingEventHandler)) continue;
                    jc.removeMouseListener(mla[i]);
                }
                MouseMotionListener[] mmla = jc.getMouseMotionListeners();
                for (int i = 0; i < mmla.length; ++i) {
                    if (!(mmla[i] instanceof SwingEventHandler)) continue;
                    jc.removeMouseMotionListener(mmla[i]);
                }
                KeyListener[] kla = jc.getKeyListeners();
                for (int i = 0; i < kla.length; ++i) {
                    if (!(kla[i] instanceof SwingEventHandler)) continue;
                    jc.removeKeyListener(kla[i]);
                }
                this._eh = new SwingEventHandler(this._lhmAllTriggers, this._iun, this.getULocale());
                jc.addMouseListener(this._eh);
                jc.addMouseMotionListener(this._eh);
                jc.addKeyListener(this._eh);
            }
        } else if (sProperty.equals("device.output.context")) {
            this._g2d = (Graphics2D)oValue;
            this._g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this._g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this._g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            this._g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            logger.log(1, Messages.getString("SwingRendererImpl.info.using.graphics.context", new Object[]{this._g2d}, this.getULocale()));
        } else if (sProperty.equals("device.resolution")) {
            this.getDisplayServer().setDpiResolution(((Integer)oValue).intValue());
        }
    }

    public final Object getGraphicsContext() {
        return this._g2d;
    }

    public void setClip(ClipRenderEvent pre) {
        Location[] loa = pre.getVertices();
        if (loa == null) {
            this._g2d.setClip(null);
        } else {
            int[][] i2a = SwingRendererImpl.getCoordinatesAsInts(loa);
            this._g2d.setClip(new Polygon(i2a[0], i2a[1], loa.length));
        }
    }

    public void drawImage(ImageRenderEvent pre) throws ChartException {
        if (pre.getImage() == null || pre.getLocation() == null) {
            return;
        }
        java.awt.Image img = null;
        if (pre.getImage() instanceof EmbeddedImage) {
            try {
                byte[] data = Base64.decodeBase64((byte[])((EmbeddedImage)pre.getImage()).getData().getBytes());
                img = this.createImage(data);
            }
            catch (Exception ilex) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)ilex);
            }
        }
        try {
            String sUrl = pre.getImage().getURL();
            img = (java.awt.Image)this._ids.loadImage(new URL(sUrl));
        }
        catch (ChartException ilex) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)ilex);
        }
        catch (MalformedURLException muex) {
            throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)muex);
        }
        if (img == null) {
            return;
        }
        Location loc = pre.getLocation();
        Position pos = pre.getPosition();
        if (pos == null) {
            pos = Position.INSIDE_LITERAL;
        }
        ImageObserver io = (ImageObserver)this._ids.getObserver();
        int width = img.getWidth(io);
        int height = img.getHeight(io);
        int x = (int)loc.getX();
        int y = (int)loc.getY();
        switch (pos.getValue()) {
            case 4: 
            case 5: {
                x -= width / 2;
                y -= height / 2;
                break;
            }
            case 2: {
                x -= width;
                y -= height / 2;
                break;
            }
            case 3: {
                y -= height / 2;
                break;
            }
            case 0: {
                x -= width / 2;
                y -= height;
                break;
            }
            case 1: {
                x -= width / 2;
            }
        }
        this._g2d.drawImage(img, x, y, width, height, io);
    }

    public void drawLine(LineRenderEvent lre) throws ChartException {
        LineAttributes lia = lre.getLineAttributes();
        if (!this.validateLineAttributes(lre.getSource(), lia) || lia.getColor() == null) {
            return;
        }
        if (lia.getColor().isSetTransparency() && lia.getColor().getTransparency() == 0) {
            return;
        }
        Location loStart = lre.getStart();
        Location loEnd = lre.getEnd();
        Stroke sPrevious = null;
        Stroke sCurrent = this.getCachedStroke(lia);
        if (sCurrent != null) {
            sPrevious = this._g2d.getStroke();
            this._g2d.setStroke(sCurrent);
        }
        this._g2d.setColor((Color)this._ids.getColor(lia.getColor()));
        this._g2d.draw(new Line2D.Double(loStart.getX(), loStart.getY(), loEnd.getX(), loEnd.getY()));
        if (sPrevious != null) {
            this._g2d.setStroke(sPrevious);
        }
    }

    public void drawRectangle(RectangleRenderEvent rre) throws ChartException {
        LineAttributes lia = rre.getOutline();
        if (!this.validateLineAttributes(rre.getSource(), lia)) {
            return;
        }
        Color cFG = (Color)this.validateEdgeColor(lia.getColor(), rre.getBackground(), this._ids);
        if (cFG == null || cFG.getAlpha() == 0) {
            return;
        }
        Bounds bo = SwingRendererImpl.normalizeBounds(rre.getBounds());
        Stroke sPrevious = null;
        Stroke sCurrent = this.getCachedStroke(lia);
        if (sCurrent != null) {
            sPrevious = this._g2d.getStroke();
            this._g2d.setStroke(sCurrent);
        }
        this._g2d.setColor(cFG);
        this._g2d.draw(new Rectangle2D.Double(bo.getLeft(), bo.getTop(), bo.getWidth() - 1.0, bo.getHeight() - 1.0));
        if (sPrevious != null) {
            this._g2d.setStroke(sPrevious);
        }
    }

    public void fillRectangle(RectangleRenderEvent rre) throws ChartException {
        Fill flBackground = rre.getBackground();
        if (this.isFullTransparent(flBackground)) {
            return;
        }
        Bounds bo = SwingRendererImpl.normalizeBounds(rre.getBounds());
        Rectangle2D.Double r2d = new Rectangle2D.Double(bo.getLeft(), bo.getTop(), bo.getWidth(), bo.getHeight());
        if (flBackground instanceof ColorDefinition) {
            ColorDefinition cd = (ColorDefinition)flBackground;
            this._g2d.setColor((Color)this._ids.getColor(cd));
            this._g2d.fill(r2d);
        } else if (flBackground instanceof Gradient) {
            Point2D.Double p2dEnd;
            Point2D.Double p2dStart;
            Gradient g = (Gradient)flBackground;
            ColorDefinition cdStart = g.getStartColor();
            ColorDefinition cdEnd = g.getEndColor();
            double dAngleInDegrees = g.getDirection();
            double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
            if (dAngleInDegrees < -90.0 || dAngleInDegrees > 90.0) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingRendererImpl.exception.gradient.angle", new Object[]{new Double(dAngleInDegrees)}, Messages.getResourceBundle(this.getULocale()));
            }
            if (dAngleInDegrees == 90.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dEnd = new Point2D.Double(bo.getLeft(), bo.getTop());
            } else if (dAngleInDegrees == -90.0) {
                p2dEnd = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
            } else if (dAngleInDegrees > 0.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getHeight() - bo.getWidth() * Math.abs(Math.tan(dAngleInRadians)));
            } else if (dAngleInDegrees < 0.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getWidth() * Math.abs(Math.tan(dAngleInRadians)));
            } else {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop());
            }
            this._g2d.setPaint(new GradientPaint(p2dStart, (Color)this._ids.getColor(cdStart), p2dEnd, (Color)this._ids.getColor(cdEnd)));
            this._g2d.fill(r2d);
        } else if (flBackground instanceof Image) {
            java.awt.Image img = null;
            if (flBackground instanceof EmbeddedImage) {
                try {
                    byte[] data = Base64.decodeBase64((byte[])((EmbeddedImage)flBackground).getData().getBytes());
                    img = this.createImage(data);
                }
                catch (Exception ilex) {
                    throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)ilex);
                }
            }
            try {
                String sUrl = ((Image)flBackground).getURL();
                img = (java.awt.Image)this._ids.loadImage(new URL(sUrl));
            }
            catch (ChartException ilex) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)ilex);
            }
            catch (MalformedURLException muex) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)muex);
            }
            Shape shClip = this._g2d.getClip();
            Area ar2 = new Area(r2d);
            if (shClip != null) {
                Area ar1 = new Area(shClip);
                ar2.intersect(ar1);
            }
            this._g2d.setClip(ar2);
            Size szImage = this._ids.getSize((Object)img);
            int iXRepeat = (int)Math.ceil(r2d.width / szImage.getWidth());
            int iYRepeat = (int)Math.ceil(r2d.height / szImage.getHeight());
            ImageObserver io = (ImageObserver)this._ids.getObserver();
            for (int i = 0; i < iXRepeat; ++i) {
                for (int j = 0; j < iYRepeat; ++j) {
                    this._g2d.drawImage(img, (int)(r2d.x + (double)i * szImage.getWidth()), (int)(r2d.y + (double)j * szImage.getHeight()), io);
                }
            }
            this._g2d.setClip(shClip);
        }
    }

    protected static final int[][] getCoordinatesAsInts(Location[] la) {
        int n = la.length;
        int[] iaX = new int[n];
        int[] iaY = new int[n];
        for (int i = 0; i < n; ++i) {
            iaX[i] = (int)la[i].getX();
            iaY[i] = (int)la[i].getY();
        }
        return new int[][]{iaX, iaY};
    }

    protected static final Bounds normalizeBounds(Bounds bo) {
        if (bo.getHeight() < 0.0) {
            bo.setTop(bo.getTop() + bo.getHeight());
            bo.setHeight(-bo.getHeight());
        }
        if (bo.getWidth() < 0.0) {
            bo.setLeft(bo.getLeft() + bo.getWidth());
            bo.setWidth(-bo.getWidth());
        }
        return bo;
    }

    public void drawPolygon(PolygonRenderEvent pre) throws ChartException {
        LineAttributes lia = pre.getOutline();
        if (!this.validateLineAttributes(pre.getSource(), lia)) {
            return;
        }
        Color cFG = (Color)this.validateEdgeColor(lia.getColor(), pre.getBackground(), this._ids);
        if (cFG == null || cFG.getAlpha() == 0) {
            return;
        }
        Location[] la = pre.getPoints();
        int[][] i2a = SwingRendererImpl.getCoordinatesAsInts(la);
        Stroke sPrevious = null;
        Stroke sCurrent = this.getCachedStroke(lia);
        if (sCurrent != null) {
            sPrevious = this._g2d.getStroke();
            this._g2d.setStroke(sCurrent);
        }
        this._g2d.setColor(cFG);
        this._g2d.draw(new Polygon(i2a[0], i2a[1], la.length));
        if (sPrevious != null) {
            this._g2d.setStroke(sPrevious);
        }
    }

    public void fillPolygon(PolygonRenderEvent pre) throws ChartException {
        Fill flBackground = pre.getBackground();
        if (this.isFullTransparent(flBackground)) {
            return;
        }
        Location[] loa = pre.getPoints();
        int[][] i2a = SwingRendererImpl.getCoordinatesAsInts(loa);
        if (flBackground instanceof ColorDefinition) {
            ColorDefinition cd = (ColorDefinition)flBackground;
            this._g2d.setColor((Color)this._ids.getColor(cd));
            this._g2d.fill(new Polygon(i2a[0], i2a[1], loa.length));
        } else if (flBackground instanceof Gradient) {
            Point2D.Double p2dEnd;
            Point2D.Double p2dStart;
            Gradient g = (Gradient)flBackground;
            ColorDefinition cdStart = g.getStartColor();
            ColorDefinition cdEnd = g.getEndColor();
            double dAngleInDegrees = g.getDirection();
            double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
            double dMinX = BaseRenderer.getX((Location[])loa, (int)2);
            double dMaxX = BaseRenderer.getX((Location[])loa, (int)1);
            double dMinY = BaseRenderer.getY((Location[])loa, (int)2);
            double dMaxY = BaseRenderer.getY((Location[])loa, (int)1);
            if (dAngleInDegrees < -90.0 || dAngleInDegrees > 90.0) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingRendererImpl.exception.gradient.angle", new Object[]{new Double(dAngleInDegrees)}, Messages.getResourceBundle(this.getULocale()));
            }
            if (dAngleInDegrees == 90.0) {
                p2dStart = new Point2D.Double(dMinX, dMaxY);
                p2dEnd = new Point2D.Double(dMinX, dMinY);
            } else if (dAngleInDegrees == -90.0) {
                p2dStart = new Point2D.Double(dMinX, dMinY);
                p2dEnd = new Point2D.Double(dMinX, dMaxY);
            } else if (dAngleInDegrees > 0.0) {
                p2dStart = new Point2D.Double(dMinX, dMaxY);
                p2dEnd = new Point2D.Double(dMaxX, dMaxY - (dMaxX - dMinX) * Math.abs(Math.tan(dAngleInRadians)));
            } else if (dAngleInDegrees < 0.0) {
                p2dStart = new Point2D.Double(dMinX, dMinY);
                p2dEnd = new Point2D.Double(dMaxX, dMinY + (dMaxX - dMinX) * Math.abs(Math.tan(dAngleInRadians)));
            } else {
                p2dStart = new Point2D.Double(dMinX, dMinY);
                p2dEnd = new Point2D.Double(dMaxX, dMinY);
            }
            this._g2d.setPaint(new GradientPaint(p2dStart, (Color)this._ids.getColor(cdStart), p2dEnd, (Color)this._ids.getColor(cdEnd)));
            this._g2d.fill(new Polygon(i2a[0], i2a[1], loa.length));
        } else if (flBackground instanceof Image) {
            java.awt.Image img = null;
            if (flBackground instanceof EmbeddedImage) {
                try {
                    byte[] data = Base64.decodeBase64((byte[])((EmbeddedImage)flBackground).getData().getBytes());
                    img = this.createImage(data);
                }
                catch (Exception ilex) {
                    throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)ilex);
                }
            }
            try {
                String sUrl = ((Image)flBackground).getURL();
                img = (java.awt.Image)this._ids.loadImage(new URL(sUrl));
            }
            catch (ChartException ilex) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)ilex);
            }
            catch (MalformedURLException muex) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)muex);
            }
            Shape shClip = this._g2d.getClip();
            Area ar2 = new Area(new Polygon(i2a[0], i2a[1], loa.length));
            if (shClip != null) {
                Area ar1 = new Area(shClip);
                ar2.intersect(ar1);
            }
            this._g2d.setClip(ar2);
            double dMinX = BaseRenderer.getX((Location[])loa, (int)2);
            double dMaxX = BaseRenderer.getX((Location[])loa, (int)1);
            double dMinY = BaseRenderer.getY((Location[])loa, (int)2);
            double dMaxY = BaseRenderer.getY((Location[])loa, (int)1);
            Size szImage = this._ids.getSize((Object)img);
            int iXRepeat = (int)Math.ceil((dMaxX - dMinX) / szImage.getWidth());
            int iYRepeat = (int)Math.ceil((dMaxY - dMinY) / szImage.getHeight());
            ImageObserver io = (ImageObserver)this._ids.getObserver();
            for (int i = 0; i < iXRepeat; ++i) {
                for (int j = 0; j < iYRepeat; ++j) {
                    this._g2d.drawImage(img, (int)(dMinX + (double)i * szImage.getWidth()), (int)(dMinY + (double)j * szImage.getHeight()), io);
                }
            }
            this._g2d.setClip(shClip);
        }
    }

    public void drawArc(ArcRenderEvent are) throws ChartException {
        LineAttributes lia = are.getOutline();
        if (!this.validateLineAttributes(are.getSource(), lia)) {
            return;
        }
        Color cFG = (Color)this.validateEdgeColor(lia.getColor(), are.getBackground(), this._ids);
        if (cFG == null || cFG.getAlpha() == 0) {
            return;
        }
        Stroke sPrevious = null;
        Stroke sCurrent = this.getCachedStroke(lia);
        if (sCurrent != null) {
            sPrevious = this._g2d.getStroke();
            this._g2d.setStroke(sCurrent);
        }
        this._g2d.setColor(cFG);
        if (are.getInnerRadius() >= 0.0 && are.getOuterRadius() > 0.0 && are.getInnerRadius() < are.getOuterRadius()) {
            Arc2D.Double outerArc = new Arc2D.Double(are.getTopLeft().getX() + (are.getWidth() - 2.0 * are.getOuterRadius()) / 2.0, are.getTopLeft().getY() + (are.getHeight() - 2.0 * are.getOuterRadius()) / 2.0, 2.0 * are.getOuterRadius(), 2.0 * are.getOuterRadius(), are.getStartAngle(), are.getAngleExtent(), 2);
            Arc2D.Double innerArc = new Arc2D.Double(are.getTopLeft().getX() + (are.getWidth() - 2.0 * are.getInnerRadius()) / 2.0, are.getTopLeft().getY() + (are.getHeight() - 2.0 * are.getInnerRadius()) / 2.0, 2.0 * are.getInnerRadius(), 2.0 * are.getInnerRadius(), are.getStartAngle(), are.getAngleExtent(), 2);
            Area fArea = new Area(outerArc);
            fArea.exclusiveOr(new Area(innerArc));
            Shape prevClip = this._g2d.getClip();
            Area ar2 = new Area(fArea);
            if (prevClip != null) {
                Area ar1 = new Area(prevClip);
                ar2.intersect(ar1);
            }
            this._g2d.setClip(ar2);
            this._g2d.draw(fArea);
            this._g2d.setClip(prevClip);
        } else {
            this._g2d.draw(new Arc2D.Double(are.getTopLeft().getX(), are.getTopLeft().getY(), are.getWidth(), are.getHeight(), are.getStartAngle(), are.getAngleExtent(), SwingRendererImpl.toSwingArcType(are.getStyle())));
        }
        if (sPrevious != null) {
            this._g2d.setStroke(sPrevious);
        }
    }

    private static final int toSwingArcType(int iArcStyle) {
        switch (iArcStyle) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    public void fillArc(ArcRenderEvent are) throws ChartException {
        Fill flBackground = are.getBackground();
        if (this.isFullTransparent(flBackground)) {
            return;
        }
        if (flBackground instanceof ColorDefinition) {
            ColorDefinition cl = (ColorDefinition)flBackground;
            Color clrPrevious = this._g2d.getColor();
            Color currentColor = (Color)this._ids.getColor(cl);
            this._g2d.setColor(currentColor);
            if (are.getInnerRadius() >= 0.0 && are.getOuterRadius() > 0.0 && are.getInnerRadius() < are.getOuterRadius()) {
                Arc2D.Double outerArc = new Arc2D.Double(are.getTopLeft().getX() + (are.getWidth() - 2.0 * are.getOuterRadius()) / 2.0, are.getTopLeft().getY() + (are.getHeight() - 2.0 * are.getOuterRadius()) / 2.0, 2.0 * are.getOuterRadius(), 2.0 * are.getOuterRadius(), are.getStartAngle(), are.getAngleExtent(), 2);
                Arc2D.Double innerArc = new Arc2D.Double(are.getTopLeft().getX() + (are.getWidth() - 2.0 * are.getInnerRadius()) / 2.0, are.getTopLeft().getY() + (are.getHeight() - 2.0 * are.getInnerRadius()) / 2.0, 2.0 * are.getInnerRadius(), 2.0 * are.getInnerRadius(), are.getStartAngle(), are.getAngleExtent(), 2);
                Area fArea = new Area(outerArc);
                fArea.exclusiveOr(new Area(innerArc));
                Shape prevClip = this._g2d.getClip();
                Area ar2 = new Area(fArea);
                if (prevClip != null) {
                    Area ar1 = new Area(prevClip);
                    ar2.intersect(ar1);
                }
                this._g2d.setClip(ar2);
                this._g2d.fill(fArea);
                this._g2d.setClip(prevClip);
            } else {
                this._g2d.fill(new Arc2D.Double(are.getTopLeft().getX(), are.getTopLeft().getY(), are.getWidth(), are.getHeight(), are.getStartAngle(), are.getAngleExtent(), SwingRendererImpl.toSwingArcType(are.getStyle())));
            }
            this._g2d.setColor(clrPrevious);
        } else if (flBackground instanceof Gradient) {
            Point2D.Double p2dEnd;
            Point2D.Double p2dStart;
            Gradient g = (Gradient)flBackground;
            ColorDefinition cdStart = g.getStartColor();
            ColorDefinition cdEnd = g.getEndColor();
            double dAngleInDegrees = g.getDirection();
            double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
            Bounds bo = are.getBounds();
            if (dAngleInDegrees < -90.0 || dAngleInDegrees > 90.0) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingRendererImpl.exception.gradient.angle", new Object[]{new Double(dAngleInDegrees)}, Messages.getResourceBundle(this.getULocale()));
            }
            if (dAngleInDegrees == 90.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dEnd = new Point2D.Double(bo.getLeft(), bo.getTop());
            } else if (dAngleInDegrees == -90.0) {
                p2dEnd = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
            } else if (dAngleInDegrees > 0.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getHeight() - bo.getWidth() * Math.abs(Math.tan(dAngleInRadians)));
            } else if (dAngleInDegrees < 0.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getWidth() * Math.abs(Math.tan(dAngleInRadians)));
            } else {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop());
            }
            Paint pPrevious = this._g2d.getPaint();
            this._g2d.setPaint(new GradientPaint(p2dStart, (Color)this._ids.getColor(cdStart), p2dEnd, (Color)this._ids.getColor(cdEnd)));
            if (are.getInnerRadius() >= 0.0 && are.getOuterRadius() > 0.0 && are.getInnerRadius() < are.getOuterRadius()) {
                Arc2D.Double outerArc = new Arc2D.Double(are.getTopLeft().getX() + (are.getWidth() - 2.0 * are.getOuterRadius()) / 2.0, are.getTopLeft().getY() + (are.getHeight() - 2.0 * are.getOuterRadius()) / 2.0, 2.0 * are.getOuterRadius(), 2.0 * are.getOuterRadius(), are.getStartAngle(), are.getAngleExtent(), 2);
                Arc2D.Double innerArc = new Arc2D.Double(are.getTopLeft().getX() + (are.getWidth() - 2.0 * are.getInnerRadius()) / 2.0, are.getTopLeft().getY() + (are.getHeight() - 2.0 * are.getInnerRadius()) / 2.0, 2.0 * are.getInnerRadius(), 2.0 * are.getInnerRadius(), are.getStartAngle(), are.getAngleExtent(), 2);
                Area fArea = new Area(outerArc);
                fArea.exclusiveOr(new Area(innerArc));
                Shape prevClip = this._g2d.getClip();
                Area ar2 = new Area(fArea);
                if (prevClip != null) {
                    Area ar1 = new Area(prevClip);
                    ar2.intersect(ar1);
                }
                this._g2d.setClip(ar2);
                this._g2d.fill(fArea);
                this._g2d.setClip(prevClip);
            } else {
                this._g2d.fill(new Arc2D.Double(are.getTopLeft().getX(), are.getTopLeft().getY(), are.getWidth(), are.getHeight(), are.getStartAngle(), are.getAngleExtent(), SwingRendererImpl.toSwingArcType(are.getStyle())));
            }
            this._g2d.setPaint(pPrevious);
        } else if (flBackground instanceof Image) {
            Bounds bo = are.getBounds();
            Rectangle2D.Double r2d = new Rectangle2D.Double(bo.getLeft(), bo.getTop(), bo.getWidth(), bo.getHeight());
            Shape shPreviousClip = this._g2d.getClip();
            if (are.getInnerRadius() >= 0.0 && are.getOuterRadius() > 0.0 && are.getInnerRadius() < are.getOuterRadius()) {
                Arc2D.Double outerArc = new Arc2D.Double(are.getTopLeft().getX() + (are.getWidth() - 2.0 * are.getOuterRadius()) / 2.0, are.getTopLeft().getY() + (are.getHeight() - 2.0 * are.getOuterRadius()) / 2.0, 2.0 * are.getOuterRadius(), 2.0 * are.getOuterRadius(), are.getStartAngle(), are.getAngleExtent(), 2);
                Arc2D.Double innerArc = new Arc2D.Double(are.getTopLeft().getX() + (are.getWidth() - 2.0 * are.getInnerRadius()) / 2.0, are.getTopLeft().getY() + (are.getHeight() - 2.0 * are.getInnerRadius()) / 2.0, 2.0 * are.getInnerRadius(), 2.0 * are.getInnerRadius(), are.getStartAngle(), are.getAngleExtent(), 2);
                Area fArea = new Area(outerArc);
                fArea.exclusiveOr(new Area(innerArc));
                if (shPreviousClip != null) {
                    Area ar1 = new Area(shPreviousClip);
                    fArea.intersect(ar1);
                }
                this._g2d.setClip(fArea);
            } else {
                Arc2D.Double shArc = new Arc2D.Double(are.getTopLeft().getX(), are.getTopLeft().getY(), are.getWidth(), are.getHeight(), are.getStartAngle(), are.getAngleExtent(), SwingRendererImpl.toSwingArcType(are.getStyle()));
                Area ar2 = new Area(shArc);
                if (shPreviousClip != null) {
                    Area ar1 = new Area(shPreviousClip);
                    ar2.intersect(ar1);
                }
                this._g2d.setClip(ar2);
            }
            java.awt.Image img = null;
            if (flBackground instanceof EmbeddedImage) {
                try {
                    byte[] data = Base64.decodeBase64((byte[])((EmbeddedImage)flBackground).getData().getBytes());
                    img = this.createImage(data);
                }
                catch (Exception ilex) {
                    throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)ilex);
                }
            }
            try {
                String sUrl = ((Image)flBackground).getURL();
                img = (java.awt.Image)this._ids.loadImage(new URL(sUrl));
            }
            catch (ChartException ilex) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)ilex);
            }
            catch (MalformedURLException muex) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)muex);
            }
            Size szImage = this._ids.getSize((Object)img);
            int iXRepeat = (int)Math.ceil(r2d.width / szImage.getWidth());
            int iYRepeat = (int)Math.ceil(r2d.height / szImage.getHeight());
            ImageObserver io = (ImageObserver)this._ids.getObserver();
            for (int i = 0; i < iXRepeat; ++i) {
                for (int j = 0; j < iYRepeat; ++j) {
                    this._g2d.drawImage(img, (int)(r2d.x + (double)i * szImage.getWidth()), (int)(r2d.y + (double)j * szImage.getHeight()), io);
                }
            }
            this._g2d.setClip(shPreviousClip);
        }
    }

    public void drawArea(AreaRenderEvent are) throws ChartException {
        LineAttributes lia = are.getOutline();
        if (!this.validateLineAttributes(are.getSource(), lia)) {
            return;
        }
        Color cFG = (Color)this.validateEdgeColor(lia.getColor(), are.getBackground(), this._ids);
        if (cFG == null || cFG.getAlpha() == 0) {
            return;
        }
        GeneralPath gp = new GeneralPath();
        for (int i = 0; i < are.getElementCount(); ++i) {
            PrimitiveRenderEvent pre = are.getElement(i);
            if (pre instanceof ArcRenderEvent) {
                ArcRenderEvent acre = (ArcRenderEvent)pre;
                Arc2D.Double a2d = new Arc2D.Double(acre.getTopLeft().getX(), acre.getTopLeft().getY(), acre.getWidth(), acre.getHeight(), acre.getStartAngle(), acre.getAngleExtent(), SwingRendererImpl.toSwingArcType(acre.getStyle()));
                gp.append(a2d, true);
                continue;
            }
            if (!(pre instanceof LineRenderEvent)) continue;
            LineRenderEvent lre = (LineRenderEvent)pre;
            Line2D.Double l2d = new Line2D.Double(lre.getStart().getX(), lre.getStart().getY(), lre.getEnd().getX(), lre.getEnd().getY());
            gp.append(l2d, true);
        }
        Stroke sPrevious = null;
        Stroke sCurrent = this.getCachedStroke(lia);
        if (sCurrent != null) {
            sPrevious = this._g2d.getStroke();
            this._g2d.setStroke(sCurrent);
        }
        this._g2d.setColor(cFG);
        this._g2d.draw(gp);
        if (sPrevious != null) {
            this._g2d.setStroke(sPrevious);
        }
    }

    public void fillArea(AreaRenderEvent are) throws ChartException {
        Fill flBackground = are.getBackground();
        if (this.isFullTransparent(flBackground)) {
            return;
        }
        GeneralPath gp = new GeneralPath();
        for (int i = 0; i < are.getElementCount(); ++i) {
            PrimitiveRenderEvent pre = are.getElement(i);
            if (pre instanceof ArcRenderEvent) {
                ArcRenderEvent acre = (ArcRenderEvent)pre;
                Arc2D.Double a2d = new Arc2D.Double(acre.getTopLeft().getX(), acre.getTopLeft().getY(), acre.getWidth(), acre.getHeight(), acre.getStartAngle(), acre.getAngleExtent(), SwingRendererImpl.toSwingArcType(acre.getStyle()));
                gp.append(a2d, true);
                continue;
            }
            if (!(pre instanceof LineRenderEvent)) continue;
            LineRenderEvent lre = (LineRenderEvent)pre;
            Line2D.Double l2d = new Line2D.Double(lre.getStart().getX(), lre.getStart().getY(), lre.getEnd().getX(), lre.getEnd().getY());
            gp.append(l2d, true);
        }
        if (flBackground instanceof ColorDefinition) {
            this._g2d.setColor((Color)this._ids.getColor((ColorDefinition)flBackground));
        } else if (flBackground instanceof Gradient) {
            Point2D.Double p2dEnd;
            Point2D.Double p2dStart;
            Gradient g = (Gradient)flBackground;
            ColorDefinition cdStart = g.getStartColor();
            ColorDefinition cdEnd = g.getEndColor();
            double dAngleInDegrees = g.getDirection();
            double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
            Bounds bo = are.getBounds();
            if (dAngleInDegrees < -90.0 || dAngleInDegrees > 90.0) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingRendererImpl.exception.gradient.angle", new Object[]{new Double(dAngleInDegrees)}, Messages.getResourceBundle(this.getULocale()));
            }
            if (dAngleInDegrees == 90.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dEnd = new Point2D.Double(bo.getLeft(), bo.getTop());
            } else if (dAngleInDegrees == -90.0) {
                p2dEnd = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
            } else if (dAngleInDegrees > 0.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getHeight() - bo.getWidth() * Math.abs(Math.tan(dAngleInRadians)));
            } else if (dAngleInDegrees < 0.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getWidth() * Math.abs(Math.tan(dAngleInRadians)));
            } else {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop());
            }
            this._g2d.setPaint(new GradientPaint(p2dStart, (Color)this._ids.getColor(cdStart), p2dEnd, (Color)this._ids.getColor(cdEnd)));
        } else if (flBackground instanceof Image) {
            // empty if block
        }
        this._g2d.fill(gp);
    }

    public void drawText(TextRenderEvent tre) throws ChartException {
        SwingTextRenderer tr = SwingTextRenderer.instance((SwingDisplayServer)this._ids);
        switch (tre.getAction()) {
            case 0: {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingRendererImpl.exception.missing.text.render.action", Messages.getResourceBundle(this.getULocale()));
            }
            case 1: {
                tr.renderShadowAtLocation((IPrimitiveRenderer)this, tre.getTextPosition(), tre.getLocation(), tre.getLabel());
                break;
            }
            case 2: {
                tr.renderTextAtLocation((IPrimitiveRenderer)this, tre.getTextPosition(), tre.getLocation(), tre.getLabel());
                break;
            }
            case 3: {
                tr.renderTextInBlock((IDeviceRenderer)this, tre.getBlockBounds(), tre.getBlockAlignment(), tre.getLabel());
            }
        }
    }

    protected void registerTriggers(Trigger[] tga, ShapedAction sa) {
        for (int i = 0; i < tga.length; ++i) {
            TriggerCondition tc = tga[i].getCondition();
            Action ac = tga[i].getAction();
            sa.add(tc, ac);
            ArrayList<ShapedAction> al = (ArrayList<ShapedAction>)this._lhmAllTriggers.get(tc);
            if (al == null) {
                al = new ArrayList<ShapedAction>(4);
                this._lhmAllTriggers.put(tc, al);
            }
            al.add(sa);
        }
        this._allShapes.add(sa);
    }

    public void enableInteraction(InteractionEvent iev) throws ChartException {
        if (this._iun == null) {
            logger.log(1, Messages.getString("SwingRendererImpl.exception.missing.component.interaction", this.getULocale()));
            return;
        }
        Trigger[] tga = iev.getTriggers();
        if (tga == null) {
            return;
        }
        ShapedAction sa = this.getShapedAction(iev);
        if (sa != null) {
            this.registerTriggers(tga, sa);
        }
    }

    protected ShapedAction getShapedAction(InteractionEvent iev) {
        Shape clipping = this._g2d.getClip();
        PrimitiveRenderEvent pre = iev.getHotSpot();
        if (pre instanceof PolygonRenderEvent) {
            Location[] loa = ((PolygonRenderEvent)pre).getPoints();
            return new ShapedAction(iev.getStructureSource(), loa, clipping);
        }
        if (pre instanceof RectangleRenderEvent) {
            Bounds bo = ((RectangleRenderEvent)pre).getBounds();
            Location[] loa = new Location[]{LocationImpl.create((double)bo.getLeft(), (double)bo.getTop()), LocationImpl.create((double)bo.getLeft(), (double)(bo.getTop() + bo.getHeight())), LocationImpl.create((double)(bo.getLeft() + bo.getWidth()), (double)(bo.getTop() + bo.getHeight())), LocationImpl.create((double)(bo.getLeft() + bo.getWidth()), (double)bo.getTop())};
            return new ShapedAction(iev.getStructureSource(), loa, clipping);
        }
        if (pre instanceof OvalRenderEvent) {
            Bounds boEllipse = ((OvalRenderEvent)pre).getBounds();
            return new ShapedAction(iev.getStructureSource(), boEllipse, clipping);
        }
        if (pre instanceof ArcRenderEvent) {
            ArcRenderEvent are = (ArcRenderEvent)pre;
            Bounds boEllipse = are.getEllipseBounds();
            double dStart = are.getStartAngle();
            double dExtent = are.getAngleExtent();
            int iArcType = SwingRendererImpl.toSwingArcType(are.getStyle());
            return new ShapedAction(iev.getStructureSource(), boEllipse, dStart, dExtent, iArcType, clipping);
        }
        if (pre instanceof AreaRenderEvent) {
            Bounds bo = ((AreaRenderEvent)pre).getBounds();
            Location[] loa = new Location[]{LocationImpl.create((double)bo.getLeft(), (double)bo.getTop()), LocationImpl.create((double)bo.getLeft(), (double)(bo.getTop() + bo.getHeight())), LocationImpl.create((double)(bo.getLeft() + bo.getWidth()), (double)(bo.getTop() + bo.getHeight())), LocationImpl.create((double)(bo.getLeft() + bo.getWidth()), (double)bo.getTop())};
            return new ShapedAction(iev.getStructureSource(), loa, clipping);
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public final Stroke getCachedStroke(LineAttributes lia) {
        if (lia == null) {
            return null;
        }
        Stroke s = (Stroke)this._htLineStyles.get(lia);
        if (s == null) {
            BasicStroke bs = null;
            if (lia.getStyle().getValue() == 1) {
                float[] faStyle = new float[]{6.0f, 4.0f};
                bs = new BasicStroke(lia.getThickness(), 1, 1, 0.0f, faStyle, 0.0f);
            } else if (lia.getStyle().getValue() == 2) {
                float[] faStyle = new float[]{1.0f, 4.0f};
                bs = new BasicStroke(lia.getThickness(), 1, 1, 0.0f, faStyle, 0.0f);
            } else if (lia.getStyle().getValue() == 3) {
                float[] faStyle = new float[]{6.0f, 4.0f, 1.0f, 4.0f};
                bs = new BasicStroke(lia.getThickness(), 1, 1, 0.0f, faStyle, 0.0f);
            } else if (lia.getStyle().getValue() == 0) {
                bs = new BasicStroke(lia.getThickness(), 1, 1);
            }
            if (bs != null) {
                this._htLineStyles.put(lia, bs);
            }
            return bs;
        }
        return s;
    }

    public static String csSearchAndReplace(String s, String sWordToReplace, String sReplaceWith) {
        int i = 0;
        do {
            if ((i = s.indexOf(sWordToReplace, i)) == -1) continue;
            s = s.substring(0, i) + sReplaceWith + s.substring(i + sWordToReplace.length());
            i += sReplaceWith.length();
        } while (i != -1);
        return s;
    }

    public void drawOval(OvalRenderEvent ore) throws ChartException {
        LineAttributes lia = ore.getOutline();
        if (!this.validateLineAttributes(ore.getSource(), lia)) {
            return;
        }
        Color cFG = (Color)this.validateEdgeColor(lia.getColor(), ore.getBackground(), this._ids);
        if (cFG == null || cFG.getAlpha() == 0) {
            return;
        }
        Bounds bo = ore.getBounds();
        Ellipse2D.Double e2d = new Ellipse2D.Double(bo.getLeft(), bo.getTop(), bo.getWidth(), bo.getHeight());
        Stroke sPrevious = null;
        Stroke sCurrent = this.getCachedStroke(lia);
        if (sCurrent != null) {
            sPrevious = this._g2d.getStroke();
            this._g2d.setStroke(sCurrent);
        }
        this._g2d.setColor(cFG);
        this._g2d.draw(e2d);
        if (sPrevious != null) {
            this._g2d.setStroke(sPrevious);
        }
    }

    public void fillOval(OvalRenderEvent ore) throws ChartException {
        Fill flBackground = ore.getBackground();
        if (this.isFullTransparent(flBackground)) {
            return;
        }
        Bounds bo = ore.getBounds();
        Ellipse2D.Double e2d = new Ellipse2D.Double(bo.getLeft(), bo.getTop(), bo.getWidth(), bo.getHeight());
        if (flBackground instanceof ColorDefinition) {
            ColorDefinition cd = (ColorDefinition)flBackground;
            this._g2d.setColor((Color)this._ids.getColor(cd));
            this._g2d.fill(e2d);
        } else if (flBackground instanceof Gradient) {
            Point2D.Double p2dEnd;
            Point2D.Double p2dStart;
            Gradient g = (Gradient)flBackground;
            ColorDefinition cdStart = g.getStartColor();
            ColorDefinition cdEnd = g.getEndColor();
            double dAngleInDegrees = g.getDirection();
            double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
            if (dAngleInDegrees < -90.0 || dAngleInDegrees > 90.0) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, "SwingRendererImpl.exception.gradient.angle", new Object[]{new Double(dAngleInDegrees)}, Messages.getResourceBundle(this.getULocale()));
            }
            if (dAngleInDegrees == 90.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dEnd = new Point2D.Double(bo.getLeft(), bo.getTop());
            } else if (dAngleInDegrees == -90.0) {
                p2dEnd = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
            } else if (dAngleInDegrees > 0.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop() + bo.getHeight());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getHeight() - bo.getWidth() * Math.abs(Math.tan(dAngleInRadians)));
            } else if (dAngleInDegrees < 0.0) {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getWidth() * Math.abs(Math.tan(dAngleInRadians)));
            } else {
                p2dStart = new Point2D.Double(bo.getLeft(), bo.getTop());
                p2dEnd = new Point2D.Double(bo.getLeft() + bo.getWidth(), bo.getTop());
            }
            this._g2d.setPaint(new GradientPaint(p2dStart, (Color)this._ids.getColor(cdStart), p2dEnd, (Color)this._ids.getColor(cdEnd)));
            this._g2d.fill(e2d);
        } else if (flBackground instanceof Image) {
            java.awt.Image img = null;
            if (flBackground instanceof EmbeddedImage) {
                try {
                    byte[] data = Base64.decodeBase64((byte[])((EmbeddedImage)flBackground).getData().getBytes());
                    img = this.createImage(data);
                }
                catch (Exception ilex) {
                    throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)ilex);
                }
            }
            try {
                String sUrl = ((Image)flBackground).getURL();
                img = (java.awt.Image)this._ids.loadImage(new URL(sUrl));
            }
            catch (ChartException ilex) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)ilex);
            }
            catch (MalformedURLException muex) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 11, (Throwable)muex);
            }
            Shape shClip = this._g2d.getClip();
            Area ar2 = new Area(e2d);
            if (shClip != null) {
                Area ar1 = new Area(shClip);
                ar2.intersect(ar1);
            }
            this._g2d.setClip(ar2);
            Size szImage = this._ids.getSize((Object)img);
            int iXRepeat = (int)Math.ceil(e2d.width / szImage.getWidth());
            int iYRepeat = (int)Math.ceil(e2d.height / szImage.getHeight());
            ImageObserver io = (ImageObserver)this._ids.getObserver();
            for (int i = 0; i < iXRepeat; ++i) {
                for (int j = 0; j < iYRepeat; ++j) {
                    this._g2d.drawImage(img, (int)(e2d.x + (double)i * szImage.getWidth()), (int)(e2d.y + (double)j * szImage.getHeight()), io);
                }
            }
            this._g2d.setClip(shClip);
        }
    }

    public IDisplayServer getDisplayServer() {
        return this._ids;
    }

    protected java.awt.Image createImage(byte[] data) {
        ImageIcon ii = new ImageIcon(data);
        return ii.getImage();
    }

    protected Map getTriggers() {
        return this._lhmAllTriggers;
    }

    protected List getShapeActions() {
        return this._allShapes;
    }

    public void applyTransformation(TransformationEvent tev) throws ChartException {
        switch (tev.getTransform()) {
            case 2: {
                this._g2d.translate(tev.getTranslateX(), tev.getTranslateY());
                break;
            }
            case 4: {
                this._g2d.rotate(tev.getRotation() * Math.PI / 180.0);
                break;
            }
            case 1: {
                this._g2d.scale(tev.getScale(), tev.getScale());
            }
        }
    }

    public void before() throws ChartException {
        this._lhmAllTriggers.clear();
    }

    public void after() throws ChartException {
        ((SwingDisplayServer)this._ids).getImageCache().flush();
    }

    static {
        $assertionsDisabled = !SwingRendererImpl.class.desiredAssertionStatus();
        logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/swing");
    }
}

