/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.event;

import java.util.Iterator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.ui.swt.interfaces.IChangeListener;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIManager;

public class ChangeListenerImpl
implements IChangeListener {
    private transient int iBaseSeriesCount = 0;
    private transient int iOrthogonalSeriesCount = 0;
    private transient int iBaseAxisCount = 0;
    private transient int iOrthogonalAxisCount = 0;
    private transient int iLabelBlockCount = 0;
    private static final String BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES = "BaseSeriesSheetsCWA";
    private static final String ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES = "OrthogonalSeriesSheetsCWA";
    private static final String BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES = "BaseSeriesSheetsCWOA";
    private static final String ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES = "OrthogonalSeriesSheetsCWOA";
    private static final String BASE_AXIS_SHEET_COLLECTION = "BaseAxisSheets";
    private static final String ORTHOGONAL_AXIS_SHEET_COLLECTION = "OrthogonalAxisSheets";
    private static final String LABEL_BLOCK_SHEET_COLLECTION = "LabelBlockSeriesSheets";
    private static final String[] BASE_SERIES_SHEETS_FOR_CHARTS_WITH_AXES = new String[]{"Data.X Series", "Attributes.X Series"};
    private static final String[] ORTHOGONAL_SERIES_SHEETS_FOR_CHARTS_WITH_AXES = new String[]{"Data.Y Series", "Attributes.Y Series", "Attributes.Y Series.Labels"};
    private static final String[] BASE_SERIES_SHEETS_FOR_CHARTS_WITHOUT_AXES = new String[]{"Data.Base Series", "Attributes.Base Series"};
    private static final String[] ORTHOGONAL_SERIES_SHEETS_FOR_CHARTS_WITHOUT_AXES = new String[]{"Data.Orthogonal Series", "Attributes.Orthogonal Series", "Attributes.Orthogonal Series.Labels"};
    private static final String[] BASE_AXIS_SHEETS = new String[]{"Data.X Axis", "Attributes.X Axis", "Attributes.X Axis.Labels", "Attributes.X Axis.Markers"};
    private static final String[] ORTHOGONAL_AXIS_SHEETS = new String[]{"Data.Y Axis", "Attributes.Y Axis", "Attributes.Y Axis.Labels", "Attributes.Y Axis.Markers"};
    private static final String[] LABEL_BLOCK_SHEETS = new String[]{"Layout.Label Block"};

    public void initialize(Chart cModel, IUIManager uiManager) {
        int iOS;
        int iBS;
        uiManager.registerSheetCollection(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES, BASE_SERIES_SHEETS_FOR_CHARTS_WITH_AXES);
        uiManager.registerSheetCollection(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES, ORTHOGONAL_SERIES_SHEETS_FOR_CHARTS_WITH_AXES);
        uiManager.registerSheetCollection(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES, BASE_SERIES_SHEETS_FOR_CHARTS_WITHOUT_AXES);
        uiManager.registerSheetCollection(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES, ORTHOGONAL_SERIES_SHEETS_FOR_CHARTS_WITHOUT_AXES);
        uiManager.registerSheetCollection(BASE_AXIS_SHEET_COLLECTION, BASE_AXIS_SHEETS);
        uiManager.registerSheetCollection(ORTHOGONAL_AXIS_SHEET_COLLECTION, ORTHOGONAL_AXIS_SHEETS);
        uiManager.registerSheetCollection(LABEL_BLOCK_SHEET_COLLECTION, LABEL_BLOCK_SHEETS);
        this.iLabelBlockCount = 0;
        if (cModel instanceof ChartWithAxes) {
            this.iBaseAxisCount = ((ChartWithAxes)cModel).getAxes().size();
            this.iOrthogonalAxisCount = 0;
            this.iBaseSeriesCount = 0;
            this.iOrthogonalSeriesCount = 0;
            for (int i = 0; i < this.iBaseAxisCount; ++i) {
                this.iBaseSeriesCount += ((Axis)((ChartWithAxes)cModel).getAxes().get(i)).getSeriesDefinitions().size();
                this.iOrthogonalAxisCount += ((Axis)((ChartWithAxes)cModel).getAxes().get(i)).getAssociatedAxes().size();
                for (int iS = 0; iS < this.iOrthogonalAxisCount; ++iS) {
                    this.iOrthogonalSeriesCount += ((Axis)((Axis)((ChartWithAxes)cModel).getAxes().get(i)).getAssociatedAxes().get(iS)).getSeriesDefinitions().size();
                }
            }
            for (int iBA = 1; iBA < this.iBaseAxisCount; ++iBA) {
                uiManager.addCollectionInstance(BASE_AXIS_SHEET_COLLECTION);
            }
            for (int iOA = 1; iOA < this.iOrthogonalAxisCount; ++iOA) {
                uiManager.addCollectionInstance(ORTHOGONAL_AXIS_SHEET_COLLECTION);
            }
            uiManager.removeCollectionInstance(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
            uiManager.removeCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
            for (iBS = 1; iBS < this.iBaseSeriesCount; ++iBS) {
                uiManager.addCollectionInstance(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES);
            }
            for (iOS = 1; iOS < this.iOrthogonalSeriesCount; ++iOS) {
                uiManager.addCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES);
            }
        } else {
            this.iBaseAxisCount = 0;
            this.iOrthogonalAxisCount = 0;
            this.iBaseSeriesCount = ((ChartWithoutAxes)cModel).getSeriesDefinitions().size();
            this.iOrthogonalSeriesCount = 0;
            for (int iS = 0; iS < this.iBaseSeriesCount; ++iS) {
                this.iOrthogonalSeriesCount += ((SeriesDefinition)((ChartWithoutAxes)cModel).getSeriesDefinitions().get(iS)).getSeriesDefinitions().size();
            }
            uiManager.removeCollectionInstance(ORTHOGONAL_AXIS_SHEET_COLLECTION);
            uiManager.removeCollectionInstance(BASE_AXIS_SHEET_COLLECTION);
            uiManager.removeCollectionInstance(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES);
            uiManager.removeCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES);
            for (iBS = 1; iBS < this.iBaseSeriesCount; ++iBS) {
                uiManager.addCollectionInstance(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
            }
            for (iOS = 1; iOS < this.iOrthogonalSeriesCount; ++iOS) {
                uiManager.addCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
            }
        }
        Iterator iter = cModel.getBlock().getChildren().iterator();
        while (iter.hasNext()) {
            Block block = (Block)iter.next();
            if (!(block instanceof LabelBlock) || block instanceof TitleBlock) continue;
            ++this.iLabelBlockCount;
        }
        if (this.iLabelBlockCount == 0) {
            uiManager.removeCollectionInstance(LABEL_BLOCK_SHEET_COLLECTION);
        } else {
            for (int iLB = 1; iLB < this.iLabelBlockCount; ++iLB) {
                uiManager.addCollectionInstance(LABEL_BLOCK_SHEET_COLLECTION);
            }
        }
    }

    public void chartModified(Chart cModel, IUIManager uiManager) {
        int iNewBaseAxisCount = 0;
        int iNewOrthogonalAxisCount = 0;
        int iNewBaseSeriesCount = 0;
        int iNewOrthogonalSeriesCount = 0;
        int iNewLabelBlockCount = 0;
        if (cModel instanceof ChartWithAxes) {
            int iOA;
            int iBA;
            iNewBaseAxisCount = ((ChartWithAxes)cModel).getAxes().size();
            iNewOrthogonalAxisCount = 0;
            iNewBaseSeriesCount = 0;
            iNewOrthogonalSeriesCount = 0;
            for (int i = 0; i < iNewBaseAxisCount; ++i) {
                iNewBaseSeriesCount += ((Axis)((ChartWithAxes)cModel).getAxes().get(i)).getSeriesDefinitions().size();
                iNewOrthogonalAxisCount += ((Axis)((ChartWithAxes)cModel).getAxes().get(i)).getAssociatedAxes().size();
                for (int iS = 0; iS < iNewOrthogonalAxisCount; ++iS) {
                    iNewOrthogonalSeriesCount += ((Axis)((Axis)((ChartWithAxes)cModel).getAxes().get(i)).getAssociatedAxes().get(iS)).getSeriesDefinitions().size();
                }
            }
            if (iNewBaseAxisCount >= this.iBaseAxisCount) {
                for (iBA = this.iBaseAxisCount; iBA < iNewBaseAxisCount; ++iBA) {
                    uiManager.addCollectionInstance(BASE_AXIS_SHEET_COLLECTION);
                }
            } else {
                for (iBA = this.iBaseAxisCount; iBA > iNewBaseAxisCount; --iBA) {
                    uiManager.removeCollectionInstance(BASE_AXIS_SHEET_COLLECTION);
                }
            }
            if (iNewOrthogonalAxisCount >= this.iOrthogonalAxisCount) {
                for (iOA = this.iOrthogonalAxisCount; iOA < iNewOrthogonalAxisCount; ++iOA) {
                    uiManager.addCollectionInstance(ORTHOGONAL_AXIS_SHEET_COLLECTION);
                }
            } else {
                for (iOA = this.iOrthogonalAxisCount; iOA > iNewOrthogonalAxisCount; --iOA) {
                    uiManager.removeCollectionInstance(ORTHOGONAL_AXIS_SHEET_COLLECTION);
                }
            }
        } else {
            iNewBaseAxisCount = 0;
            iNewOrthogonalAxisCount = 0;
            iNewBaseSeriesCount = ((ChartWithoutAxes)cModel).getSeriesDefinitions().size();
            iNewOrthogonalSeriesCount = 0;
            for (int iS = 0; iS < iNewBaseSeriesCount; ++iS) {
                iNewOrthogonalSeriesCount += ((SeriesDefinition)((ChartWithoutAxes)cModel).getSeriesDefinitions().get(iS)).getSeriesDefinitions().size();
            }
        }
        Iterator iter = cModel.getBlock().getChildren().iterator();
        while (iter.hasNext()) {
            Block block = (Block)iter.next();
            if (!(block instanceof LabelBlock) || block instanceof TitleBlock) continue;
            ++iNewLabelBlockCount;
        }
        if (cModel instanceof ChartWithAxes) {
            int iOS;
            int iBS;
            if (iNewBaseSeriesCount >= this.iBaseSeriesCount) {
                for (iBS = this.iBaseSeriesCount; iBS < iNewBaseSeriesCount; ++iBS) {
                    uiManager.addCollectionInstance(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES);
                }
            } else {
                for (iBS = this.iBaseSeriesCount; iBS > iNewBaseSeriesCount; --iBS) {
                    uiManager.removeCollectionInstance(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES);
                }
            }
            if (iNewOrthogonalSeriesCount >= this.iOrthogonalSeriesCount) {
                for (iOS = this.iOrthogonalSeriesCount; iOS < iNewOrthogonalSeriesCount; ++iOS) {
                    uiManager.addCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES);
                }
            } else {
                for (iOS = this.iOrthogonalSeriesCount; iOS > iNewOrthogonalSeriesCount; --iOS) {
                    uiManager.removeCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES);
                }
            }
        } else {
            int iOS;
            int iBS;
            if (iNewBaseSeriesCount >= this.iBaseSeriesCount) {
                for (iBS = this.iBaseSeriesCount; iBS < iNewBaseSeriesCount; ++iBS) {
                    uiManager.addCollectionInstance(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
                }
            } else {
                for (iBS = this.iBaseSeriesCount; iBS > iNewBaseSeriesCount; --iBS) {
                    uiManager.removeCollectionInstance(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
                }
            }
            if (iNewOrthogonalSeriesCount >= this.iOrthogonalSeriesCount) {
                for (iOS = this.iOrthogonalSeriesCount; iOS < iNewOrthogonalSeriesCount; ++iOS) {
                    uiManager.addCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
                }
            } else {
                for (iOS = this.iOrthogonalSeriesCount; iOS > iNewOrthogonalSeriesCount; --iOS) {
                    uiManager.removeCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
                }
            }
        }
        this.iBaseAxisCount = iNewBaseAxisCount;
        this.iOrthogonalAxisCount = iNewOrthogonalAxisCount;
        this.iBaseSeriesCount = iNewBaseSeriesCount;
        this.iOrthogonalSeriesCount = iNewOrthogonalSeriesCount;
    }
}

