/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.component.Dial;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.GridAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class DialTicksDialog
implements Listener {
    private transient Group grpMajor = null;
    private transient Group grpMinor = null;
    private transient GridAttributesComposite gacMajor = null;
    private transient GridAttributesComposite gacMinor = null;
    private transient DialSeries series;
    private transient Shell shell;
    private transient ChartWizardContext context;

    public DialTicksDialog(Shell parent, ChartWizardContext context, DialSeries series) {
        this.series = series;
        this.context = context;
        this.shell = new Shell(parent, 67696);
        this.shell.setSize(450, 170);
        UIHelper.centerOnScreen((Shell)this.shell);
        this.shell.setLayout((Layout)new FillLayout());
        this.placeComponents();
        this.shell.setText(Messages.getString("DialTicksDialog.Title.DialTicks"));
        this.shell.layout();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    protected Composite placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        glContent.verticalSpacing = 5;
        Composite cmpContent = new Composite((Composite)this.shell, 0);
        cmpContent.setLayout((Layout)glContent);
        FillLayout flMajor = new FillLayout();
        FillLayout flMinor = new FillLayout();
        this.grpMajor = new Group(cmpContent, 0);
        GridData gdGRPMajor = new GridData(768);
        this.grpMajor.setLayoutData((Object)gdGRPMajor);
        this.grpMajor.setText(Messages.getString("OrthogonalSeriesDataSheetImpl.Lbl.MajorGrid"));
        this.grpMajor.setLayout((Layout)flMajor);
        this.gacMajor = new GridAttributesComposite((Composite)this.grpMajor, 0, this.context, this.getDialForProcessing().getMajorGrid(), false);
        this.gacMajor.addListener(this);
        this.grpMinor = new Group(cmpContent, 0);
        GridData gdGRPMinor = new GridData(768);
        this.grpMinor.setLayoutData((Object)gdGRPMinor);
        this.grpMinor.setText(Messages.getString("OrthogonalSeriesDataSheetImpl.Lbl.MinorGrid"));
        this.grpMinor.setLayout((Layout)flMinor);
        this.gacMinor = new GridAttributesComposite((Composite)this.grpMinor, 0, this.context, this.getDialForProcessing().getMinorGrid(), false);
        this.gacMinor.addListener(this);
        return cmpContent;
    }

    public Dial getDialForProcessing() {
        return this.series.getDial();
    }

    public void handleEvent(Event event) {
        if (((Object)((Object)this.gacMajor)).equals(event.widget)) {
            switch (event.type) {
                case 6: {
                    this.getDialForProcessing().getMajorGrid().getTickAttributes().setColor((ColorDefinition)event.data);
                    break;
                }
                case 5: {
                    this.getDialForProcessing().getMajorGrid().setTickStyle((TickStyle)event.data);
                    break;
                }
                case 7: {
                    this.getDialForProcessing().getMajorGrid().getTickAttributes().setVisible(((Boolean)event.data).booleanValue());
                }
            }
        } else if (((Object)((Object)this.gacMinor)).equals(event.widget)) {
            switch (event.type) {
                case 6: {
                    this.getDialForProcessing().getMinorGrid().getTickAttributes().setColor((ColorDefinition)event.data);
                    break;
                }
                case 5: {
                    this.getDialForProcessing().getMinorGrid().setTickStyle((TickStyle)event.data);
                    break;
                }
                case 7: {
                    this.getDialForProcessing().getMinorGrid().getTickAttributes().setVisible(((Boolean)event.data).booleanValue());
                }
            }
        }
    }

    public boolean disposed() {
        return this.shell.isDisposed();
    }
}

