/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.ExtendedProperty;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ExtendedPropertyEditorComposite
extends Composite
implements SelectionListener {
    private transient LinkedHashMap propMap = null;
    private transient Table table = null;
    private transient TableColumn tcKey = null;
    private transient TableColumn tcValue = null;
    private transient TableEditor editorValue = null;
    private transient Text txtNewKey = null;
    private transient Button btnAdd = null;
    private transient Button btnRemove = null;
    private transient Composite cmpDlgButtons = null;
    private transient Button btnAccept = null;
    private transient Button btnCancel = null;
    private transient Color color;
    private transient Chart chart;

    public ExtendedPropertyEditorComposite(Composite parent, int style, Chart chart) {
        super(parent, style);
        this.chart = chart;
        this.init();
        this.placeComponents();
        this.color = new Color((Device)Display.getCurrent(), 100, 200, 100);
    }

    private void init() {
        this.propMap = this.getExtendedProperties();
        if (this.propMap == null) {
            this.propMap = new LinkedHashMap(20);
        }
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 5;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        this.setLayout((Layout)glContent);
        this.table = new Table((Composite)this, 67588);
        GridData gdTable = new GridData(1808);
        this.table.setLayoutData((Object)gdTable);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tcKey = new TableColumn(this.table, 0x1000000);
        this.tcKey.setWidth(186);
        this.tcKey.setText(Messages.getString("PropertyEditorDialog.Lbl.Key"));
        this.tcValue = new TableColumn(this.table, 16384);
        this.tcValue.setWidth(186);
        this.tcValue.setText(Messages.getString("PropertyEditorDialog.Lbl.Value"));
        this.editorValue = new TableEditor(this.table);
        this.editorValue.setColumn(1);
        this.editorValue.grabHorizontal = true;
        this.editorValue.minimumWidth = 30;
        this.table.addSelectionListener((SelectionListener)this);
        GridLayout glButtons = new GridLayout();
        glButtons.numColumns = 3;
        glButtons.horizontalSpacing = 5;
        glButtons.verticalSpacing = 5;
        glButtons.marginWidth = 0;
        glButtons.marginHeight = 0;
        Composite cmpButtons = new Composite((Composite)this, 0);
        GridData gdCMPButtons = new GridData(768);
        cmpButtons.setLayoutData((Object)gdCMPButtons);
        cmpButtons.setLayout((Layout)glButtons);
        this.txtNewKey = new Text(cmpButtons, 2052);
        GridData gdTXTNewKey = new GridData(768);
        gdTXTNewKey.grabExcessHorizontalSpace = true;
        this.txtNewKey.setLayoutData((Object)gdTXTNewKey);
        this.btnAdd = new Button(cmpButtons, 8);
        GridData gdBTNAdd = new GridData(128);
        gdBTNAdd.grabExcessHorizontalSpace = false;
        this.btnAdd.setLayoutData((Object)gdBTNAdd);
        this.btnAdd.setText(Messages.getString("PropertyEditorDialog.Lbl.Add"));
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnRemove = new Button(cmpButtons, 8);
        GridData gdBTNRemove = new GridData(128);
        gdBTNRemove.grabExcessHorizontalSpace = false;
        this.btnRemove.setLayoutData((Object)gdBTNRemove);
        this.btnRemove.setText(Messages.getString("PropertyEditorDialog.Lbl.Remove"));
        this.btnRemove.addSelectionListener((SelectionListener)this);
        GridLayout glDlgButtons = new GridLayout();
        glDlgButtons.numColumns = 2;
        glDlgButtons.horizontalSpacing = 5;
        glDlgButtons.verticalSpacing = 5;
        glDlgButtons.marginHeight = 0;
        glDlgButtons.marginWidth = 0;
        this.cmpDlgButtons = new Composite((Composite)this, 0);
        GridData gdCMPDlgButtons = new GridData(768);
        this.cmpDlgButtons.setLayoutData((Object)gdCMPDlgButtons);
        this.cmpDlgButtons.setLayout((Layout)glDlgButtons);
        this.btnAccept = new Button(this.cmpDlgButtons, 8);
        GridData gdBTNAccept = new GridData(896);
        this.btnAccept.setLayoutData((Object)gdBTNAccept);
        this.btnAccept.setText(Messages.getString("Shared.Lbl.OK"));
        this.btnAccept.addSelectionListener((SelectionListener)this);
        this.btnCancel = new Button(this.cmpDlgButtons, 8);
        GridData gdBTNCancel = new GridData();
        this.btnCancel.setLayoutData((Object)gdBTNCancel);
        this.btnCancel.setText(Messages.getString("Shared.Lbl.Cancel"));
        this.btnCancel.addSelectionListener((SelectionListener)this);
        this.populateTable();
    }

    private void populateTable() {
        Iterator keys = this.propMap.keySet().iterator();
        while (keys.hasNext()) {
            Object oKey = keys.next();
            Object oValue = this.propMap.get(oKey);
            String[] sProperty = new String[]{oKey.toString(), oValue.toString()};
            TableItem tiProp = new TableItem(this.table, 0);
            tiProp.setBackground(this.color);
            tiProp.setText(sProperty);
        }
        if (this.table.getItemCount() > 0) {
            this.table.select(0);
        } else {
            this.txtNewKey.forceFocus();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnAdd)) {
            String sKey = this.txtNewKey.getText();
            if (sKey.length() > 0 && !this.propMap.containsKey(sKey)) {
                this.propMap.put(sKey, "");
                String[] sProperty = new String[]{sKey, ""};
                TableItem tiProp = new TableItem(this.table, 0);
                tiProp.setBackground(this.color);
                tiProp.setText(sProperty);
            }
        } else if (e.getSource().equals(this.btnRemove)) {
            if (this.table.getSelection().length != 0) {
                this.propMap.remove(this.table.getSelection()[0].getText(0));
                this.table.remove(this.table.getSelectionIndex());
                Control editor = this.editorValue.getEditor();
                if (editor != null) {
                    editor.dispose();
                }
            }
        } else if (e.getSource().equals(this.btnAccept)) {
            for (int i = 0; i < this.table.getItemCount(); ++i) {
                this.propMap.put(this.table.getItem(i).getText(0), this.table.getItem(i).getText(1));
            }
            if (this.editorValue.getEditor() != null && !this.editorValue.getEditor().isDisposed()) {
                this.propMap.put(this.table.getSelection()[0].getText(0), ((Text)this.editorValue.getEditor()).getText());
            }
            this.chart.getExtendedProperties().clear();
            this.chart.getExtendedProperties().addAll((Collection)this.createExtendedProperties(this.propMap));
            this.getShell().close();
        } else if (e.getSource().equals(this.btnCancel)) {
            this.getShell().close();
        } else if (e.getSource().equals(this.table)) {
            TableItem item;
            Control oldEditor = this.editorValue.getEditor();
            if (oldEditor != null) {
                oldEditor.dispose();
            }
            if ((item = (TableItem)e.item) == null) {
                return;
            }
            Text newEditor = new Text((Composite)this.table, 0);
            newEditor.setText(item.getText(1));
            newEditor.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text text = (Text)ExtendedPropertyEditorComposite.this.editorValue.getEditor();
                    ExtendedPropertyEditorComposite.this.editorValue.getItem().setText(1, text.getText());
                }
            });
            newEditor.selectAll();
            newEditor.setFocus();
            this.editorValue.setEditor((Control)newEditor, item, 1);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.color != null && !this.color.isDisposed()) {
            this.color.dispose();
        }
    }

    private LinkedHashMap getExtendedProperties() {
        LinkedHashMap<String, String> propMap = new LinkedHashMap<String, String>();
        Object[] oArr = this.chart.getExtendedProperties().toArray();
        if (oArr.length > 0) {
            for (int i = 0; i < oArr.length; ++i) {
                ExtendedProperty property = (ExtendedProperty)oArr[i];
                propMap.put(property.getName(), property.getValue());
            }
        }
        return propMap;
    }

    private Vector createExtendedProperties(LinkedHashMap props) {
        Vector<ExtendedProperty> v = new Vector<ExtendedProperty>();
        if (props == null || props.size() == 0) {
            return v;
        }
        Iterator keys = props.keySet().iterator();
        while (keys.hasNext()) {
            Object oKey = keys.next();
            Object oValue = props.get(oKey);
            String[] sProperty = new String[]{oKey.toString(), oValue.toString()};
            ExtendedProperty property = AttributeFactory.eINSTANCE.createExtendedProperty();
            property.setName(oKey.toString());
            property.setValue(props.get(oKey.toString()).toString());
            property.eAdapters().addAll((Collection)this.chart.eAdapters());
            v.add(property);
        }
        return v;
    }
}

