/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.net.URL;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.impl.ImageImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.IconCanvas;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MarkerIconDialog
implements SelectionListener,
ModifyListener {
    private transient Button btnURL;
    private transient Button btnLocal;
    private transient Button btnPreview;
    private transient Button btnOK;
    private transient Button btnCancel;
    private Composite inputArea;
    private IconCanvas previewCanvas;
    private transient Button btnBrowse;
    private static final int URI_TYPE = 0;
    private static final int LOCAL_TYPE = 1;
    private int selectedType = -1;
    private Text uriEditor;
    private transient Shell shell;
    private transient boolean applyMarkerIcon = false;
    private transient Fill icon = null;

    public MarkerIconDialog(Shell parent, Fill fill) {
        if (fill != null) {
            this.icon = (Fill)EcoreUtil.copy((EObject)fill);
        }
        this.shell = new Shell(parent, 67680);
        this.shell.setLayout((Layout)new GridLayout());
        this.shell.setSize(600, 420);
        UIHelper.centerOnScreen((Shell)this.shell);
        this.createContents(this.shell);
        this.shell.setText(Messages.getString("MarkerIconDialog.Title.MarkerIconSelector"));
        this.shell.layout();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    protected void createContents(Shell shell) {
        Composite cmpContent = new Composite((Composite)shell, 0);
        cmpContent.setLayout((Layout)new GridLayout());
        this.createSelectionArea(cmpContent);
        new Label(cmpContent, 258).setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(cmpContent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createListArea(composite);
        this.createPreviewArea(composite);
        new Label(cmpContent, 258).setLayoutData((Object)new GridData(768));
        Composite btnComposite = new Composite(cmpContent, 0);
        btnComposite.setLayout((Layout)new GridLayout(2, false));
        btnComposite.setLayoutData((Object)new GridData(128));
        this.btnOK = new Button(btnComposite, 0);
        this.btnOK.setLayoutData((Object)new GridData(32));
        this.btnOK.setText(Messages.getString("Shared.Lbl.OK"));
        this.btnOK.addSelectionListener((SelectionListener)this);
        this.btnOK.setEnabled(this.icon != null);
        this.btnCancel = new Button(btnComposite, 0);
        this.btnCancel.setLayoutData((Object)new GridData(128));
        this.btnCancel.setText(Messages.getString("Shared.Lbl.Cancel"));
        this.btnCancel.addSelectionListener((SelectionListener)this);
    }

    private void createSelectionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("MarkerIconDialog.Lbl.SelectIconFrom"));
        label.setLayoutData((Object)new GridData(2));
        Composite selectionArea = new Composite(composite, 0);
        selectionArea.setLayout((Layout)new FillLayout(512));
        this.btnURL = new Button(selectionArea, 16);
        this.btnURL.setText(Messages.getString("MarkerIconDialog.Lbl.URL"));
        this.btnURL.addSelectionListener((SelectionListener)this);
        this.btnLocal = new Button(selectionArea, 16);
        this.btnLocal.setText(Messages.getString("MarkerIconDialog.Lbl.Local"));
        this.btnLocal.addSelectionListener((SelectionListener)this);
    }

    private void createListArea(Composite parent) {
        Composite listArea = new Composite(parent, 0);
        GridData gd = new GridData(1840);
        gd.widthHint = 300;
        gd.heightHint = 260;
        listArea.setLayoutData((Object)gd);
        listArea.setLayout((Layout)new GridLayout());
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.inputArea = new Composite(listArea, 0);
        GridData gdInputArea = new GridData(1840);
        this.inputArea.setLayoutData((Object)gdInputArea);
        this.inputArea.setLayout((Layout)gl);
    }

    private void createPreviewArea(Composite composite) {
        Composite previewArea = new Composite(composite, 2048);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        gd.heightHint = 260;
        previewArea.setLayoutData((Object)gd);
        previewArea.setLayout((Layout)new FillLayout());
        this.previewCanvas = new IconCanvas(previewArea);
    }

    private void switchTo(int type) {
        if (type == this.selectedType) {
            return;
        }
        this.selectedType = type;
        Control[] controls = this.inputArea.getChildren();
        for (int i = 0; i < controls.length; ++i) {
            controls[i].dispose();
        }
        switch (type) {
            case 0: {
                this.swtichToURIType();
                break;
            }
            case 1: {
                this.swtichToLocalType();
            }
        }
        this.inputArea.layout();
        this.updateButton();
    }

    private void swtichToURIType() {
        Label title = new Label(this.inputArea, 0);
        title.setLayoutData((Object)new GridData(2));
        title.setText(Messages.getString("MarkerIconDialog.Lbl.EnterURL"));
        this.uriEditor = new Text(this.inputArea, 2052);
        this.uriEditor.setLayoutData((Object)new GridData(768));
        this.uriEditor.addModifyListener((ModifyListener)this);
        Composite innerComp = new Composite(this.inputArea, 0);
        innerComp.setLayoutData((Object)new GridData(128));
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 2;
        innerComp.setLayout((Layout)gl);
        this.btnPreview = new Button(innerComp, 8);
        this.btnPreview.setText(Messages.getString("MarkerIconDialog.Lbl.Preview"));
        this.btnPreview.setLayoutData((Object)new GridData(128));
        this.btnPreview.setEnabled(false);
        this.btnPreview.addSelectionListener((SelectionListener)this);
        if (this.icon != null) {
            this.uriEditor.setText(((Image)this.icon).getURL());
        }
    }

    private void swtichToLocalType() {
        Composite buttonBar = new Composite(this.inputArea, 0);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        buttonBar.setLayoutData((Object)new GridData(768));
        buttonBar.setLayout((Layout)gl);
        Label description = new Label(buttonBar, 0);
        description.setLayoutData((Object)new GridData(32));
        description.setText(Messages.getString("MarkerIconDialog.Lbl.Description"));
        this.btnBrowse = new Button(buttonBar, 8);
        this.btnBrowse.setText(Messages.getString("MarkerIconDialog.Lbl.Browse"));
        GridData gd = new GridData(128);
        gd.grabExcessHorizontalSpace = true;
        this.btnBrowse.setLayoutData((Object)gd);
        this.btnBrowse.addSelectionListener((SelectionListener)this);
    }

    private void updateButton() {
        this.btnOK.setEnabled(this.icon != null || this.selectedType == 0 && MarkerIconDialog.trimString(this.uriEditor.getText()) != null);
    }

    private void preview(String uri) {
        try {
            this.previewCanvas.loadImage(new URL(uri));
        }
        catch (Exception e) {
            WizardBase.displayException((Throwable)e);
        }
    }

    private void checkIcon() {
        if (!(this.selectedType != 0 || this.icon != null && ((Image)this.icon).getURL().equals(MarkerIconDialog.trimString(this.uriEditor.getText())))) {
            this.icon = ImageImpl.create((String)MarkerIconDialog.trimString(this.uriEditor.getText()));
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget.equals(this.btnOK)) {
            this.checkIcon();
            this.applyMarkerIcon = true;
            this.shell.dispose();
        } else if (e.widget.equals(this.btnCancel)) {
            this.shell.dispose();
        } else if (e.widget.equals(this.btnURL)) {
            this.switchTo(0);
        } else if (e.widget.equals(this.btnLocal)) {
            this.switchTo(1);
        } else if (e.widget.equals(this.btnPreview)) {
            this.uriEditor.setText(this.uriEditor.getText().trim());
            String path = this.uriEditor.getText();
            this.preview(path);
        } else if (e.widget.equals(this.btnBrowse)) {
            FileDialog fileChooser = new FileDialog(this.shell, 4096);
            fileChooser.setText(Messages.getString("MarkerIconDialog.Chooser.Title"));
            fileChooser.setFilterExtensions(new String[]{"*.gif", "*.jpg", "*.png"});
            try {
                String path = fileChooser.open();
                if (path != null) {
                    path = "file:///" + path;
                    this.preview(path);
                    this.icon = ImageImpl.create((String)path);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            this.updateButton();
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget.equals(this.uriEditor)) {
            this.btnPreview.setEnabled(MarkerIconDialog.trimString(this.uriEditor.getText()) != null);
            this.updateButton();
        }
    }

    private static String trimString(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        return value;
    }

    public boolean applyMarkerIcon() {
        return this.applyMarkerIcon;
    }

    public Fill getFill() {
        return this.icon;
    }
}

