/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class LineSeriesAttributeComposite
extends Composite
implements SelectionListener,
Listener {
    private transient Button btnCurve = null;
    private transient Button btnMissingValue = null;
    private transient Button btnPalette = null;
    private transient Label lblShadow;
    private transient FillChooserComposite fccShadow = null;
    private transient Group grpLine = null;
    private transient LineAttributesComposite liacLine = null;
    private transient Series series = null;
    private transient ChartWizardContext context;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.series");

    public LineSeriesAttributeComposite(Composite parent, int style, ChartWizardContext context, Series series) {
        super(parent, style);
        if (!(series instanceof LineSeriesImpl)) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 20, "LineSeriesAttributeComposite.Exception.IllegalArgument", new Object[]{series.getClass().getName()}, Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.series = series;
        this.context = context;
        this.init();
        this.placeComponents();
        ChartUIUtil.bindHelp((Control)parent, (String)this.getHelpId(series));
    }

    private String getHelpId(Series series) {
        String helpId = "org.eclipse.birt.chart.cshelp.FormatLineChartYSeries_ID";
        if (series instanceof AreaSeries) {
            helpId = "org.eclipse.birt.chart.cshelp.FormatAreaChartYSeries_ID";
        } else if (series instanceof ScatterSeries) {
            helpId = "org.eclipse.birt.chart.cshelp.FormatScatterChartYSeries_ID";
        }
        return helpId;
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout(3, false);
        glContent.marginHeight = 2;
        glContent.marginWidth = 2;
        this.setLayout((Layout)glContent);
        this.grpLine = new Group((Composite)this, 0);
        GridData gdGRPLine = new GridData(1808);
        gdGRPLine.verticalSpan = 5;
        this.grpLine.setLayout((Layout)new FillLayout());
        this.grpLine.setLayoutData((Object)gdGRPLine);
        this.grpLine.setText(Messages.getString("LineSeriesAttributeComposite.Lbl.Line"));
        this.liacLine = new LineAttributesComposite((Composite)this.grpLine, 0, this.context, ((LineSeries)this.series).getLineAttributes(), true, true, true);
        this.liacLine.addListener(this);
        if (this.isShadowNeeded()) {
            this.lblShadow = new Label((Composite)this, 0);
            GridData gdLBLShadow = new GridData();
            this.lblShadow.setLayoutData((Object)gdLBLShadow);
            this.lblShadow.setText(Messages.getString("LineSeriesAttributeComposite.Lbl.ShadowColor"));
            this.fccShadow = new FillChooserComposite(this, 0, this.context, (Fill)((LineSeries)this.series).getShadowColor(), false, false);
            GridData gdFCCShadow = new GridData(768);
            this.fccShadow.setLayoutData(gdFCCShadow);
            this.fccShadow.addListener(this);
        }
        this.btnPalette = new Button((Composite)this, 32);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.btnPalette.setLayoutData((Object)gd);
        this.btnPalette.setText(Messages.getString("LineSeriesAttributeComposite.Lbl.LinePalette"));
        this.btnPalette.setSelection(((LineSeries)this.series).isPaletteLineColor());
        this.btnPalette.addSelectionListener((SelectionListener)this);
        this.btnCurve = new Button((Composite)this, 32);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.btnCurve.setLayoutData((Object)gd);
        this.btnCurve.setText(Messages.getString("LineSeriesAttributeComposite.Lbl.ShowLinesAsCurves"));
        this.btnCurve.setSelection(((LineSeries)this.series).isCurve());
        this.btnCurve.addSelectionListener((SelectionListener)this);
        if (!(this.series instanceof AreaSeries) && !(this.series instanceof ScatterSeries)) {
            this.btnMissingValue = new Button((Composite)this, 32);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.btnMissingValue.setLayoutData((Object)gd);
            this.btnMissingValue.setText(Messages.getString("LineSeriesAttributeComposite.Lbl.ConnectMissingValue"));
            this.btnMissingValue.setSelection(((LineSeries)this.series).isConnectMissingValue());
            this.btnMissingValue.addSelectionListener((SelectionListener)this);
        }
        this.enableLineSettings(((LineSeries)this.series).getLineAttributes().isVisible());
    }

    public Point getPreferredSize() {
        return new Point(400, 200);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnCurve)) {
            ((LineSeries)this.series).setCurve(this.btnCurve.getSelection());
        } else if (e.getSource().equals(this.btnPalette)) {
            ((LineSeries)this.series).setPaletteLineColor(this.btnPalette.getSelection());
        } else if (e.getSource().equals(this.btnMissingValue)) {
            ((LineSeries)this.series).setConnectMissingValue(this.btnMissingValue.getSelection());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.liacLine)) {
            if (event.type == 4) {
                ((LineSeries)this.series).getLineAttributes().setVisible(((Boolean)event.data).booleanValue());
                this.enableLineSettings(((LineSeries)this.series).getLineAttributes().isVisible());
            } else if (event.type == 1) {
                ((LineSeries)this.series).getLineAttributes().setStyle((LineStyle)event.data);
            } else if (event.type == 2) {
                ((LineSeries)this.series).getLineAttributes().setThickness(((Integer)event.data).intValue());
            } else if (event.type == 3) {
                ((LineSeries)this.series).getLineAttributes().setColor((ColorDefinition)event.data);
            }
        } else if (event.widget.equals((Object)this.fccShadow)) {
            ((LineSeries)this.series).setShadowColor((ColorDefinition)event.data);
        }
    }

    private boolean isShadowNeeded() {
        return !(this.series instanceof AreaSeries) && this.context.getModel().getDimension().getValue() != 2;
    }

    private void enableLineSettings(boolean isEnabled) {
        if (this.lblShadow != null) {
            this.lblShadow.setEnabled(isEnabled);
        }
        if (this.fccShadow != null) {
            this.fccShadow.setEnabled(isEnabled);
        }
        if (this.btnPalette != null) {
            this.btnPalette.setEnabled(isEnabled);
        }
        if (this.btnMissingValue != null) {
            this.btnMissingValue.setEnabled(isEnabled);
        }
        this.btnCurve.setEnabled(isEnabled);
    }
}

