/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.IChangeWithoutNotification;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskChangeListener;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartUIExtensionsImpl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.internal.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.ui.frameworks.taskwizard.SimpleTask;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IWizardContext;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TaskSelectType
extends SimpleTask
implements SelectionListener,
ITaskChangeListener {
    private transient Chart chartModel = null;
    private transient Composite cmpPreview = null;
    private transient Composite cmpType = null;
    private transient Composite cmpMisc = null;
    private transient Composite cmpTypeButtons = null;
    private transient Composite cmpSubTypes = null;
    private transient Canvas previewCanvas = null;
    private transient ChartPreviewPainter previewPainter = null;
    private transient LinkedHashMap htTypes = null;
    private transient RowData rowData = new RowData(80, 80);
    private transient String sSubType = null;
    private transient String sType = null;
    private transient String sDimension = null;
    private transient Table table = null;
    private transient Vector vSubTypeNames = null;
    private transient Orientation orientation = Orientation.VERTICAL_LITERAL;
    private transient Label lblOrientation = null;
    private transient Button cbOrientation = null;
    private transient Label lblMultipleY = null;
    private transient Combo cbMultipleY = null;
    private transient Label lblSeriesType = null;
    private transient Combo cbSeriesType = null;
    private transient Label lblDimension = null;
    private transient Combo cbDimension = null;
    private transient Label lblOutput = null;
    private transient Combo cbOutput = null;
    private static final String LEADING_BLANKS = "  ";
    private static Hashtable htSeriesNames = null;

    public TaskSelectType() {
        super(Messages.getString("TaskSelectType.TaskExp"));
        this.setDescription(Messages.getString("TaskSelectType.Task.Description"));
        if (this.chartModel != null) {
            this.sType = this.chartModel.getType();
            this.sSubType = this.chartModel.getSubType();
            this.sDimension = this.translateDimensionString(this.chartModel.getDimension().getName());
            if (this.chartModel instanceof ChartWithAxes) {
                this.orientation = ((ChartWithAxes)this.chartModel).getOrientation();
            }
        }
        this.htTypes = new LinkedHashMap();
    }

    public void createControl(Composite parent) {
        if (this.topControl == null || this.topControl.isDisposed()) {
            this.topControl = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 100;
            this.topControl.setLayout((Layout)gridLayout);
            this.topControl.setLayoutData((Object)new GridData(1536));
            if (this.context != null) {
                this.chartModel = ((ChartWizardContext)this.context).getModel();
            }
            this.placeComponents();
            this.updateAdapters();
        }
        if (((ChartWizardContext)this.getContext()).isMoreAxesSupported()) {
            this.updateDimensionCombo(this.sType);
            this.createAndDisplayTypesSheet(this.sType);
            this.setDefaultSubtypeSelection();
            this.cmpMisc.layout();
        }
        this.doLivePreview();
        ChartUIUtil.bindHelp((Control)this.getControl(), (String)"org.eclipse.birt.chart.cshelp.SelectChartType_ID");
    }

    private void placeComponents() {
        this.createPreviewArea();
        this.createTypeArea();
        this.createMiscArea();
        this.setDefaultTypeSelection();
        this.refreshChart();
        this.populateSeriesTypesList();
        this.createChartPainter();
    }

    private void createChartPainter() {
        this.previewPainter = new ChartPreviewPainter((ChartWizardContext)this.getContext());
        this.previewCanvas.addPaintListener((PaintListener)this.previewPainter);
        this.previewCanvas.addControlListener((ControlListener)this.previewPainter);
        this.previewPainter.setPreview(this.previewCanvas);
    }

    private void createPreviewArea() {
        this.cmpPreview = new Composite(this.topControl, 0);
        this.cmpPreview.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.heightHint = 250;
        this.cmpPreview.setLayoutData((Object)gridData);
        Label label = new Label(this.cmpPreview, 0);
        label.setText(Messages.getString("TaskSelectType.Label.Preview"));
        label.setFont(JFaceResources.getBannerFont());
        this.previewCanvas = new Canvas(this.cmpPreview, 2048);
        this.previewCanvas.setLayoutData((Object)new GridData(1808));
        this.previewCanvas.setBackground(Display.getDefault().getSystemColor(1));
    }

    private void createTypeArea() {
        this.cmpType = new Composite(this.topControl, 0);
        this.cmpType.setLayout((Layout)new GridLayout(2, false));
        this.cmpType.setLayoutData((Object)new GridData(768));
        this.createHeader();
        this.createTable();
        this.addChartTypes();
        this.createComposite(new Vector());
    }

    private void createMiscArea() {
        this.cmpMisc = new Composite(this.topControl, 0);
        this.cmpMisc.setLayout((Layout)new GridLayout(4, false));
        this.cmpMisc.setLayoutData((Object)new GridData(768));
        GridData gridData = null;
        this.lblDimension = new Label(this.cmpMisc, 0);
        this.lblDimension.setText(Messages.getString("TaskSelectType.Label.Dimension"));
        this.cbDimension = new Combo(this.cmpMisc, 12);
        gridData = new GridData(512);
        this.cbDimension.setLayoutData((Object)gridData);
        this.cbDimension.addSelectionListener((SelectionListener)this);
        this.lblOutput = new Label(this.cmpMisc, 0);
        gridData = new GridData();
        gridData.horizontalIndent = 50;
        this.lblOutput.setLayoutData((Object)gridData);
        this.lblOutput.setText(Messages.getString("TaskSelectType.Label.OutputFormat"));
        this.cbOutput = new Combo(this.cmpMisc, 12);
        gridData = new GridData(512);
        this.cbOutput.setLayoutData((Object)gridData);
        this.cbOutput.addSelectionListener((SelectionListener)this);
        this.lblMultipleY = new Label(this.cmpMisc, 0);
        this.lblMultipleY.setText(Messages.getString("TaskSelectType.Label.MultipleYAxis"));
        this.cbMultipleY = new Combo(this.cmpMisc, 12);
        this.cbMultipleY.setItems(new String[]{Messages.getString("TaskSelectType.Selection.None"), Messages.getString("TaskSelectType.Selection.SecondaryAxis"), Messages.getString("TaskSelectType.Selection.MoreAxes")});
        this.cbMultipleY.addSelectionListener((SelectionListener)this);
        int axisNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)this.chartModel);
        this.selectMultipleAxis(axisNum);
        this.lblSeriesType = new Label(this.cmpMisc, 0);
        gridData = new GridData();
        gridData.horizontalIndent = 50;
        this.lblSeriesType.setLayoutData((Object)gridData);
        this.lblSeriesType.setText(Messages.getString("TaskSelectType.Label.SeriesType"));
        this.lblSeriesType.setEnabled(false);
        this.cbSeriesType = new Combo(this.cmpMisc, 12);
        GridData gd = new GridData(512);
        this.cbSeriesType.setLayoutData((Object)gd);
        this.cbSeriesType.setEnabled(false);
        this.cbSeriesType.addSelectionListener((SelectionListener)this);
        this.lblOrientation = new Label(this.cmpMisc, 0);
        this.lblOrientation.setText(Messages.getString("TaskSelectType.Label.Oritention"));
        this.cbOrientation = new Button(this.cmpMisc, 32);
        this.cbOrientation.setText(Messages.getString("TaskSelectType.Label.FlipAxis"));
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.cbOrientation.setLayoutData((Object)gridData);
        this.cbOrientation.addSelectionListener((SelectionListener)this);
        this.populateLists();
    }

    private void createHeader() {
        Label lblTypes = new Label(this.cmpType, 524288);
        lblTypes.setText(Messages.getString("TaskSelectType.Label.SelectChartType"));
        Label lblSubtypes = new Label(this.cmpType, 524288);
        lblSubtypes.setText(Messages.getString("TaskSelectType.Label.SelectSubtype"));
        GridData gd = new GridData(768);
        gd.horizontalIndent = 5;
        lblSubtypes.setLayoutData((Object)gd);
    }

    private void createTable() {
        this.table = new Table(this.cmpType, 2048);
        GridData gdTable = new GridData(2);
        gdTable.heightHint = 120;
        this.table.setLayoutData((Object)gdTable);
        this.table.setToolTipText(Messages.getString("TaskSelectType.Label.ChartTypes"));
        this.table.addSelectionListener((SelectionListener)this);
    }

    private void addChartTypes() {
        this.populateTypesTable();
        this.updateUI();
    }

    private void populateTypesTable() {
        Collection cTypes = ChartUIExtensionsImpl.instance().getUIChartTypeExtensions();
        Iterator iterTypes = cTypes.iterator();
        while (iterTypes.hasNext()) {
            IChartType type = (IChartType)iterTypes.next();
            this.htTypes.put(type.getName(), type);
        }
    }

    private void updateUI() {
        Iterator iter = this.htTypes.keySet().iterator();
        while (iter.hasNext()) {
            String sTypeTmp = (String)iter.next();
            TableItem tItem = new TableItem(this.table, 0);
            tItem.setText(LEADING_BLANKS + ((IChartType)this.htTypes.get(sTypeTmp)).getDisplayName());
            tItem.setData((Object)((IChartType)this.htTypes.get(sTypeTmp)).getName());
            tItem.setImage(((IChartType)this.htTypes.get(sTypeTmp)).getImage());
        }
    }

    private void createComposite(Vector vSubTypes) {
        GridData gdTypes = new GridData(784);
        this.cmpSubTypes = new Composite(this.cmpType, 0);
        this.createGroups(vSubTypes);
        this.cmpSubTypes.setLayoutData((Object)gdTypes);
        this.cmpSubTypes.setToolTipText(Messages.getString("TaskSelectType.Label.ChartSubtypes"));
        this.cmpSubTypes.setLayout((Layout)new GridLayout());
        this.cmpSubTypes.setVisible(true);
    }

    private void createGroups(Vector vSubTypes) {
        this.vSubTypeNames = new Vector();
        if (this.cmpTypeButtons != null && !this.cmpTypeButtons.isDisposed()) {
            this.cmpTypeButtons.dispose();
        }
        this.cmpTypeButtons = new Composite(this.cmpSubTypes, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginBottom = 12;
        rowLayout.marginRight = 12;
        rowLayout.spacing = 4;
        this.cmpTypeButtons.setLayout((Layout)rowLayout);
        for (int iC = 0; iC < vSubTypes.size(); ++iC) {
            IChartSubType subType = (IChartSubType)vSubTypes.get(iC);
            this.vSubTypeNames.add(subType.getName());
            Button btnType = new Button(this.cmpTypeButtons, 2);
            btnType.setData((Object)subType.getName());
            btnType.setImage(subType.getImage());
            btnType.setLayoutData((Object)this.rowData);
            btnType.addSelectionListener((SelectionListener)this);
            btnType.setToolTipText(subType.getDescription());
            btnType.getImage().setBackground(btnType.getBackground());
            btnType.setVisible(true);
            this.cmpTypeButtons.layout(true);
        }
        this.cmpTypeButtons.setLayoutData((Object)new GridData(1808));
        this.cmpSubTypes.layout(true);
    }

    private void populateLists() {
        if ("Horizontal".equals(this.orientation)) {
            this.cbOrientation.setSelection(true);
        } else {
            this.cbOrientation.setSelection(false);
        }
        this.cbOutput.setItems(this.getOutputFormats());
        String sCurrentFormat = ((ChartWizardContext)this.getContext()).getOutputFormat();
        int index = this.cbOutput.indexOf(sCurrentFormat);
        if (index == -1) {
            index = this.cbOutput.indexOf(((ChartWizardContext)this.getContext()).getDefaultOutputFormat());
        }
        this.cbOutput.select(index);
    }

    private String[] getOutputFormats() {
        try {
            String[][] outputFormatArray = PluginSettings.instance().getRegisteredOutputFormats();
            String[] formats = new String[outputFormatArray.length];
            for (int i = 0; i < formats.length; ++i) {
                formats[i] = outputFormatArray[i][0];
            }
            return formats;
        }
        catch (ChartException e) {
            ChartWizard.displayException((Throwable)e);
            return new String[0];
        }
    }

    private void populateSeriesTypes(String[] allSeriesTypes, Series series) throws ChartException {
        for (int i = 0; i < allSeriesTypes.length; ++i) {
            try {
                Class<?> seriesClass = Class.forName(allSeriesTypes[i]);
                Method createMethod = seriesClass.getDeclaredMethod("create", new Class[0]);
                Series newSeries = (Series)createMethod.invoke(seriesClass, new Object[0]);
                if (htSeriesNames == null) {
                    htSeriesNames = new Hashtable(20);
                }
                String sDisplayName = PluginSettings.instance().getSeriesDisplayName(allSeriesTypes[i]);
                htSeriesNames.put(sDisplayName, allSeriesTypes[i]);
                if (!newSeries.canParticipateInCombination()) continue;
                this.cbSeriesType.add(sDisplayName);
                if (!allSeriesTypes[i].equals(series.getClass().getName())) continue;
                this.cbSeriesType.select(this.cbSeriesType.getItemCount() - 1);
                continue;
            }
            catch (Exception e) {
                ChartWizard.displayException((Throwable)e);
            }
        }
    }

    private String translateDimensionString(String sDimensionValue) {
        String dimensionName = "";
        if (sDimensionValue.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            dimensionName = IChartType.TWO_DIMENSION_TYPE;
        } else if (sDimensionValue.equals(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL.getName())) {
            dimensionName = IChartType.TWO_DIMENSION_WITH_DEPTH_TYPE;
        } else if (sDimensionValue.equals(ChartDimension.THREE_DIMENSIONAL_LITERAL.getName())) {
            dimensionName = IChartType.THREE_DIMENSION_TYPE;
        }
        return dimensionName;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        boolean needUpdateModel = false;
        Object oSelected = e.getSource();
        if (oSelected.getClass().equals(Button.class)) {
            needUpdateModel = true;
            if (oSelected.equals(this.cbOrientation)) {
                this.orientation = this.cbOrientation.getSelection() ? Orientation.HORIZONTAL_LITERAL : Orientation.VERTICAL_LITERAL;
                this.createAndDisplayTypesSheet(this.sType);
                this.setDefaultSubtypeSelection();
            } else {
                Button btn = (Button)e.getSource();
                if (btn.getSelection()) {
                    int iTypeIndex;
                    if (this.sSubType != null && !this.getSubtypeFromButton((Control)btn).equals(this.sSubType) && (iTypeIndex = this.vSubTypeNames.indexOf(this.sSubType)) >= 0) {
                        ((Button)this.cmpTypeButtons.getChildren()[iTypeIndex]).setSelection(false);
                        this.cmpTypeButtons.redraw();
                    }
                    this.sSubType = this.getSubtypeFromButton((Control)btn);
                    ChartCacheManager.getInstance().cacheSubtype(this.sType, this.sSubType);
                } else if (this.sSubType != null && this.getSubtypeFromButton((Control)btn).equals(this.sSubType)) {
                    btn.setSelection(true);
                    needUpdateModel = false;
                }
            }
        } else if (oSelected.getClass().equals(Table.class)) {
            this.sType = ((String)((TableItem)e.item).getData()).trim();
            if (!this.chartModel.getType().equals(this.sType)) {
                this.sSubType = null;
                this.createAndDisplayTypesSheet(this.sType);
                this.setDefaultSubtypeSelection();
                this.container.packWizard();
                this.cmpMisc.layout();
                needUpdateModel = true;
            }
        } else if (oSelected.equals(this.cbMultipleY)) {
            needUpdateModel = true;
            this.lblSeriesType.setEnabled(this.isTwoAxesEnabled());
            this.cbSeriesType.setEnabled(this.isTwoAxesEnabled());
            ((ChartWizardContext)this.getContext()).setMoreAxesSupported(this.cbMultipleY.getSelectionIndex() == 2);
            if (this.chartModel instanceof ChartWithoutAxes) {
                throw new IllegalArgumentException(Messages.getString("TaskSelectType.Exception.CannotSupportAxes"));
            }
            ChartAdapter.changeChartWithoutNotification((IChangeWithoutNotification)new IChangeWithoutNotification(){

                public Object run() {
                    int iAxisNumber = ChartUIUtil.getOrthogonalAxisNumber((Chart)TaskSelectType.this.chartModel);
                    if (TaskSelectType.this.cbMultipleY.getSelectionIndex() == 0) {
                        if (iAxisNumber > 1) {
                            ChartUIUtil.removeLastAxes((ChartWithAxes)((ChartWithAxes)TaskSelectType.this.chartModel), (int)(iAxisNumber - 1));
                        }
                    } else if (TaskSelectType.this.cbMultipleY.getSelectionIndex() == 1) {
                        if (iAxisNumber == 1) {
                            ChartUIUtil.addAxis((ChartWithAxes)((ChartWithAxes)TaskSelectType.this.chartModel));
                        } else if (iAxisNumber > 2) {
                            ChartUIUtil.removeLastAxes((ChartWithAxes)((ChartWithAxes)TaskSelectType.this.chartModel), (int)(iAxisNumber - 2));
                        }
                    }
                    return null;
                }
            });
            if (this.updateDimensionCombo(this.sType)) {
                this.createAndDisplayTypesSheet(this.sType);
                this.setDefaultSubtypeSelection();
            }
            this.cmpMisc.layout();
        } else if (oSelected.equals(this.cbDimension)) {
            String newDimension = this.cbDimension.getItem(this.cbDimension.getSelectionIndex());
            if (!newDimension.equals(this.sDimension)) {
                this.sDimension = newDimension;
                this.createAndDisplayTypesSheet(this.sType);
                this.setDefaultSubtypeSelection();
                needUpdateModel = true;
            }
        } else if (oSelected.equals(this.cbSeriesType)) {
            String oldSeriesName = ((SeriesDefinition)ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)this.chartModel, (int)1).get(0)).getDesignTimeSeries().getDisplayName();
            if (!this.cbSeriesType.getText().equals(oldSeriesName)) {
                needUpdateModel = true;
                this.changeOverlaySeriesType();
            }
        } else if (oSelected.equals(this.cbOutput)) {
            ((ChartWizardContext)this.getContext()).setOutputFormat(this.cbOutput.getText());
        }
        if (needUpdateModel) {
            this.refreshChart();
            if (oSelected.getClass().equals(Table.class)) {
                this.populateSeriesTypesList();
            } else if (oSelected.equals(this.cbMultipleY) && this.isTwoAxesEnabled() && this.chartModel != null && this.chartModel instanceof ChartWithAxes && ChartUIUtil.getOrthogonalAxisNumber((Chart)this.chartModel) > 1) {
                Axis overlayAxis = ChartUIUtil.getAxisYForProcessing((ChartWithAxes)((ChartWithAxes)this.chartModel), (int)1);
                String sDisplayName = PluginSettings.instance().getSeriesDisplayName(((SeriesDefinition)overlayAxis.getSeriesDefinitions().get(0)).getDesignTimeSeries().getClass().getName());
                this.cbSeriesType.select(this.cbSeriesType.indexOf(sDisplayName));
            }
        }
    }

    private boolean updateDimensionCombo(String sSelectedType) {
        boolean isOldExist = false;
        IChartType chartType = (IChartType)this.htTypes.get(sSelectedType);
        String[] dimensionArray = chartType.getSupportedDimensions();
        int axesNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)this.chartModel);
        if (this.sDimension == null) {
            this.sDimension = chartType.getDefaultDimension();
            isOldExist = true;
        }
        this.cbDimension.removeAll();
        for (int i = 0; i < dimensionArray.length; ++i) {
            boolean isSupported = chartType.isDimensionSupported(dimensionArray[i], axesNum, 0);
            if (isSupported) {
                this.cbDimension.add(dimensionArray[i]);
            }
            if (isOldExist || !this.sDimension.equals(dimensionArray[i])) continue;
            isOldExist = isSupported;
        }
        if (!isOldExist) {
            this.sDimension = chartType.getDefaultDimension();
        }
        this.cbDimension.setText(this.sDimension);
        return !isOldExist;
    }

    private boolean isTwoAxesEnabled() {
        return this.cbMultipleY.getSelectionIndex() == 1;
    }

    private void updateAdapters() {
        EContentAdapter adapter = ((ChartWizard)this.container).getAdapter();
        this.chartModel.eAdapters().remove((Object)adapter);
        TreeIterator iterator = this.chartModel.eAllContents();
        while (iterator.hasNext()) {
            Object oModel = iterator.next();
            if (!(oModel instanceof EObject)) continue;
            ((EObject)oModel).eAdapters().remove((Object)adapter);
        }
        this.chartModel.eAdapters().add((Object)adapter);
    }

    private boolean is3D() {
        return IChartType.THREE_DIMENSION_TYPE.equals(this.sDimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeOverlaySeriesType() {
        try {
            Class<?> seriesClass = Class.forName(htSeriesNames.get(this.cbSeriesType.getText()).toString());
            Method createMethod = seriesClass.getDeclaredMethod("create", new Class[0]);
            Axis XAxis = (Axis)((ChartWithAxes)this.chartModel).getAxes().get(0);
            int iSeriesDefinitionIndex = 0 + ((Axis)XAxis.getAssociatedAxes().get(0)).getSeriesDefinitions().size();
            int iOverlaySeriesCount = ((Axis)XAxis.getAssociatedAxes().get(1)).getSeriesDefinitions().size();
            ChartAdapter.ignoreNotifications((boolean)true);
            for (int i = 0; i < iOverlaySeriesCount; ++i) {
                Series newSeries = (Series)createMethod.invoke(seriesClass, new Object[0]);
                newSeries.translateFrom(((SeriesDefinition)((Axis)XAxis.getAssociatedAxes().get(1)).getSeriesDefinitions().get(i)).getDesignTimeSeries(), iSeriesDefinitionIndex, this.chartModel);
                newSeries.eAdapters().addAll((Collection)this.chartModel.eAdapters());
                ((SeriesDefinition)((Axis)XAxis.getAssociatedAxes().get(1)).getSeriesDefinitions().get(i)).getSeries().clear();
                ((SeriesDefinition)((Axis)XAxis.getAssociatedAxes().get(1)).getSeriesDefinitions().get(i)).getSeries().add((Object)newSeries);
            }
        }
        catch (Exception e) {
            ChartWizard.displayException((Throwable)e);
        }
        finally {
            ChartAdapter.ignoreNotifications((boolean)true);
        }
    }

    private void populateSeriesTypesList() {
        this.cbSeriesType.removeAll();
        Series series = this.getSeriesDefinitionForProcessing().getDesignTimeSeries();
        if (series.canParticipateInCombination()) {
            try {
                this.populateSeriesTypes(PluginSettings.instance().getRegisteredSeries(), series);
            }
            catch (ChartException e) {
                ChartWizard.displayException((Throwable)e);
            }
        } else {
            String seriesName = PluginSettings.instance().getSeriesDisplayName(series.getClass().getName());
            this.cbSeriesType.add(seriesName);
            this.cbSeriesType.select(0);
        }
        if (this.chartModel != null && this.chartModel instanceof ChartWithAxes) {
            Axis xAxis = (Axis)((ChartWithAxes)this.chartModel).getAxes().get(0);
            if (xAxis.getAssociatedAxes().size() > 1) {
                Axis overlayAxis = (Axis)xAxis.getAssociatedAxes().get(1);
                String sDisplayName = PluginSettings.instance().getSeriesDisplayName(((SeriesDefinition)overlayAxis.getSeriesDefinitions().get(0)).getDesignTimeSeries().getClass().getName());
                this.cbSeriesType.setText(sDisplayName);
            } else {
                this.cbSeriesType.select(0);
            }
        }
    }

    private void createAndDisplayTypesSheet(String sSelectedType) {
        IChartType chartType = (IChartType)this.htTypes.get(sSelectedType);
        this.lblOrientation.setEnabled(chartType.supportsTransposition() && !this.is3D());
        this.cbOrientation.setEnabled(chartType.supportsTransposition() && !this.is3D());
        this.updateDimensionCombo(sSelectedType);
        Vector vSubTypes = null;
        if (this.sDimension != null && this.orientation != null) {
            vSubTypes = new Vector(chartType.getChartSubtypes(this.sDimension, this.orientation));
        }
        if (vSubTypes == null || vSubTypes.size() == 0) {
            vSubTypes = new Vector(chartType.getChartSubtypes(chartType.getDefaultDimension(), Orientation.VERTICAL_LITERAL));
            this.sDimension = chartType.getDefaultDimension();
            this.orientation = Orientation.VERTICAL_LITERAL;
        }
        Orientation orientationTmp = this.orientation;
        this.createGroups(vSubTypes);
        if (orientationTmp == Orientation.HORIZONTAL_LITERAL) {
            this.cbOrientation.setSelection(true);
        } else {
            this.cbOrientation.setSelection(false);
        }
        this.cmpType.layout();
    }

    private void setDefaultSubtypeSelection() {
        if (this.sSubType == null) {
            this.sSubType = ChartCacheManager.getInstance().findSubtype(this.sType);
        }
        if (this.sSubType == null) {
            ((Button)this.cmpTypeButtons.getChildren()[0]).setSelection(true);
            this.sSubType = this.getSubtypeFromButton(this.cmpTypeButtons.getChildren()[0]);
            ChartCacheManager.getInstance().cacheSubtype(this.sType, this.sSubType);
        } else {
            Control[] buttons = this.cmpTypeButtons.getChildren();
            boolean bSelected = false;
            for (int iB = 0; iB < buttons.length; ++iB) {
                if (!this.getSubtypeFromButton(buttons[iB]).equals(this.sSubType)) continue;
                ((Button)buttons[iB]).setSelection(true);
                bSelected = true;
                break;
            }
            if (!bSelected) {
                ((Button)this.cmpTypeButtons.getChildren()[0]).setSelection(true);
                this.sSubType = this.getSubtypeFromButton(this.cmpTypeButtons.getChildren()[0]);
                ChartCacheManager.getInstance().cacheSubtype(this.sType, this.sSubType);
            }
        }
        this.cmpTypeButtons.redraw();
    }

    private void setDefaultTypeSelection() {
        if (this.table.getItems().length > 0) {
            if (this.sType == null) {
                this.table.select(0);
                this.sType = (String)this.table.getSelection()[0].getData();
            } else {
                TableItem[] tiAll = this.table.getItems();
                for (int iTI = 0; iTI < tiAll.length; ++iTI) {
                    if (!tiAll[iTI].getData().equals(this.sType)) continue;
                    this.table.select(iTI);
                    break;
                }
            }
            this.createAndDisplayTypesSheet(this.sType);
            this.setDefaultSubtypeSelection();
        }
    }

    public void dispose() {
        super.dispose();
        this.chartModel = null;
        if (this.previewPainter != null) {
            this.previewPainter.dispose();
        }
        this.previewPainter = null;
        this.sSubType = null;
        this.sType = null;
        this.sDimension = null;
        this.vSubTypeNames = null;
        this.orientation = Orientation.VERTICAL_LITERAL;
    }

    private void refreshChart() {
        ChartAdapter.ignoreNotifications((boolean)true);
        IChartType chartType = (IChartType)this.htTypes.get(this.sType);
        try {
            this.chartModel = chartType.getModel(this.sSubType, this.orientation, this.sDimension, this.chartModel);
            this.updateAdapters();
        }
        catch (Exception e) {
            ChartWizard.displayException((Throwable)e);
        }
        ChartAdapter.ignoreNotifications((boolean)false);
        this.updateSelection();
        if (this.context == null) {
            this.context = new ChartWizardContext(this.chartModel);
        } else {
            ((ChartWizardContext)this.context).setModel(this.chartModel);
        }
        ((ChartWizardContext)this.context).setChartType(chartType);
        this.setContext(this.context);
        this.doLivePreview();
    }

    private SeriesDefinition getSeriesDefinitionForProcessing() {
        SeriesDefinition sd = null;
        if (this.chartModel instanceof ChartWithAxes) {
            sd = (SeriesDefinition)((Axis)((Axis)((ChartWithAxes)this.chartModel).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().get(0);
        } else if (this.chartModel instanceof ChartWithoutAxes) {
            sd = (SeriesDefinition)((SeriesDefinition)((ChartWithoutAxes)this.chartModel).getSeriesDefinitions().get(0)).getSeriesDefinitions().get(0);
        }
        return sd;
    }

    private void updateSelection() {
        if (this.chartModel instanceof ChartWithAxes) {
            this.lblMultipleY.setEnabled(!this.is3D());
            this.cbMultipleY.setEnabled(!this.is3D());
            this.lblSeriesType.setEnabled(this.isTwoAxesEnabled());
            this.cbSeriesType.setEnabled(this.isTwoAxesEnabled());
        } else {
            this.cbMultipleY.select(0);
            ((ChartWizardContext)this.getContext()).setMoreAxesSupported(false);
            this.lblMultipleY.setEnabled(false);
            this.cbMultipleY.setEnabled(false);
            this.lblSeriesType.setEnabled(false);
            this.cbSeriesType.setEnabled(false);
        }
    }

    public IWizardContext getContext() {
        ChartWizardContext context = (ChartWizardContext)super.getContext();
        if (context == null) {
            context = new ChartWizardContext(this.chartModel);
        } else {
            context.setModel(this.chartModel);
        }
        return context;
    }

    public void setContext(IWizardContext context) {
        super.setContext(context);
        this.chartModel = ((ChartWizardContext)context).getModel();
        if (this.chartModel != null) {
            this.sType = this.chartModel.getType();
            this.sSubType = this.chartModel.getSubType();
            this.sDimension = this.translateDimensionString(this.chartModel.getDimension().getName());
            if (this.chartModel instanceof ChartWithAxes) {
                this.orientation = ((ChartWithAxes)this.chartModel).getOrientation();
                int iYAxesCount = ChartUIUtil.getOrthogonalAxisNumber((Chart)this.chartModel);
                if (iYAxesCount > 1 && this.lblMultipleY != null && !this.lblMultipleY.isDisposed()) {
                    this.lblMultipleY.setEnabled(!this.is3D());
                    this.cbMultipleY.setEnabled(!this.is3D());
                    this.lblSeriesType.setEnabled(!this.is3D() && this.isTwoAxesEnabled());
                    this.cbSeriesType.setEnabled(!this.is3D() && this.isTwoAxesEnabled());
                    this.selectMultipleAxis(iYAxesCount);
                }
            }
        }
    }

    private void selectMultipleAxis(int yAxisNum) {
        if (((ChartWizardContext)this.getContext()).isMoreAxesSupported()) {
            this.cbMultipleY.select(2);
        } else if (yAxisNum > 2) {
            this.cbMultipleY.select(2);
            ((ChartWizardContext)this.getContext()).setMoreAxesSupported(true);
        } else {
            this.cbMultipleY.select(yAxisNum > 0 ? yAxisNum - 1 : 0);
        }
    }

    public void changeTask(Notification notification) {
        if (this.previewPainter != null) {
            this.previewPainter.renderModel(this.chartModel);
        }
    }

    protected IDataServiceProvider getDataServiceProvider() {
        return ((ChartWizardContext)this.getContext()).getDataServiceProvider();
    }

    private boolean hasDataSet() {
        return this.getDataServiceProvider().getReportDataSet() != null || this.getDataServiceProvider().getBoundDataSet() != null;
    }

    private void doLivePreview() {
        if (this.getDataServiceProvider().isLivePreviewEnabled() && ChartUIUtil.checkDataBinding((Chart)this.chartModel) && this.hasDataSet()) {
            ChartPreviewPainter.activateLivePreview(true);
            ChartAdapter.ignoreNotifications((boolean)true);
            try {
                ChartUIUtil.doLivePreview((Chart)this.chartModel, (IDataServiceProvider)this.getDataServiceProvider());
            }
            catch (Exception e) {
                ChartPreviewPainter.activateLivePreview(false);
            }
            ChartAdapter.ignoreNotifications((boolean)false);
        } else {
            ChartPreviewPainter.activateLivePreview(false);
        }
        this.changeTask(null);
    }

    private String getSubtypeFromButton(Control button) {
        return (String)button.getData();
    }
}

