/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.ui.swt.SheetPlaceHolder;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskPopupSheet;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.TreeCompoundTask;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.core.ui.frameworks.taskwizard.CompoundTask;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ISubtaskSheet;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ITask;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SubtaskSheetImpl
implements ISubtaskSheet,
ShellListener {
    private transient String sNodePath = "";
    private transient String sTitle = "";
    private transient int subtaskIndex = 0;
    protected transient Composite cmpContent = null;
    private transient ChartWizardContext context = null;
    private transient WizardBase wizard;
    private transient Shell popupShell;
    private transient ITaskPopupSheet popupSheet;
    private transient ITask parentTask;
    private static boolean POPUP_ATTACHING;
    private transient Map popupButtonRegistry = new HashMap(5);
    private transient Map popupSheetRegistry = new HashMap(5);
    private transient Map lastPopupRegistry = new HashMap(3);
    static final /* synthetic */ boolean $assertionsDisabled;

    public void getComponent(Composite parent) {
        this.cmpContent = new SheetPlaceHolder(parent, 0, "");
    }

    public void createControl(Composite parent) {
        this.getComponent(parent);
    }

    public Object onHide() {
        ChartWizard.POPUP_CLOSING_BY_USER = false;
        this.detachPopup();
        ChartWizard.POPUP_CLOSING_BY_USER = true;
        this.cmpContent.dispose();
        this.popupButtonRegistry.clear();
        this.popupSheetRegistry.clear();
        return this.getContext();
    }

    public void onShow(Object context, Object container) {
        this.context = (ChartWizardContext)context;
        this.wizard = (WizardBase)container;
    }

    protected Chart getChart() {
        return this.context.getModel();
    }

    protected ChartWizardContext getContext() {
        return this.context;
    }

    protected WizardBase getWizard() {
        return this.wizard;
    }

    protected void setWizard(WizardBase wizard) {
        this.wizard = wizard;
    }

    protected boolean detachPopup(Widget widget) {
        if (widget instanceof Button && this.popupShell != null && !this.popupShell.isDisposed() && !this.isButtonSelected()) {
            this.getWizard().detachPopup();
            this.popupShell = null;
            this.setCurrentPopupSelection(null);
            this.getParentTask().setPopupSelection(null);
            return true;
        }
        return false;
    }

    public boolean detachPopup() {
        if (this.popupShell != null && !this.popupShell.isDisposed()) {
            this.getWizard().detachPopup();
            this.popupShell = null;
            return true;
        }
        return false;
    }

    protected Shell createPopupShell() {
        POPUP_ATTACHING = true;
        Shell shell = this.getWizard().createPopupContainer();
        shell.addShellListener((ShellListener)this);
        shell.setImage(UIHelper.getImage((String)"icons/obj16/chartbuilder.gif"));
        POPUP_ATTACHING = false;
        return shell;
    }

    protected final void selectAllButtons(boolean isSelected) {
        Iterator buttons = this.popupButtonRegistry.values().iterator();
        while (buttons.hasNext()) {
            ((Button)buttons.next()).setSelection(isSelected);
        }
    }

    private boolean isButtonSelected() {
        Iterator buttons = this.popupButtonRegistry.values().iterator();
        while (buttons.hasNext()) {
            if (!((Button)buttons.next()).getSelection()) continue;
            return true;
        }
        return false;
    }

    protected boolean isRegistered(Widget widget) {
        Iterator buttons = this.popupButtonRegistry.values().iterator();
        while (buttons.hasNext()) {
            if (!buttons.next().equals(widget)) continue;
            return true;
        }
        return false;
    }

    protected void refreshPopupSheet() {
        if (this.popupShell != null && !this.popupShell.isDisposed()) {
            this.popupSheet.refreshComponent((Composite)this.popupShell);
        }
    }

    public void setIndex(int index) {
        this.subtaskIndex = index;
    }

    protected int getIndex() {
        return this.subtaskIndex;
    }

    protected Button createToggleButton(Composite parent, String popupName, ITaskPopupSheet popupSheet) {
        Button button = new Button(parent, 2);
        button.setText(popupName);
        GC gc = new GC((Drawable)parent);
        int width = Math.max(80, gc.textExtent((String)popupName).x + 8);
        gc.dispose();
        GridData gd = new GridData();
        gd.widthHint = width;
        button.setLayoutData((Object)gd);
        this.popupButtonRegistry.put(popupName, button);
        this.popupSheetRegistry.put(popupName, popupSheet);
        return button;
    }

    public void setParentTask(ITask parentTask) {
        if (!$assertionsDisabled && !(parentTask instanceof TreeCompoundTask)) {
            throw new AssertionError();
        }
        this.parentTask = parentTask;
    }

    protected TreeCompoundTask getParentTask() {
        return (TreeCompoundTask)this.parentTask;
    }

    protected void switchTo(String subtaskPath) {
        if (this.parentTask instanceof CompoundTask) {
            ((CompoundTask)this.parentTask).switchTo(subtaskPath);
        }
    }

    public void setNodePath(String nodePath) {
        this.sNodePath = nodePath;
    }

    protected String getNodePath() {
        return this.sNodePath;
    }

    public void shellActivated(ShellEvent e) {
    }

    public void shellClosed(ShellEvent e) {
        Control focusControl = Display.getDefault().getFocusControl();
        if (focusControl instanceof Text) {
            focusControl.notifyListeners(16, null);
        }
        if (e.widget.equals(this.popupShell)) {
            if (!POPUP_ATTACHING) {
                this.selectAllButtons(false);
            }
            if (ChartWizard.POPUP_CLOSING_BY_USER) {
                this.setCurrentPopupSelection(null);
                this.getParentTask().setPopupSelection(null);
            }
        }
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    public boolean attachPopup(String popupName) {
        boolean affectTaskSelection = true;
        if (popupName == null || !this.popupSheetRegistry.containsKey(popupName)) {
            popupName = this.getCurrentPopupSelection();
            affectTaskSelection = false;
        }
        if (popupName == null) {
            return false;
        }
        this.detachPopup();
        if (this.popupSheetRegistry.containsKey(popupName) && ((Button)this.popupButtonRegistry.get(popupName)).isEnabled()) {
            this.selectAllButtons(false);
            ((Button)this.popupButtonRegistry.get(popupName)).setSelection(true);
            this.setCurrentPopupSelection(popupName);
            if (affectTaskSelection) {
                this.getParentTask().setPopupSelection(popupName);
            }
            this.popupShell = this.createPopupShell();
            this.popupSheet = (ITaskPopupSheet)this.popupSheetRegistry.get(popupName);
            this.popupSheet.getUI((Composite)this.popupShell);
            this.getWizard().attachPopup(this.popupSheet.getTitle(), -1, -1);
            return true;
        }
        return false;
    }

    private String getCurrentPopupSelection() {
        return (String)this.lastPopupRegistry.get(this.getContext().getWizardID());
    }

    private void setCurrentPopupSelection(String lastPopup) {
        this.lastPopupRegistry.put(this.getContext().getWizardID(), lastPopup);
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.cmpContent;
    }

    public String getDescription() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public Image getImage() {
        return null;
    }

    public String getMessage() {
        return null;
    }

    public String getTitle() {
        return this.sTitle;
    }

    public void performHelp() {
    }

    public void setDescription(String description) {
    }

    public void setImageDescriptor(ImageDescriptor image) {
    }

    public void setTitle(String title) {
        this.sTitle = title;
    }

    public void setVisible(boolean visible) {
        this.getControl().setVisible(visible);
    }

    static {
        $assertionsDisabled = !SubtaskSheetImpl.class.desiredAssertionStatus();
        POPUP_ATTACHING = false;
    }
}

