/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.axis;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.AngleType;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.IntegerSpinControl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class AxisSheetImpl
extends SubtaskSheetImpl {
    private static final int HORIZONTAL_SPACING = 30;
    private transient Cursor curHand = null;

    public void getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatChartAxis_ID");
        int COLUMN_NUMBER = ChartUIUtil.is3DType((Chart)this.getChart()) ? 5 : 4;
        this.cmpContent = new Composite(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point p = super.computeSize(wHint, hHint, changed);
                p.y = 200;
                return p;
            }
        };
        GridLayout glContent = new GridLayout(1, false);
        glContent.horizontalSpacing = 30;
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        ScrolledComposite cmpScroll = new ScrolledComposite(this.cmpContent, 512);
        gd = new GridData(1808);
        cmpScroll.setLayoutData((Object)gd);
        cmpScroll.setMinHeight((ChartUIUtil.getOrthogonalAxisNumber((Chart)this.getChart()) + (ChartUIUtil.is3DType((Chart)this.getChart()) ? 2 : 1)) * 24 + 40);
        cmpScroll.setExpandVertical(true);
        cmpScroll.setExpandHorizontal(true);
        Composite cmpList = new Composite((Composite)cmpScroll, 0);
        GridLayout glContent2 = new GridLayout(COLUMN_NUMBER, false);
        glContent2.horizontalSpacing = 10;
        cmpList.setLayout((Layout)glContent2);
        cmpScroll.setContent((Control)cmpList);
        Label lblAxis = new Label(cmpList, 0);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 0x1000000;
        lblAxis.setLayoutData((Object)gd2);
        lblAxis.setFont(JFaceResources.getBannerFont());
        lblAxis.setText(Messages.getString("AxisSheetImpl.Label.Axis"));
        Label lblVisible = new Label(cmpList, 0);
        GridData gd3 = new GridData();
        gd3.horizontalAlignment = 0x1000000;
        lblVisible.setLayoutData((Object)gd3);
        lblVisible.setFont(JFaceResources.getBannerFont());
        lblVisible.setText(Messages.getString("AxisSheetImpl.Label.Visible"));
        Label lblType = new Label(cmpList, 0);
        GridData gd4 = new GridData();
        gd4.horizontalAlignment = 0x1000000;
        lblType.setLayoutData((Object)gd4);
        lblType.setFont(JFaceResources.getBannerFont());
        lblType.setText(Messages.getString("AxisSheetImpl.Label.Type"));
        Label lblColor = new Label(cmpList, 0);
        GridData gd5 = new GridData();
        gd5.horizontalAlignment = 0x1000000;
        lblColor.setLayoutData((Object)gd5);
        lblColor.setFont(JFaceResources.getBannerFont());
        lblColor.setText(Messages.getString("AxisSheetImpl.Label.Color"));
        if (ChartUIUtil.is3DType((Chart)this.getChart())) {
            Label lblRotation = new Label(cmpList, 0);
            GridData gd6 = new GridData();
            gd6.horizontalAlignment = 1;
            lblRotation.setLayoutData((Object)gd6);
            lblRotation.setFont(JFaceResources.getBannerFont());
            lblRotation.setText(Messages.getString("AxisSheetImpl.Label.Rotation"));
        }
        int treeIndex = 0;
        new AxisOptionChoser(ChartUIUtil.getAxisXForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart())), Messages.getString("AxisSheetImpl.Label.CategoryX"), 1, treeIndex++).placeComponents(cmpList);
        int yaxisNumber = ChartUIUtil.getOrthogonalAxisNumber((Chart)this.getChart());
        for (int i = 0; i < yaxisNumber; ++i) {
            String text = Messages.getString("AxisSheetImpl.Label.ValueY");
            new AxisOptionChoser(ChartUIUtil.getAxisYForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart()), (int)i), yaxisNumber == 1 ? text : text + " - " + (i + 1), 2, treeIndex++).placeComponents(cmpList);
        }
        if (ChartUIUtil.is3DType((Chart)this.getChart())) {
            new AxisOptionChoser(ChartUIUtil.getAxisZForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart())), Messages.getString("AxisSheetImpl.Label.AncillaryZ"), 3, treeIndex++).placeComponents(cmpList);
        }
    }

    public void onShow(Object context, Object container) {
        super.onShow(context, container);
        this.curHand = new Cursor((Device)Display.getDefault(), 21);
    }

    public Object onHide() {
        this.curHand.dispose();
        return super.onHide();
    }

    private class AxisOptionChoser
    implements SelectionListener,
    Listener,
    MouseListener,
    MouseTrackListener {
        private transient Label lblAxis;
        private transient Combo cmbTypes;
        private transient Button btnVisible;
        private transient FillChooserComposite cmbColor;
        private transient IntegerSpinControl iscRotation;
        private transient Axis axis;
        private transient String axisName;
        private transient int angleType;
        private transient int treeIndex = 0;

        public AxisOptionChoser(Axis axis, String axisName, int angleType, int treeIndex) {
            this.axis = axis;
            this.axisName = axisName;
            this.angleType = angleType;
            this.treeIndex = treeIndex;
        }

        public void placeComponents(Composite parent) {
            this.lblAxis = new Label(parent, 0);
            this.lblAxis.setText(this.axisName);
            this.lblAxis.setForeground(Display.getDefault().getSystemColor(10));
            this.lblAxis.addMouseListener((MouseListener)this);
            this.lblAxis.addMouseTrackListener((MouseTrackListener)this);
            this.btnVisible = new Button(parent, 32);
            GridData gd = new GridData();
            gd.horizontalAlignment = 0x1000000;
            this.btnVisible.setLayoutData((Object)gd);
            this.btnVisible.addSelectionListener((SelectionListener)this);
            this.btnVisible.setSelection(this.axis.getLineAttributes().isVisible());
            this.cmbTypes = new Combo(parent, 12);
            gd = new GridData();
            gd.horizontalAlignment = 0x1000000;
            this.cmbTypes.setLayoutData((Object)gd);
            NameSet ns = LiteralHelper.axisTypeSet;
            this.cmbTypes.setItems(ns.getDisplayNames());
            this.cmbTypes.select(ns.getSafeNameIndex(this.axis.getType().getName()));
            this.cmbTypes.addSelectionListener((SelectionListener)this);
            ColorDefinition clrCurrent = null;
            if (this.axis.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getAxis_LineAttributes())) {
                clrCurrent = this.axis.getLineAttributes().getColor();
            }
            this.cmbColor = new FillChooserComposite(parent, 12, AxisSheetImpl.this.getContext(), (Fill)clrCurrent, false, false);
            GridData gd2 = new GridData();
            gd2.widthHint = 200;
            this.cmbColor.setLayoutData(gd2);
            this.cmbColor.addListener(this);
            if (ChartUIUtil.is3DType((Chart)AxisSheetImpl.this.getChart())) {
                this.iscRotation = new IntegerSpinControl(parent, 0, (int)this.getAxisAngle(this.angleType));
                gd2 = new GridData(768);
                gd2.heightHint = this.iscRotation.getPreferredSize().y;
                this.iscRotation.setLayoutData(gd2);
                this.iscRotation.setMaximum(360);
                this.iscRotation.setMinimum(-360);
                this.iscRotation.setIncrement(4);
                this.iscRotation.addListener(this);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget.equals(this.btnVisible)) {
                this.axis.getLineAttributes().setVisible(this.btnVisible.getSelection());
            } else if (e.widget.equals(this.cmbTypes)) {
                AxisType axisType = AxisType.getByName((String)LiteralHelper.axisTypeSet.getNameByDisplayName(this.cmbTypes.getText()));
                boolean isNotificaionIgnored = ChartAdapter.isNotificationIgnored();
                ChartAdapter.ignoreNotifications((boolean)true);
                this.convertSampleData(axisType);
                ChartAdapter.ignoreNotifications((boolean)isNotificaionIgnored);
                this.axis.setType(axisType);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void handleEvent(Event event) {
            if (((Object)((Object)this.cmbColor)).equals(event.widget)) {
                if (event.type == 1) {
                    this.axis.getLineAttributes().setColor((ColorDefinition)event.data);
                }
            } else if (event.widget.equals((Object)this.iscRotation)) {
                this.setAxisAngle(this.angleType, (Integer)event.data);
            }
        }

        private double getAxisAngle(int angleType) {
            switch (angleType) {
                case 1: {
                    return this.getAngle3D().getXAngle();
                }
                case 2: {
                    return this.getAngle3D().getYAngle();
                }
                case 3: {
                    return this.getAngle3D().getZAngle();
                }
            }
            return 0.0;
        }

        private void setAxisAngle(int angleType, int angleDegree) {
            Angle3D angle3D = this.getAngle3D();
            angle3D.setType(AngleType.NONE_LITERAL);
            ((ChartWithAxes)AxisSheetImpl.this.getChart()).getRotation().getAngles().clear();
            ((ChartWithAxes)AxisSheetImpl.this.getChart()).getRotation().getAngles().add((Object)angle3D);
            switch (angleType) {
                case 1: {
                    angle3D.setXAngle((double)angleDegree);
                    break;
                }
                case 2: {
                    angle3D.setYAngle((double)angleDegree);
                    break;
                }
                case 3: {
                    angle3D.setZAngle((double)angleDegree);
                }
            }
        }

        private Angle3D getAngle3D() {
            return (Angle3D)((ChartWithAxes)AxisSheetImpl.this.getChart()).getRotation().getAngles().get(0);
        }

        private void convertSampleData(AxisType axisType) {
            if (this.angleType == 1) {
                BaseSampleData bsd = (BaseSampleData)AxisSheetImpl.this.getChart().getSampleData().getBaseSampleData().get(0);
                bsd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)bsd.getDataSetRepresentation()));
            } else if (this.angleType == 2) {
                int iStartIndex = this.getFirstSeriesDefinitionIndexForAxis();
                int iEndIndex = iStartIndex + this.axis.getSeriesDefinitions().size();
                int iOSDSize = AxisSheetImpl.this.getChart().getSampleData().getOrthogonalSampleData().size();
                for (int i = 0; i < iOSDSize; ++i) {
                    OrthogonalSampleData osd = (OrthogonalSampleData)AxisSheetImpl.this.getChart().getSampleData().getOrthogonalSampleData().get(i);
                    if (osd.getSeriesDefinitionIndex() < iStartIndex || osd.getSeriesDefinitionIndex() > iEndIndex) continue;
                    osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)osd.getDataSetRepresentation()));
                }
            }
        }

        private int getFirstSeriesDefinitionIndexForAxis() {
            int iTmp = 0;
            for (int i = 0; i < AxisSheetImpl.this.getIndex(); ++i) {
                iTmp += ChartUIUtil.getAxisYForProcessing((ChartWithAxes)((ChartWithAxes)AxisSheetImpl.this.getChart()), (int)i).getSeriesDefinitions().size();
            }
            return iTmp;
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            this.switchTo(this.treeIndex);
        }

        public void mouseUp(MouseEvent e) {
        }

        public void mouseEnter(MouseEvent e) {
            this.lblAxis.setCursor(AxisSheetImpl.this.curHand);
        }

        public void mouseExit(MouseEvent e) {
            this.lblAxis.setCursor(null);
        }

        public void mouseHover(MouseEvent e) {
        }

        private void switchTo(int index) {
            TreeItem currentItem = AxisSheetImpl.this.getParentTask().getNavigatorTree().getSelection()[0];
            TreeItem[] children = currentItem.getItems();
            if (index < children.length) {
                AxisSheetImpl.this.getParentTask().switchToTreeItem(children[index]);
            }
        }
    }
}

