/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public final class ColorPalette {
    private static ColorPalette instance = null;
    private List colorLib = new ArrayList();
    private List colorAvailable = new ArrayList();
    private Color currentColor;
    private HashMap hmColorUsed = new HashMap();

    private ColorPalette() {
        this.initColorLibrary();
        this.restore();
    }

    public static synchronized ColorPalette getInstance() {
        if (instance == null) {
            instance = new ColorPalette();
        }
        return instance;
    }

    private void initColorLibrary() {
        this.colorLib.add(new RGB(255, 128, 128));
        this.colorLib.add(new RGB(170, 200, 255));
        this.colorLib.add(new RGB(255, 255, 128));
        this.colorLib.add(new RGB(128, 255, 128));
        this.colorLib.add(new RGB(128, 255, 255));
        this.colorLib.add(new RGB(255, 128, 255));
        this.colorLib.add(new RGB(255, 128, 64));
        this.colorLib.add(new RGB(0, 255, 128));
        this.colorLib.add(new RGB(200, 156, 156));
        this.colorLib.add(new RGB(128, 128, 255));
        this.colorLib.add(new RGB(210, 210, 210));
        this.colorLib.add(new RGB(184, 184, 114));
    }

    private Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        String key = rgb.toString();
        Color color = JFaceResources.getColorRegistry().get(key);
        if (color == null) {
            JFaceResources.getColorRegistry().put(key, rgb);
            color = JFaceResources.getColorRegistry().get(key);
        }
        return color;
    }

    public Color getNewColor() {
        Color color;
        this.currentColor = color = this.getColor();
        if (color != null) {
            this.colorAvailable.remove(color.getRGB());
        }
        return color;
    }

    private Color getColor() {
        RGB rgb;
        RGB rGB = rgb = this.colorAvailable.isEmpty() ? null : (RGB)this.colorAvailable.get(0);
        if (rgb == null) {
            return null;
        }
        return this.getColor(rgb);
    }

    public Color getCurrentColor() {
        if (this.currentColor == null) {
            this.currentColor = this.getColor();
        }
        return this.currentColor;
    }

    public void putColor(String expression) {
        if (expression != null && expression.length() > 0) {
            if (!this.hmColorUsed.containsKey(expression = expression.toUpperCase())) {
                this.hmColorUsed.put(expression, this.getNewColor());
                this.colorAvailable.remove(this.getCurrentColor().getRGB());
            } else {
                this.currentColor = this.getColor(expression);
            }
        }
    }

    public void retrieveColor(String expression) {
        if (expression != null && expression.length() > 0 && this.hmColorUsed.containsKey(expression = expression.toUpperCase())) {
            Color oldColor = (Color)this.hmColorUsed.get(expression);
            this.colorAvailable.add(oldColor.getRGB());
            this.hmColorUsed.remove(expression);
        }
    }

    public Color getColor(String expression) {
        if (expression != null && expression.length() > 0) {
            expression = expression.toUpperCase();
            return (Color)this.hmColorUsed.get(expression);
        }
        return null;
    }

    public void restore() {
        this.colorAvailable.clear();
        this.colorAvailable.addAll(this.colorLib);
        this.currentColor = null;
        this.hmColorUsed.clear();
    }
}

