/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.internal;

import java.util.Vector;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.wizard.internal.CustomPreviewTableDragListener;
import org.eclipse.birt.chart.ui.swt.wizard.internal.SimpleTextTransfer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class CustomPreviewTable
extends Composite
implements SelectionListener,
MouseListener,
MouseMoveListener,
ControlListener {
    private static final int ROW_HEIGHT = 20;
    public static final int MOUSE_RIGHT_CLICK_TYPE = 0;
    private static final int SPLITTER_WIDTH = 2;
    private transient Vector headings = new Vector();
    transient Vector columnWidths = new Vector();
    private transient Vector btnHeaders = new Vector();
    private transient Vector vListeners = new Vector();
    private transient Composite cmpHeaders = null;
    private transient TableCanvas cnvCells = null;
    private transient int iHeaderAlignment = 0x1000000;
    transient int iVScroll = 0;
    transient int iLastProcessedHorizontalScrollPosition = 0;
    transient int iLastProcessedVerticalScrollPosition = 0;
    transient int iColumnIndex = -1;
    transient boolean bDragging = false;
    private transient int iResizingColumnIndex = -1;
    private transient int iDragStartXLocation = -1;
    private transient int iHiddenWidth = 0;

    public CustomPreviewTable(Composite parent, int style) {
        super(parent, 2048);
        this.placeComponents();
        this.createDummyTable();
    }

    private void placeComponents() {
        if (this.cmpHeaders == null) {
            GridLayout glTable = new GridLayout();
            glTable.numColumns = 1;
            glTable.marginWidth = 1;
            glTable.marginHeight = 1;
            glTable.horizontalSpacing = 0;
            glTable.verticalSpacing = 0;
            this.setLayout((Layout)glTable);
            this.cmpHeaders = new Composite((Composite)this, 0);
            GridData gdCmpHeaders = new GridData(768);
            this.cmpHeaders.setLayoutData((Object)gdCmpHeaders);
            FormLayout glHeaders = new FormLayout();
            glHeaders.marginHeight = 0;
            glHeaders.marginWidth = 0;
            this.cmpHeaders.setLayout((Layout)glHeaders);
            this.cmpHeaders.addMouseListener((MouseListener)this);
        } else {
            Control[] buttons = this.cmpHeaders.getChildren();
            for (int i = 0; i < buttons.length; ++i) {
                buttons[i].dispose();
            }
        }
        this.btnHeaders.clear();
        for (int i = 0; i < this.headings.size(); ++i) {
            this.addHeaderButton(this.iHeaderAlignment, (String)this.headings.elementAt(i), (Integer)this.columnWidths.get(i));
        }
        this.cmpHeaders.layout();
        if (this.cnvCells != null && !this.cnvCells.isDisposed()) {
            this.cnvCells.dispose();
        }
        this.cnvCells = new TableCanvas(this, 0, this.headings.size(), new Color[0], this);
        this.cnvCells.setLayoutData(new GridData(1808));
        this.cnvCells.setBackground(Display.getCurrent().getSystemColor(25));
        this.cnvCells.addMouseMoveListener(this);
        this.getShell().addControlListener((ControlListener)this);
    }

    private void addHeaderButton(int style, String sColumnHeading, int iWidth) {
        Button btnHeader = new Button(this.cmpHeaders, style);
        FormData fd = new FormData();
        fd.top = new FormAttachment(2);
        int i = this.btnHeaders.size();
        if (i == 0) {
            fd.left = new FormAttachment(0);
        } else {
            Button btnNeighbor = (Button)this.btnHeaders.get(i - 1);
            fd.left = new FormAttachment((Control)btnNeighbor, 2);
        }
        fd.width = iWidth - 2;
        btnHeader.setLayoutData((Object)fd);
        btnHeader.setText(sColumnHeading);
        btnHeader.setVisible(true);
        btnHeader.addSelectionListener((SelectionListener)this);
        btnHeader.addMouseListener((MouseListener)this);
        btnHeader.addMouseMoveListener((MouseMoveListener)this);
        this.addDragListenerToHeaderButton(btnHeader);
        this.btnHeaders.add(btnHeader);
        this.addHeaderSplitter();
    }

    private void addHeaderSplitter() {
        Label splitter = new Label(this.cmpHeaders, 0);
        FormData fd = new FormData();
        fd.top = new FormAttachment(2);
        int i = this.btnHeaders.size();
        if (i == 0) {
            fd.left = new FormAttachment(0);
        } else {
            Button btnNeighbor = (Button)this.btnHeaders.get(i - 1);
            fd.left = new FormAttachment((Control)btnNeighbor);
        }
        fd.width = 2;
        splitter.setLayoutData((Object)fd);
        splitter.setData((Object)new Integer(i - 1));
        splitter.addMouseListener((MouseListener)this);
        splitter.addMouseMoveListener((MouseMoveListener)this);
    }

    public void addColumn(String sColumnHeading, Color clr, int iWidth) {
        this.columnWidths.add(new Integer(iWidth));
        this.headings.add(sColumnHeading);
        this.addHeaderButton(this.iHeaderAlignment, sColumnHeading, iWidth);
        this.cmpHeaders.layout(true);
        this.cnvCells.addColumn(clr);
        this.cnvCells.redraw();
        this.cnvCells.updateScrollbars();
    }

    private void addDragListenerToHeaderButton(Button button) {
        DragSource ds = new DragSource((Control)button, 1);
        ds.setTransfer(new Transfer[]{SimpleTextTransfer.getInstance()});
        CustomPreviewTableDragListener dragSourceAdapter = new CustomPreviewTableDragListener(this, button.getText());
        ds.addDragListener((DragSourceListener)dragSourceAdapter);
    }

    Point getTableSize() {
        return this.getSize();
    }

    public void addEntry(String sText, int iIndex) throws IllegalArgumentException {
        if (this.headings == null || iIndex >= this.headings.size()) {
            throw new IllegalArgumentException(Messages.getFormattedString("CustomPreviewTable.Exception.InvalidColumnIndexNotDefined", String.valueOf(iIndex)));
        }
        this.cnvCells.addEntry(sText, iIndex);
    }

    public String getColumnHeading(int iIndex) throws IllegalArgumentException {
        if (this.headings == null || iIndex >= this.headings.size()) {
            throw new IllegalArgumentException(Messages.getFormattedString("CustomPreviewTable.Exception.InvalidColumnIndexNotDefined", String.valueOf(iIndex)));
        }
        return (String)this.headings.get(iIndex);
    }

    public String getCurrentColumnHeading() {
        return this.iColumnIndex != -1 ? (String)this.headings.get(this.iColumnIndex) : null;
    }

    public int getCurrentColumnIndex() {
        return this.iColumnIndex;
    }

    public int getColumnNumber() {
        return this.headings.size();
    }

    public void setColumnColor(int index, Color clr) {
        this.cnvCells.setColumnColor(index, clr);
        this.cnvCells.redraw();
    }

    public Color getColumnColor(int iIndex) {
        if (iIndex > this.cnvCells.colors.length) {
            throw new IllegalArgumentException(Messages.getString("CustomPreviewTable.Exception.InvalidColumnIndexSpecified"));
        }
        return this.cnvCells.colors[iIndex];
    }

    public void clearContents() {
        this.btnHeaders.clear();
        this.columnWidths.clear();
        this.headings.clear();
        this.iVScroll = 0;
        this.iLastProcessedHorizontalScrollPosition = 0;
        this.iLastProcessedVerticalScrollPosition = 0;
        this.iHiddenWidth = 0;
        Control[] c = this.cmpHeaders.getChildren();
        for (int i = 0; i < c.length; ++i) {
            c[i].dispose();
        }
        this.cnvCells.clearContents();
    }

    public void setHeaderAlignment(int iAlignment) {
        this.iHeaderAlignment = iAlignment;
        for (int i = 0; i < this.btnHeaders.size(); ++i) {
            ((Button)this.btnHeaders.get(i)).setAlignment(this.iHeaderAlignment);
        }
    }

    public void createDummyTable() {
        this.setColumns(new String[]{"", "", ""}, new int[]{200, 200, 200});
        this.layout(true);
    }

    int getColumnWidthFor(int iIndex) {
        if (iIndex > this.columnWidths.size() - 1 || iIndex < 0) {
            return 0;
        }
        Object oTmp = null;
        oTmp = this.columnWidths.get(iIndex);
        return oTmp;
    }

    int getLeftEdgeForColumn(int iIndex) {
        int iRE = 0;
        for (int i = 0; i < iIndex; ++i) {
            iRE += this.getColumnWidthFor(i);
        }
        return iRE;
    }

    int getRightEdgeForColumn(int iIndex) {
        int iRE = 0;
        for (int i = 0; i <= iIndex; ++i) {
            iRE += this.getColumnWidthFor(i);
        }
        return iRE;
    }

    int getAdjustedLeftEdgeForColumn(int iIndex) {
        int iRE = this.getLeftEdgeForColumn(iIndex);
        return iRE - this.iHiddenWidth;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            int iColumn = this.btnHeaders.indexOf(e.getSource());
            this.cnvCells.selectColumn(iColumn);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setColumns(String[] headers) {
        this.clearContents();
        if (headers.length == 0) {
            this.createDummyTable();
            return;
        }
        int iW = this.cnvCells.getVisibleTableWidth() / headers.length;
        if (iW < 100) {
            iW = 100;
        }
        for (int i = 0; i < headers.length; ++i) {
            this.headings.add(headers[i]);
            this.columnWidths.add(new Integer(iW));
        }
        this.placeComponents();
    }

    public void setColumns(String[] headers, int[] widths) {
        this.clearContents();
        if (headers.length == 0) {
            this.createDummyTable();
            return;
        }
        for (int i = 0; i < headers.length; ++i) {
            this.headings.add(headers[i]);
            this.columnWidths.add(new Integer(widths[i]));
        }
        this.placeComponents();
    }

    void fireMenuEvent() {
        Event e = new Event();
        e.type = 0;
        e.button = 3;
        e.data = new Integer(this.iColumnIndex);
        for (int i = 0; i < this.vListeners.size(); ++i) {
            ((Listener)this.vListeners.get(i)).handleEvent(e);
        }
    }

    public void addListener(int eventType, Listener listener) {
        if (eventType == 0) {
            this.vListeners.add(listener);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (e.widget instanceof Label) {
            int columnIndex = (Integer)e.widget.getData();
            int width = this.cnvCells.calculateMaxColumnWidth(columnIndex, (Control)((Label)e.widget));
            this.columnWidths.set(columnIndex, new Integer(width + 2));
            ((FormData)((Button)this.btnHeaders.get((int)columnIndex)).getLayoutData()).width = width;
            this.cmpHeaders.layout();
            this.cnvCells.updateScrollbars();
            this.cnvCells.redraw();
        }
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1 && e.widget instanceof Label) {
            this.bDragging = true;
            this.iDragStartXLocation = this.cnvCells.getDisplay().getCursorLocation().x;
            this.iResizingColumnIndex = (Integer)e.widget.getData();
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.bDragging && this.iResizingColumnIndex != -1) {
            this.bDragging = false;
            this.iDragStartXLocation = -1;
            this.iResizingColumnIndex = -1;
        }
        if (e.widget instanceof Button && e.button == 3) {
            this.iColumnIndex = this.btnHeaders.indexOf(e.widget);
            this.fireMenuEvent();
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.bDragging || e.widget instanceof Label) {
            this.setCursor(Display.getCurrent().getSystemCursor(9));
            if (this.bDragging && this.iResizingColumnIndex != -1) {
                int x = this.cnvCells.getDisplay().getCursorLocation().x;
                int newWidth = (Integer)this.columnWidths.get(this.iResizingColumnIndex) + (x - this.iDragStartXLocation);
                if (newWidth > 5) {
                    ((FormData)((Button)this.btnHeaders.get((int)this.iResizingColumnIndex)).getLayoutData()).width += x - this.iDragStartXLocation;
                    this.columnWidths.set(this.iResizingColumnIndex, new Integer(newWidth));
                    this.iDragStartXLocation = x;
                    this.cmpHeaders.layout();
                    this.cnvCells.updateScrollbars();
                    this.cnvCells.redraw();
                }
            }
        } else {
            this.setCursor(Display.getCurrent().getSystemCursor(0));
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.cnvCells.updateScrollbars();
        this.layout(true);
        this.cnvCells.redraw();
    }

    class TableCanvas
    extends Canvas
    implements PaintListener,
    MouseListener,
    SelectionListener {
        transient Color[] colors;
        private transient Vector[] cells;
        private transient int iSelectedRow;
        private transient int iSelectedColumn;
        private transient boolean bColumnSelection;
        private transient int iMaxRowIndex;
        private transient boolean isFirstPaint;
        public static final int SCROLL_HORIZONTAL_STEP = 100;

        public TableCanvas(Composite parent, int style, int iColumns, Color[] colors, CustomPreviewTable container) {
            super(parent, style | 0x100 | 0x200);
            this.colors = null;
            this.cells = null;
            this.iSelectedRow = -1;
            this.iSelectedColumn = -1;
            this.bColumnSelection = false;
            this.iMaxRowIndex = 0;
            this.isFirstPaint = true;
            this.addPaintListener(this);
            this.addMouseListener(this);
            this.addMouseListener(container);
            this.getHorizontalBar().addSelectionListener((SelectionListener)this);
            this.getVerticalBar().addSelectionListener((SelectionListener)this);
            this.cells = new Vector[iColumns];
            this.colors = new Color[iColumns];
            for (int i = 0; i < iColumns; ++i) {
                this.cells[i] = new Vector();
                try {
                    this.colors[i] = colors[i];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.colors[i] = Display.getDefault().getSystemColor(25);
                }
            }
            this.updateScrollbars();
        }

        public void updateScrollbars() {
            int iMaxTableWidth = this.getMaxTableWidth() + 100;
            int iVisibleTableWidth = this.getVisibleTableWidth();
            int iVisibleRows = 0;
            if (this.isVisible()) {
                this.getHorizontalBar().setValues(iVisibleTableWidth + CustomPreviewTable.this.iHiddenWidth, iVisibleTableWidth, iMaxTableWidth, 100, 100, 100);
                int iHeight = CustomPreviewTable.this.getTableSize().y;
                if (iHeight == 0) {
                    iHeight = this.getParent().computeSize((int)-1, (int)-1, (boolean)true).y;
                }
                iVisibleRows = (int)Math.floor((iHeight -= super.getHorizontalBar().getSize().y) / 20);
                this.getVerticalBar().setValues(iVisibleRows + CustomPreviewTable.this.iVScroll, iVisibleRows, this.iMaxRowIndex + 2, 1, 1, 1);
            } else {
                this.getHorizontalBar().setValues(iVisibleTableWidth, iVisibleTableWidth, iMaxTableWidth, 100, 100, 100);
                this.getVerticalBar().setValues(this.iMaxRowIndex, this.iMaxRowIndex, this.iMaxRowIndex, 1, 1, 1);
            }
            CustomPreviewTable.this.iLastProcessedHorizontalScrollPosition = iVisibleTableWidth + CustomPreviewTable.this.iHiddenWidth;
            CustomPreviewTable.this.iLastProcessedVerticalScrollPosition = iVisibleRows + CustomPreviewTable.this.iVScroll;
        }

        private int getMaxTableWidth() {
            int max = 0;
            for (int i = 0; i < CustomPreviewTable.this.columnWidths.size(); ++i) {
                max += ((Integer)CustomPreviewTable.this.columnWidths.get(i)).intValue();
            }
            return max;
        }

        private int getVisibleTableWidth() {
            int iVisibleTableWidth = CustomPreviewTable.this.getTableSize().x;
            if (iVisibleTableWidth == 0) {
                iVisibleTableWidth = this.getParent().computeSize((int)-1, (int)-1).x;
            }
            return iVisibleTableWidth - 20;
        }

        private int calculateMaxColumnWidth(int columnIndex, Control control) {
            int maxWidth = 10;
            GC gc = new GC((Drawable)control);
            Vector columnTexts = this.cells[columnIndex];
            for (int rowIndex = 0; rowIndex < columnTexts.size(); ++rowIndex) {
                Object obj = columnTexts.get(rowIndex);
                if (obj == null || !(obj instanceof String)) continue;
                maxWidth = Math.max(gc.textExtent((String)((String)obj)).x, maxWidth);
            }
            gc.dispose();
            return maxWidth;
        }

        public void addColumn(Color clr) {
            Vector[] newCells = new Vector[this.cells.length + 1];
            Color[] newColors = new Color[this.colors.length + 1];
            for (int i = 0; i < this.cells.length; ++i) {
                newCells[i] = this.cells[i];
                newColors[i] = this.colors[i];
            }
            newCells[this.cells.length] = new Vector();
            newColors[this.colors.length] = clr != null ? clr : Display.getDefault().getSystemColor(25);
            this.cells = newCells;
            this.colors = newColors;
            this.updateScrollbars();
            super.layout();
        }

        public void addEntry(String sText, int iColumn) throws IllegalArgumentException {
            if (iColumn > this.cells.length) {
                throw new IllegalArgumentException(Messages.getFormattedString("CustomPreviewTable.Exception.InvalidColumnIndexSpecifiedOnly", new Object[]{String.valueOf(iColumn), String.valueOf(this.cells.length)}));
            }
            this.cells[iColumn].add(sText);
            if (this.cells[iColumn].size() > this.iMaxRowIndex) {
                this.iMaxRowIndex = this.cells[iColumn].size();
                this.updateScrollbars();
            }
        }

        public void setText(String sText, int iColumn, int iRow) throws IllegalArgumentException {
            if (iColumn > this.cells.length) {
                throw new IllegalArgumentException(Messages.getFormattedString("CustomPreviewTable.Exception.InvalidColumnIndexSpecifiedOnly", new Object[]{String.valueOf(iColumn), String.valueOf(this.cells.length)}));
            }
            if (iRow < 0) {
                throw new IllegalArgumentException(Messages.getString("CustomPreviewTable.Exception.RowIndexGreaterThan0"));
            }
            this.cells[iColumn].ensureCapacity(iRow);
            this.cells[iColumn].setElementAt(sText, iRow);
            if (this.cells[iColumn].size() > this.iMaxRowIndex) {
                this.iMaxRowIndex = this.cells[iColumn].size();
                this.updateScrollbars();
            }
        }

        public void selectColumn(int iIndex) {
            this.iSelectedColumn = iIndex;
            this.bColumnSelection = true;
            this.redraw();
        }

        public void clearContents() {
            for (int i = 0; i < this.cells.length; ++i) {
                this.cells[i].clear();
            }
            this.cells = new Vector[0];
            this.colors = new Color[0];
            this.iSelectedRow = -1;
            this.iSelectedColumn = -1;
            this.bColumnSelection = false;
            super.getHorizontalBar().setValues(1, 1, 1, 1, 1, 1);
            super.getVerticalBar().setValues(1, 1, 1, 1, 1, 1);
        }

        public void setColumnColor(int iColumnIndex, Color color) {
            if (iColumnIndex < this.colors.length) {
                this.colors[iColumnIndex] = color;
            }
        }

        public boolean isColumnSelected(int iIndex) {
            return this.iSelectedColumn == iIndex;
        }

        public void paintControl(PaintEvent pe) {
            if (this.isFirstPaint) {
                this.isFirstPaint = false;
                this.updateScrollbars();
            }
            GC gc = pe.gc;
            Color cSelectionBack = null;
            Color cSelectionFore = null;
            Color cDefaultBack = Display.getCurrent().getSystemColor(25);
            Color cDefaultFore = Display.getCurrent().getSystemColor(24);
            Color cText = Display.getCurrent().getSystemColor(28);
            Color cGrid = Display.getCurrent().getSystemColor(22);
            int iXStart = -1;
            int iXEnd = -1;
            for (int iC = 0; iC < this.cells.length; ++iC) {
                int columnWidthOffset = CustomPreviewTable.this.iHiddenWidth;
                if (iC > 0) {
                    iXStart += CustomPreviewTable.this.getColumnWidthFor(iC - 1);
                }
                if ((iXEnd += CustomPreviewTable.this.getColumnWidthFor(iC)) - columnWidthOffset < 0 || iXStart - columnWidthOffset > this.getSize().x) continue;
                Color cBack = this.getColorForColumn(iC);
                if (cBack == null) {
                    cBack = cDefaultBack;
                }
                gc.setBackground(cBack);
                gc.fillRectangle(iXStart - columnWidthOffset, 0, CustomPreviewTable.this.getColumnWidthFor(iC), this.getSize().y);
                gc.setForeground(cGrid);
                gc.drawLine(iXStart - columnWidthOffset, 0, iXStart - columnWidthOffset, this.getSize().y);
                int iYStart = 0;
                int iYEnd = 0;
                for (int iR = 0; iR <= this.iMaxRowIndex || iYEnd < this.getSize().y; ++iR) {
                    iYStart = iR * 20 - CustomPreviewTable.this.iVScroll * 20;
                    iYEnd = iYStart + 20;
                    gc.setForeground(cGrid);
                    gc.drawLine(iXStart - columnWidthOffset, iYStart, iXStart - columnWidthOffset + CustomPreviewTable.this.getColumnWidthFor(iC), iYStart);
                    gc.setForeground(cDefaultFore);
                    Rectangle r = gc.getClipping();
                    gc.setClipping(iXStart - columnWidthOffset, iYStart, CustomPreviewTable.this.getColumnWidthFor(iC), iYEnd - iYStart);
                    if (iC == this.iSelectedColumn && (this.bColumnSelection || iR == this.iSelectedRow)) {
                        cSelectionBack = gc.getBackground();
                        cSelectionFore = gc.getForeground();
                        gc.setBackground(Display.getCurrent().getSystemColor(26));
                        gc.setForeground(Display.getCurrent().getSystemColor(27));
                        gc.fillRectangle(iXStart - columnWidthOffset, iYStart, CustomPreviewTable.this.getColumnWidthFor(iC), iYEnd - iYStart);
                        gc.drawRectangle(iXStart - columnWidthOffset, iYStart, CustomPreviewTable.this.getColumnWidthFor(iC), iYEnd - iYStart);
                    } else {
                        gc.setForeground(cText);
                    }
                    String sContent = this.cells[iC].size() > 0 && this.cells[iC].size() > iR ? (this.cells[iC].elementAt(iR) != null ? this.cells[iC].elementAt(iR).toString() : "") : "";
                    gc.drawText(sContent, iXStart - columnWidthOffset + 3, iYStart + 3);
                    if (iC == this.iSelectedColumn && (this.bColumnSelection || iR == this.iSelectedRow)) {
                        gc.setBackground(cSelectionBack);
                        gc.setForeground(cSelectionFore);
                    }
                    gc.setClipping(r);
                }
                if (iC != this.cells.length - 1) continue;
                gc.setForeground(cGrid);
                gc.drawLine(iXStart - columnWidthOffset + CustomPreviewTable.this.getColumnWidthFor(iC), 0, iXStart - columnWidthOffset + CustomPreviewTable.this.getColumnWidthFor(iC), this.getSize().y);
            }
        }

        private Color getColorForColumn(int iIndex) {
            if (this.colors != null) {
                return this.colors[iIndex];
            }
            return null;
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            if (CustomPreviewTable.this.bDragging) {
                this.updateScrollbars();
                return;
            }
            this.bColumnSelection = false;
            if (e.button != 3) {
                this.iSelectedRow = e.y / 20;
                int i = 0;
                int iTmp = 0;
                while (i < CustomPreviewTable.this.columnWidths.size()) {
                    iTmp = CustomPreviewTable.this.getAdjustedLeftEdgeForColumn(i);
                    if (iTmp > e.x) {
                        this.iSelectedColumn = i - 1;
                        break;
                    }
                    this.iSelectedColumn = i++;
                }
                this.redraw();
            } else {
                CustomPreviewTable.this.iColumnIndex = -1;
                int i = 0;
                int iTmp = 0;
                while (i < CustomPreviewTable.this.columnWidths.size()) {
                    iTmp = CustomPreviewTable.this.getAdjustedLeftEdgeForColumn(i);
                    if (iTmp > e.x) {
                        CustomPreviewTable.this.iColumnIndex = i - 1;
                        break;
                    }
                    CustomPreviewTable.this.iColumnIndex = i++;
                }
                CustomPreviewTable.this.fireMenuEvent();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() instanceof ScrollBar) {
                ScrollBar sb = (ScrollBar)e.getSource();
                if ((sb.getStyle() | 0x100) == 256) {
                    if (CustomPreviewTable.this.iLastProcessedHorizontalScrollPosition == 0) {
                        CustomPreviewTable.this.iLastProcessedHorizontalScrollPosition = CustomPreviewTable.this.cnvCells.getVisibleTableWidth();
                    }
                    if (sb.getSelection() == CustomPreviewTable.this.iLastProcessedHorizontalScrollPosition) {
                        return;
                    }
                    if ((sb.getStyle() | 0x100) == 256) {
                        int iShift = 0;
                        iShift = e.detail == 0x1000001 || e.detail == 0x1000005 ? -100 : (e.detail == 0x1000002 || e.detail == 0x1000006 ? 100 : sb.getSelection() - CustomPreviewTable.this.iLastProcessedHorizontalScrollPosition);
                        CustomPreviewTable.this.iHiddenWidth += iShift;
                        if (CustomPreviewTable.this.iHiddenWidth < 0) {
                            iShift -= CustomPreviewTable.this.iHiddenWidth;
                            CustomPreviewTable.this.iHiddenWidth = 0;
                        } else if (CustomPreviewTable.this.iHiddenWidth + this.getVisibleTableWidth() > this.getMaxTableWidth()) {
                            int diff = this.getMaxTableWidth() - this.getVisibleTableWidth() - CustomPreviewTable.this.iHiddenWidth;
                            iShift += diff;
                            CustomPreviewTable.this.iHiddenWidth += diff;
                        }
                        if (CustomPreviewTable.this.btnHeaders.size() > 0) {
                            Button btn = (Button)CustomPreviewTable.this.btnHeaders.get(0);
                            ((FormData)btn.getLayoutData()).left = new FormAttachment(0, btn.getLocation().x - iShift);
                        }
                        CustomPreviewTable.this.cmpHeaders.layout();
                        CustomPreviewTable.this.iLastProcessedHorizontalScrollPosition = sb.getSelection();
                    }
                } else {
                    if (this.getVerticalBar().getSelection() == CustomPreviewTable.this.iLastProcessedVerticalScrollPosition) {
                        return;
                    }
                    if (e.detail == 0x1000001 || e.detail == 0x1000005) {
                        if (CustomPreviewTable.this.iVScroll > 0) {
                            --CustomPreviewTable.this.iVScroll;
                        }
                    } else {
                        CustomPreviewTable.this.iVScroll = e.detail == 0x1000002 || e.detail == 0x1000006 ? ++CustomPreviewTable.this.iVScroll : (CustomPreviewTable.this.iVScroll += sb.getSelection() - CustomPreviewTable.this.iLastProcessedVerticalScrollPosition);
                    }
                    CustomPreviewTable.this.iLastProcessedVerticalScrollPosition = sb.getSelection();
                }
                this.redraw();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

