/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.internal;

import java.util.ArrayList;
import org.eclipse.birt.chart.ui.swt.wizard.internal.ColorPalette;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Text;

public class DataDefinitionTextManager {
    private static DataDefinitionTextManager instance;
    private ArrayList textCollection = new ArrayList();

    private DataDefinitionTextManager() {
    }

    public static synchronized DataDefinitionTextManager getInstance() {
        if (instance == null) {
            instance = new DataDefinitionTextManager();
        }
        return instance;
    }

    public void addDataDefinitionText(Text text) {
        this.textCollection.add(text);
    }

    public void removeDataDefinitionText(Text text) {
        this.textCollection.remove(text);
    }

    public void removeAll() {
        this.textCollection.clear();
    }

    public void refreshAll() {
        this.checkAll();
        int length = this.textCollection.size();
        for (int i = 0; i < length; ++i) {
            Text current = (Text)this.textCollection.get(i);
            if (current.getText().length() <= 0) continue;
            Color color = ColorPalette.getInstance().getColor(current.getText());
            current.setBackground(color);
        }
    }

    private void checkAll() {
        int length = this.textCollection.size();
        int i = 0;
        while (i < length) {
            Text current = (Text)this.textCollection.get(i);
            if (current.isDisposed()) {
                this.textCollection.remove(i);
                --length;
                continue;
            }
            ++i;
        }
    }

    public int getNumberOfSameDataDefinition(String expression) {
        this.checkAll();
        int number = 0;
        int length = this.textCollection.size();
        for (int i = 0; i < length; ++i) {
            Text current = (Text)this.textCollection.get(i);
            if (!current.getText().equals(expression)) continue;
            ++number;
        }
        return number;
    }
}

