/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import java.util.ArrayList;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.aggregation.Finance;
import org.eclipse.birt.data.engine.aggregation.SummaryAccumulator;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalIrr
implements IAggregation {
    static /* synthetic */ Class class$org$eclipse$birt$data$engine$aggregation$TotalIrr;

    public String getName() {
        return "IRR";
    }

    public int getType() {
        return 0;
    }

    public boolean[] getParameterDefn() {
        return new boolean[]{true, false};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    private class MyAccumulator
    extends SummaryAccumulator {
        private ArrayList list;
        private double intrate = 0.0;
        private Double ret = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        private MyAccumulator() {
        }

        public void start() {
            super.start();
            this.intrate = 0.0;
            this.list = new ArrayList();
            this.ret = null;
        }

        public void onRow(Object[] args) throws DataException {
            if (!$assertionsDisabled && args.length <= 1) {
                throw new AssertionError();
            }
            if (args[0] != null && args[1] != null) {
                try {
                    Double value = DataTypeUtil.toDouble((Object)args[0]);
                    if (this.list.size() == 0) {
                        this.intrate = DataTypeUtil.toDouble((Object)args[1]);
                    }
                    this.list.add(value);
                }
                catch (BirtException e) {
                    throw new DataException("data.engine.DataConversionError", e);
                }
            }
        }

        public void finish() throws DataException {
            if (this.list.size() > 0) {
                double[] values = new double[this.list.size()];
                for (int i = 0; i < this.list.size(); ++i) {
                    values[i] = (Double)this.list.get(i);
                }
                this.ret = new Double(Finance.irr(values, this.intrate));
            }
            super.finish();
        }

        public Object getSummaryValue() {
            return this.ret;
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$aggregation$TotalIrr == null ? (class$org$eclipse$birt$data$engine$aggregation$TotalIrr = TotalIrr.class$("org.eclipse.birt.data.engine.aggregation.TotalIrr")) : class$org$eclipse$birt$data$engine$aggregation$TotalIrr).desiredAssertionStatus();
        }
    }
}

