/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import java.io.File;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IDataEngineFactory;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.core.DataException;
import org.mozilla.javascript.Scriptable;

public abstract class DataEngine {
    public static String DATASET_CACHE_OPTION = "org.eclipse.birt.data.engine.dataset.cache.option";

    public static DataEngine newDataEngine(DataEngineContext context) {
        try {
            return DataEngine.newDataEngine(null, context);
        }
        catch (BirtException e) {
            throw new RuntimeException(e);
        }
    }

    public static DataEngine newDataEngine(PlatformConfig platformConfig, DataEngineContext dataContext) throws BirtException {
        Platform.startup((PlatformConfig)platformConfig);
        Object factory = Platform.createFactoryObject((String)"org.eclipse.birt.data.DataEngineFactory");
        if (factory instanceof IDataEngineFactory) {
            return ((IDataEngineFactory)factory).createDataEngine(dataContext);
        }
        throw new DataException("load.factory.error");
    }

    public static DataEngine newDataEngine(Scriptable sharedScope) {
        try {
            return DataEngine.newDataEngine(DataEngineContext.newInstance(3, sharedScope, null, null));
        }
        catch (BirtException e) {
            return null;
        }
    }

    public static DataEngine newDataEngine(Scriptable sharedScope, File homeDir) {
        return DataEngine.newDataEngine(sharedScope);
    }

    public abstract IQueryResults getQueryResults(String var1) throws BirtException;

    public abstract void defineDataSource(IBaseDataSourceDesign var1) throws BirtException;

    public abstract void defineDataSet(IBaseDataSetDesign var1) throws BirtException;

    public abstract void clearCache(IBaseDataSourceDesign var1, IBaseDataSetDesign var2) throws BirtException;

    public abstract IPreparedQuery prepare(IQueryDefinition var1) throws BirtException;

    public abstract IPreparedQuery prepare(IQueryDefinition var1, Map var2) throws BirtException;

    public abstract void closeDataSource(String var1) throws BirtException;

    public abstract void shutdown();
}

