/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultObject
implements IResultObject {
    protected IResultClass m_resultClass;
    protected Object[] m_fields;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$eclipse$datatools$connectivity$oda$IClob;
    static /* synthetic */ Class class$org$eclipse$datatools$connectivity$oda$IBlob;

    public ResultObject(IResultClass resultClass, Object[] fields) {
        if (resultClass == null || fields == null) {
            throw new NullPointerException("ResultClass and/or fields should not be null.");
        }
        if (!$assertionsDisabled && resultClass.getFieldCount() != fields.length) {
            throw new AssertionError();
        }
        this.m_resultClass = resultClass;
        try {
            this.initFieldValue(fields);
        }
        catch (DataException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private void initFieldValue(Object[] fields) throws DataException {
        int length = fields.length;
        this.m_fields = new Object[length];
        for (int i = 0; i < length; ++i) {
            if (fields[i] == null) continue;
            Object value = fields[i];
            Class valueClass = this.m_resultClass.getFieldValueClass(i + 1);
            if (!$assertionsDisabled && valueClass == null) {
                throw new AssertionError();
            }
            if (valueClass.isAssignableFrom(class$org$eclipse$datatools$connectivity$oda$IClob == null ? ResultObject.class$("org.eclipse.datatools.connectivity.oda.IClob") : class$org$eclipse$datatools$connectivity$oda$IClob) && fields[i] instanceof IClob) {
                value = this.getClobValue((IClob)fields[i]);
            } else if (valueClass.isAssignableFrom(class$org$eclipse$datatools$connectivity$oda$IBlob == null ? ResultObject.class$("org.eclipse.datatools.connectivity.oda.IBlob") : class$org$eclipse$datatools$connectivity$oda$IBlob) && fields[i] instanceof IBlob) {
                value = this.getBlobValue((IBlob)fields[i]);
            }
            this.m_fields[i] = value;
        }
    }

    private String getClobValue(IClob clob) throws DataException {
        try {
            int len = (int)clob.length();
            return clob.getSubString(1L, len);
        }
        catch (OdaException e) {
            throw new DataException("data.engine.opencloberror", e);
        }
    }

    private byte[] getBlobValue(IBlob blob) throws DataException {
        try {
            int len = (int)blob.length();
            return blob.getBytes(1L, len);
        }
        catch (OdaException e) {
            throw new DataException("data.engine.openbloberror", e);
        }
    }

    public IResultClass getResultClass() {
        return this.m_resultClass;
    }

    public Object getFieldValue(String fieldName) throws DataException {
        int fieldIndex = this.m_resultClass.getFieldIndex(fieldName);
        if (fieldIndex < 1) {
            throw new DataException("data.engine.InvalidFieldName", fieldName);
        }
        return this.getFieldValue(fieldIndex);
    }

    public Object getFieldValue(int fieldIndex) throws DataException {
        this.validateFieldIndex(fieldIndex);
        return this.m_fields[fieldIndex - 1];
    }

    public void setCustomFieldValue(String fieldName, Object value) throws DataException {
        int idx = this.m_resultClass.getFieldIndex(fieldName);
        this.setCustomFieldValue(idx, value);
    }

    public void setCustomFieldValue(int fieldIndex, Object value) throws DataException {
        if (!this.m_resultClass.isCustomField(fieldIndex)) {
            throw new DataException("data.engine.InvalidCustomFieldIdx", new Integer(fieldIndex));
        }
        this.m_fields[fieldIndex - 1] = value;
    }

    private void validateFieldIndex(int index) throws DataException {
        if (index < 1 || index > this.m_fields.length) {
            throw new DataException("data.engine.InvalidFieldIndex", new Integer(index));
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.m_fields.length * 10);
        for (int i = 0; i < this.m_fields.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.m_fields[i] == null ? "null" : this.m_fields[i].toString());
        }
        return buf.toString();
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof IResultObject)) {
            return false;
        }
        IResultObject ob2 = (IResultObject)ob;
        int fieldCount = this.getResultClass().getFieldCount();
        if (fieldCount != ob2.getResultClass().getFieldCount()) {
            return false;
        }
        for (int i = 0; i < fieldCount; ++i) {
            try {
                Object value1 = this.getFieldValue(i + 1);
                Object value2 = ob2.getFieldValue(i + 1);
                if (CacheUtil.compareObjects(value1, value2) == 0) continue;
                return false;
            }
            catch (DataException e) {
                return false;
            }
        }
        return true;
    }

    static {
        $assertionsDisabled = !ResultObject.class.desiredAssertionStatus();
    }
}

