/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.DataBaseExport;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.MergeSortInfo;
import org.eclipse.birt.data.engine.executor.cache.MergeSortUtil;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.executor.cache.SortDataProvider;
import org.eclipse.birt.data.engine.odi.IResultObject;

class DiskMergeSort
extends DataBaseExport {
    private int dataCountOfUnit;
    private int dataCountOfTotal;
    private SortDataProvider dataProvider;
    private MergeSortUtil mergeSortUti;

    DiskMergeSort(Map infoMap, Comparator comparator, ResultObjectUtil resultObjectUtil) {
        this.dataCountOfUnit = Integer.parseInt((String)infoMap.get("dataCountOfUnit"));
        this.dataProvider = new SortDataProvider(this.dataCountOfUnit, (String)infoMap.get("tempDir"), (String)infoMap.get("goalFile"), resultObjectUtil);
        this.mergeSortUti = MergeSortUtil.getUtil(comparator);
    }

    public void exportStartDataToDisk(IResultObject[] resultObjects) throws IOException {
        this.dataCountOfTotal = this.innerExportStartData(resultObjects);
    }

    public int exportRestDataToDisk(IResultObject resultObject, IRowResultSet rs) throws DataException, IOException {
        int dataCountOfRest = this.innerExportRestData(resultObject, rs, this.dataCountOfUnit);
        this.dataCountOfTotal += dataCountOfRest;
        this.dataProvider.initForMerge(this.dataCountOfTotal);
        this.mergeSortOnUnits(this.getMergeCount());
        this.dataProvider.end();
        return dataCountOfRest;
    }

    protected void outputResultObjects(IResultObject[] resultObjects, int indexOfUnit) throws IOException {
        this.mergeSortUti.sortSelf(resultObjects);
        this.dataProvider.writeData(0, indexOfUnit * this.dataCountOfUnit, resultObjects, resultObjects.length);
    }

    private int getMergeCount() {
        int mergeCount = this.dataCountOfTotal / this.dataCountOfUnit;
        if (this.dataCountOfTotal % this.dataCountOfUnit != 0) {
            ++mergeCount;
        }
        if (this.dataCountOfUnit < mergeCount) {
            throw new IllegalArgumentException("the dataCountOfUnit of " + this.dataCountOfUnit + " is less than the merge count of " + mergeCount + ", and then merge sort on file can not be done");
        }
        return mergeCount;
    }

    private void mergeSortOnUnits(int mergeCount) throws IOException {
        MergeSortInfo mergeInfo;
        int[] startIndexArray = new int[mergeCount];
        int[] endIndexArray = new int[mergeCount];
        for (int i = 0; i < mergeCount; ++i) {
            startIndexArray[i] = i == 0 ? 0 : endIndexArray[i - 1];
            endIndexArray[i] = startIndexArray[i] + this.dataCountOfUnit;
            if (endIndexArray[i] <= this.dataCountOfTotal) continue;
            endIndexArray[i] = this.dataCountOfTotal;
        }
        int[] tempBeginIndex = new int[mergeCount];
        for (int i = 0; i < mergeCount; ++i) {
            tempBeginIndex[i] = startIndexArray[i];
        }
        int totalData = endIndexArray[mergeCount - 1] - startIndexArray[0];
        IResultObject[][] resultObjects = new IResultObject[mergeCount][];
        int dataCountOfMergeUnit = this.dataCountOfUnit / mergeCount;
        for (int currData = 0; currData < totalData; currData += mergeInfo.getDataCountOfTotal()) {
            for (int i = 0; i < mergeCount; ++i) {
                int tempEndIndex = tempBeginIndex[i] + dataCountOfMergeUnit;
                if (tempEndIndex > endIndexArray[i]) {
                    tempEndIndex = endIndexArray[i];
                }
                resultObjects[i] = this.dataProvider.readData(tempBeginIndex[i], tempEndIndex);
            }
            int length = 0;
            for (int i = 0; i < mergeCount; ++i) {
                length += resultObjects[i].length;
            }
            IResultObject[] mergedRowDatas = new IResultObject[length];
            mergeInfo = this.mergeSortUti.mergeSort(resultObjects, mergedRowDatas);
            this.dataProvider.writeData(1, currData, mergedRowDatas, mergeInfo.getDataCountOfTotal());
            for (int i = 0; i < mergeCount; ++i) {
                int n = i;
                tempBeginIndex[n] = tempBeginIndex[n] + mergeInfo.getDataCountOfUnit(i);
            }
        }
    }
}

